/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import filter.model.Filter;
import filter.model.FilterManager;
import giny.model.Edge;
import java.beans.PropertyChangeEvent;
import javax.swing.event.SwingPropertyChangeSupport;

public class CsEdgeTypeFilter
implements Filter {
    protected String selectedAttribute;
    protected String searchString;
    public static String SEARCH_STRING_EVENT = "SEARCH_STRING_EVENT";
    public static String SELECTED_ATTRIBUTE_EVENT = "SELECTED_ATTRIBUTE_EVENT";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_ID = "CsEdgeTypeFilter";
    protected CyNetwork network;
    protected GraphObjAttributes edgeAttributes;
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public CsEdgeTypeFilter(CyNetwork network, String selectedAttribute, String searchString, String identifier) {
        this.network = network;
        this.edgeAttributes = network.getEdgeAttributes();
        this.selectedAttribute = selectedAttribute;
        this.searchString = searchString;
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        Object value = null;
        if (object instanceof Edge) {
            Edge edge = (Edge)object;
            value = this.edgeAttributes.getValue(this.selectedAttribute, this.edgeAttributes.getCanonicalName((Object)edge));
            System.out.println("Value returned for edge: " + edge.getIdentifier() + " attribute: " + this.selectedAttribute + " was: " + value);
        }
        if (!(value instanceof String)) {
            return false;
        }
        String[] pattern = this.searchString.split("\\s");
        for (int p = 0; p < pattern.length; ++p) {
            if (!Strings.isLike((String)((String)value), (String)pattern[p], (int)0, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return other_object instanceof CsEdgeTypeFilter && ((CsEdgeTypeFilter)other_object).getSearchString().equals(this.getSearchString());
    }

    public Object clone() {
        return new CsEdgeTypeFilter(this.network, this.selectedAttribute, this.searchString, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == SEARCH_STRING_EVENT) {
            System.out.println("Search String Changed to " + (String)e.getNewValue());
            this.setSearchString((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == SELECTED_ATTRIBUTE_EVENT) {
            this.setSelectedAttribute((String)e.getNewValue());
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String search_string) {
        this.searchString = search_string;
        this.fireSearchStringChanged();
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(SEARCH_STRING_EVENT, null, this.searchString);
    }

    public String getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public void setSelectedAttribute(String new_attr) {
        this.selectedAttribute = new_attr;
        this.fireSelectedAttributeModified();
    }

    public void fireSelectedAttributeModified() {
        this.pcs.firePropertyChange(SELECTED_ATTRIBUTE_EVENT, null, this.selectedAttribute);
    }

    public String output() {
        return null;
    }

    public Filter input(String desc) {
        return null;
    }
}

