/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import filter.cytoscape.CsAttributeValueFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CsAttributeValueFilterEditor
extends FilterEditor
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox defaultCompareBox;
    protected JComboBox defaultSearchBox;
    protected JComboBox firstCompareBox;
    protected JComboBox firstSearchBox;
    protected JComboBox secondCompareBox;
    protected JComboBox secondSearchBox;
    protected DefaultListModel attributeModel;
    protected JList attributeList;
    protected JTextField attributeSearchField;
    protected JCheckBox multiSelection;
    protected JCheckBox rangeToggle;
    protected CsAttributeValueFilter filter;
    protected CyNetwork network;
    protected GraphObjAttributes nodeAttributes;
    protected GraphObjAttributes edgeAttributes;
    protected String DEFAULT_FIRST_SEARCH_STRING = "";
    protected String RESET_FIRST_SEARCH_STRING;
    protected Double DEFAULT_SECOND_SEARCH_STRING = new Double(0.0);
    protected Double RESET_SECOND_SEARCH_STRING;
    protected boolean DEFAULT_BETWEEN = false;
    protected boolean RESET_BETWEEN;
    protected String DEFAULT_FIRST_COMPARE = CsAttributeValueFilter.LE;
    protected String RESET_FIRST_COMPARE;
    protected String DEFAULT_SECOND_COMPARE = CsAttributeValueFilter.LE;
    protected String RESET_SECOND_COMPARE;
    protected String DEFAULT_FILTER_NAME = "AttVal: ";
    protected String RESET_FILTER_NAME;
    protected String[] DEFAULT_SELECTED_ATTRIBUTES = new String[]{""};
    protected String[] RESET_SELECTED_ATTRIBUTES;
    protected JPanel searchPanel;
    protected JPanel attributePanel;
    protected JPanel defaultSearchPanel;
    protected JPanel firstSearchPanel;
    protected JPanel secondSearchPanel;

    public CsAttributeValueFilterEditor(CyNetwork network) {
        this.network = network;
        this.nodeAttributes = network.getNodeAttributes();
        this.edgeAttributes = network.getEdgeAttributes();
        this.identifier = "Attribute Value";
        this.setBorder(new TitledBorder("Attribute Value Filter"));
        this.setLayout(new BorderLayout());
        JPanel namePanel = new JPanel();
        namePanel.add(new JButton(new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).updateAttributeModel();
                    }
                });
            }

            static /* synthetic */ CsAttributeValueFilterEditor access$000(1 x0) {
                return x0.CsAttributeValueFilterEditor.this;
            }
        }));
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.rangeToggle = new JCheckBox("Ranged Selection", true);
        namePanel.add(this.rangeToggle);
        this.rangeToggle.addActionListener(this);
        this.add((Component)namePanel, "North");
        this.searchPanel = new JPanel();
        this.add((Component)this.searchPanel, "Center");
        this.attributePanel = new JPanel();
        this.attributeList = new JList();
        this.attributeList.addListSelectionListener(this);
        this.attributeSearchField = new JTextField(10);
        this.attributeSearchField.addActionListener(this);
        JScrollPane scoll = new JScrollPane(this.attributeList);
        this.multiSelection = new JCheckBox("Multi", true);
        this.multiSelection.addActionListener(this);
        this.attributeList.addPropertyChangeListener(this);
        this.attributePanel.setLayout(new BorderLayout());
        this.attributePanel.add((Component)scoll, "Center");
        this.attributePanel.add((Component)this.attributeSearchField, "North");
        this.attributePanel.add((Component)this.multiSelection, "South");
        this.defaultSearchPanel = new JPanel();
        this.defaultCompareBox = new JComboBox<Object>(new Object[]{CsAttributeValueFilter.EQ, CsAttributeValueFilter.NE, CsAttributeValueFilter.GT, CsAttributeValueFilter.GE, CsAttributeValueFilter.LT, CsAttributeValueFilter.LE});
        this.defaultCompareBox.setSelectedItem(CsAttributeValueFilter.EQ);
        this.defaultSearchPanel.add(this.defaultCompareBox);
        this.defaultSearchBox = new JComboBox();
        this.defaultSearchBox.setEditable(true);
        this.defaultSearchPanel.add(this.defaultSearchBox);
        this.firstSearchPanel = new JPanel();
        this.firstSearchBox = new JComboBox();
        this.firstSearchBox.setEditable(true);
        this.firstSearchPanel.add(this.firstSearchBox);
        this.firstCompareBox = new JComboBox<Object>(new Object[]{CsAttributeValueFilter.LT, CsAttributeValueFilter.LE});
        this.firstCompareBox.setSelectedItem(this.DEFAULT_FIRST_COMPARE);
        this.firstSearchPanel.add(this.firstCompareBox);
        this.secondSearchPanel = new JPanel();
        this.secondCompareBox = new JComboBox<Object>(new Object[]{CsAttributeValueFilter.LT, CsAttributeValueFilter.LE});
        this.secondCompareBox.setSelectedItem(this.DEFAULT_SECOND_COMPARE);
        this.secondSearchPanel.add(this.secondCompareBox);
        this.secondSearchBox = new JComboBox();
        this.secondSearchBox.setEditable(true);
        this.secondSearchPanel.add(this.secondSearchBox);
        this.searchPanel.add(this.attributePanel);
        this.searchPanel.add(this.defaultSearchPanel);
        this.updateAttributeModel();
        this.setDefaults();
        this.validate();
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return CsAttributeValueFilter.FILTER_ID;
    }

    public Filter getFilter() {
        String[] selected_attributes = this.getSelectedAttributes();
        String first_search = this.getFirstSearch();
        Double second_search = this.getSecondSearch();
        String first_compare = this.getFirstCompare();
        String second_compare = this.getSecondCompare();
        boolean between = this.rangeToggle.isSelected();
        if (between ? first_search == null || second_search == null || first_compare == null || second_compare == null || selected_attributes == null : first_search == null || first_compare == null || selected_attributes == null) {
            return null;
        }
        return new CsAttributeValueFilter(this.network, this.getFilterName(), selected_attributes, first_search, second_search, first_compare, second_compare, between);
    }

    public void editFilter(Filter filter) {
        if (filter instanceof CsAttributeValueFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (CsAttributeValueFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public String getFirstSearch() {
        if (this.rangeToggle.isSelected()) {
            return (String)this.firstSearchBox.getSelectedItem();
        }
        return (String)this.defaultSearchBox.getSelectedItem();
    }

    public void setFirstSearch(String search) {
        this.firstSearchBox.setSelectedItem(search);
        this.defaultSearchBox.setSelectedItem(search);
    }

    public Double getSecondSearch() {
        try {
            return new Double((String)this.secondSearchBox.getSelectedItem());
        }
        catch (Exception e) {
            return new Double(Double.NaN);
        }
    }

    public void setSecondSearch(Double search) {
        this.secondSearchBox.setSelectedItem(search.toString());
    }

    public String getFirstCompare() {
        if (this.rangeToggle.isSelected()) {
            return (String)this.firstCompareBox.getSelectedItem();
        }
        return (String)this.defaultCompareBox.getSelectedItem();
    }

    public void setFirstCompare(String comp) {
        this.firstCompareBox.setSelectedItem(comp);
        this.defaultCompareBox.setSelectedItem(comp);
    }

    public String getSecondCompare() {
        return (String)this.secondCompareBox.getSelectedItem();
    }

    public void setSecondCompare(String comp) {
        this.secondCompareBox.setSelectedItem(comp);
    }

    public boolean getBetween() {
        return this.rangeToggle.isSelected();
    }

    public void setBetween(Boolean bool) {
        this.rangeToggle.setSelected(bool);
    }

    public void setBetween(boolean bool) {
        this.rangeToggle.setSelected(bool);
    }

    public String[] getSelectedAttributes() {
        Object[] sel = this.attributeList.getSelectedValues();
        String[] ret = new String[sel.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)sel[i];
        }
        return ret;
    }

    public void setSelectedAttributes(String[] atts) {
        int[] indices = new int[atts.length];
        for (int i = 0; i < atts.length; ++i) {
            indices[i] = this.attributeModel.indexOf(atts[i]);
        }
        this.attributeList.setSelectedIndices(indices);
    }

    public void setDefaults() {
        this.setSelectedAttributes(this.DEFAULT_SELECTED_ATTRIBUTES);
        this.setFilterName(this.DEFAULT_FILTER_NAME);
        this.setFirstSearch(this.DEFAULT_FIRST_SEARCH_STRING);
        this.setSecondSearch(this.DEFAULT_SECOND_SEARCH_STRING);
        this.setFirstCompare(this.DEFAULT_FIRST_COMPARE);
        this.setSecondCompare(this.DEFAULT_SECOND_COMPARE);
        this.setBetween(this.DEFAULT_BETWEEN);
        this.rangeToggle.setSelected(this.DEFAULT_BETWEEN);
        this.updateRangeToggle();
    }

    public void readInFilter() {
        this.RESET_FILTER_NAME = this.filter.toString();
        this.RESET_SELECTED_ATTRIBUTES = this.filter.getSelectedAttributes();
        this.RESET_FIRST_SEARCH_STRING = this.filter.getFirstSearch();
        this.RESET_SECOND_SEARCH_STRING = this.filter.getSecondSearch();
        this.RESET_BETWEEN = this.filter.getBetween();
        this.RESET_FIRST_COMPARE = this.filter.getFirstCompare();
        this.RESET_SECOND_COMPARE = this.filter.getSecondCompare();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSelectedAttributes(this.RESET_SELECTED_ATTRIBUTES);
        this.setFilterName(this.RESET_FILTER_NAME);
        this.setFirstSearch(this.RESET_FIRST_SEARCH_STRING);
        this.setSecondSearch(this.RESET_SECOND_SEARCH_STRING);
        this.setFirstCompare(this.RESET_FIRST_COMPARE);
        this.setSecondCompare(this.RESET_SECOND_COMPARE);
        this.setBetween(this.RESET_BETWEEN);
        this.rangeToggle.setSelected(this.RESET_BETWEEN);
        this.updateRangeToggle();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.attributeList) {
            String[] sel_atts = this.getSelectedAttributes();
            if (sel_atts.length == 0) {
                return;
            }
            System.out.println("Attribute: " + sel_atts[0]);
            Object[] node_values = this.nodeAttributes.getUniqueValues(sel_atts[0]);
            Object[] edge_values = this.edgeAttributes.getUniqueValues(sel_atts[0]);
            if (node_values == null) {
                System.out.println("node values returned null");
                node_values = new Object[]{};
            }
            if (edge_values == null) {
                System.out.println("edge values returned null");
                edge_values = new Object[]{};
            }
            Object[] new_values = new Object[node_values.length + edge_values.length];
            System.arraycopy(node_values, 0, new_values, 0, node_values.length);
            System.arraycopy(edge_values, 0, new_values, node_values.length, edge_values.length);
            Object[] values = new_values;
            for (int i = 1; i < sel_atts.length; ++i) {
                node_values = this.nodeAttributes.getUniqueValues(sel_atts[i]);
                edge_values = this.edgeAttributes.getUniqueValues(sel_atts[i]);
                if (node_values == null) {
                    System.out.println("node values returned null");
                    node_values = new Object[]{};
                }
                if (edge_values == null) {
                    System.out.println("edge values returned null");
                    edge_values = new Object[]{};
                }
                new_values = new Object[values.length + node_values.length + edge_values.length];
                System.arraycopy(values, 0, new_values, 0, values.length);
                System.arraycopy(node_values, 0, new_values, values.length, node_values.length);
                System.arraycopy(edge_values, 0, new_values, node_values.length + values.length, edge_values.length);
                values = new_values;
            }
            if (values == null) {
                return;
            }
            Arrays.sort(values);
            this.defaultSearchBox.setModel(new DefaultComboBoxModel<Object>(values));
            this.firstSearchBox.setModel(new DefaultComboBoxModel<Object>(values));
            this.secondSearchBox.setModel(new DefaultComboBoxModel<Object>(values));
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rangeToggle) {
            this.updateRangeToggle();
        } else if (e.getSource() == this.attributeSearchField) {
            this.searchAttributes();
        } else if (e.getSource() == this.multiSelection) {
            this.switchMultiSelection();
        }
    }

    protected void searchAttributes() {
        ArrayList<String> attributes_pass = new ArrayList<String>();
        Enumeration att_enum = this.attributeModel.elements();
        String[] pattern = this.attributeSearchField.getText().split("\\s");
        while (att_enum.hasMoreElements()) {
            String s = (String)att_enum.nextElement();
            for (int p = 0; p < pattern.length; ++p) {
                if (!Strings.isLike((String)s.toString(), (String)pattern[p], (int)0, (boolean)true)) continue;
                attributes_pass.add(s);
                System.out.println("Attribute: " + s.toString() + " matches " + pattern[p]);
            }
        }
        Iterator api = attributes_pass.iterator();
        DefaultListModel alm = new DefaultListModel();
        while (api.hasNext()) {
            alm.addElement(api.next());
        }
        this.attributeList.setModel(alm);
    }

    protected void switchMultiSelection() {
        if (this.multiSelection.isSelected()) {
            this.attributeList.setSelectionMode(2);
        } else {
            this.attributeList.setSelectionMode(0);
        }
    }

    protected void updateAttributeModel() {
        int i;
        this.attributeModel = new DefaultListModel();
        String[] natts = this.nodeAttributes.getAttributeNames();
        String[] eatts = this.edgeAttributes.getAttributeNames();
        for (i = 0; i < natts.length; ++i) {
            this.attributeModel.addElement(natts[i]);
        }
        for (i = 0; i < eatts.length; ++i) {
            this.attributeModel.addElement(eatts[i]);
        }
        this.attributeList.setModel(this.attributeModel);
    }

    protected void updateRangeToggle() {
        if (this.rangeToggle.isSelected()) {
            this.searchPanel.removeAll();
            this.searchPanel.add(this.firstSearchPanel);
            this.searchPanel.add(this.attributePanel);
            this.searchPanel.add(this.secondSearchPanel);
            this.validate();
            this.repaint();
        } else {
            this.searchPanel.removeAll();
            this.searchPanel.add(this.attributePanel);
            this.searchPanel.add(this.defaultSearchPanel);
            this.validate();
            this.repaint();
        }
    }
}

