/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import filter.model.Filter;
import filter.model.FilterManager;
import giny.model.Edge;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import javax.swing.event.SwingPropertyChangeSupport;

public class CsAttributeValueFilter
implements Filter {
    protected String[] selectedAttributes;
    protected String firstSearch;
    protected Double secondSearch;
    protected String firstCompare;
    protected String secondCompare;
    protected boolean between;
    public static String EQ = "==";
    public static String NE = "!=";
    public static String GT = ">";
    public static String GE = ">=";
    public static String LT = "<";
    public static String LE = "<=";
    public static String BETWEEN_EVENT = "BETWEEN_EVENT";
    public static String FIRST_SEARCH_EVENT = "FIRST_SEARCH_EVENT";
    public static String SECOND_SEARCH_EVENT = "SECOND_SEARCH_EVENT";
    public static String FIRST_COMPARE_EVENT = "FIRST_COMPARE_EVENT";
    public static String SECOND_COMPARE_EVENT = "SECOND_COMPARE_EVENT";
    public static String SELECTED_ATTRIBUTES_EVENT = "SELECTED_ATTRIBUTES_EVENT";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_ID = "CsAttributeValueFilter";
    protected CyNetwork network;
    protected GraphObjAttributes nodeAttributes;
    protected GraphObjAttributes edgeAttributes;
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public CsAttributeValueFilter(CyNetwork network, String identifier, String[] selectedAttributes, String firstSearch, Double secondSearch, String firstCompare, String secondCompare, boolean between) {
        this.network = network;
        this.nodeAttributes = network.getNodeAttributes();
        this.edgeAttributes = network.getEdgeAttributes();
        this.identifier = identifier;
        this.selectedAttributes = selectedAttributes;
        this.firstSearch = firstSearch;
        this.secondSearch = secondSearch;
        this.firstCompare = firstCompare;
        this.secondCompare = secondCompare;
        this.between = between;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        for (int i = 0; i < this.selectedAttributes.length; ++i) {
            if (!this.passesSpecificAttribute(object, this.selectedAttributes[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean passesSpecificAttribute(Object object, String attribute) {
        void var3_3;
        double first_val;
        block19: {
            Object value;
            if (object instanceof Node) {
                value = this.nodeAttributes.getValue(attribute, ((Node)object).getIdentifier());
            } else if (object instanceof Edge) {
                value = this.edgeAttributes.getValue(attribute, ((Edge)object).getIdentifier());
            } else {
                return false;
            }
            first_val = 0.0;
            try {
                Double n = new Double(this.firstSearch);
                first_val = n;
            }
            catch (Exception e) {
                if (!(var3_3 instanceof String)) break block19;
                String[] pattern = this.firstSearch.split("\\s");
                for (int p = 0; p < pattern.length; ++p) {
                    if (!(Strings.isLike((String)((String)var3_3), (String)pattern[p], (int)0, (boolean)true) ? this.firstCompare.equals(EQ) : this.firstCompare.equals(NE))) continue;
                    return true;
                }
                return false;
            }
        }
        if (var3_3 instanceof Number) {
            double val = (Double)var3_3;
            if (!this.between) {
                if (this.firstCompare.equals(EQ) && val == first_val) {
                    return true;
                }
                if (this.firstCompare.equals(NE) && val != first_val) {
                    return true;
                }
                if (this.firstCompare.equals(GT) && val > first_val) {
                    return true;
                }
                if (this.firstCompare.equals(GE) && val >= first_val) {
                    return true;
                }
                if (this.firstCompare.equals(LT) && val < first_val) {
                    return true;
                }
                return this.firstCompare.equals(LE) && val <= first_val;
            }
            double second_val = 0.0;
            try {
                second_val = this.secondSearch;
            }
            catch (Exception e) {
                return false;
            }
            if (this.firstCompare.equals(LT) && this.secondCompare.equals(LT) && first_val < val && val < second_val) {
                return true;
            }
            if (this.firstCompare.equals(LE) && this.secondCompare.equals(LT) && first_val <= val && val < second_val) {
                return true;
            }
            if (this.firstCompare.equals(LE) && this.secondCompare.equals(LE) && first_val <= val && val <= second_val) {
                return true;
            }
            return this.firstCompare.equals(LT) && this.secondCompare.equals(LE) && first_val < val && val <= second_val;
        }
        return false;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return false;
    }

    public Object clone() {
        return new CsAttributeValueFilter(this.network, this.identifier, this.selectedAttributes, this.firstSearch, this.secondSearch, this.firstCompare, this.secondCompare, this.between);
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == BETWEEN_EVENT) {
            this.setBetween((Boolean)e.getNewValue());
        } else if (e.getPropertyName() == FIRST_SEARCH_EVENT) {
            this.setFirstSearch((String)e.getNewValue());
        } else if (e.getPropertyName() == SECOND_SEARCH_EVENT) {
            this.setSecondSearch((Double)e.getNewValue());
        } else if (e.getPropertyName() == FIRST_COMPARE_EVENT) {
            this.setFirstCompare((String)e.getNewValue());
        } else if (e.getPropertyName() == SECOND_COMPARE_EVENT) {
            this.setSecondCompare((String)e.getNewValue());
        } else if (e.getPropertyName() == SELECTED_ATTRIBUTES_EVENT) {
            this.setSelectedAttributes((String[])e.getNewValue());
        } else if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        }
    }

    public boolean getBetween() {
        return this.between;
    }

    public void setBetween(Boolean bool) {
        this.between = bool;
        this.fireBetweenChanged();
    }

    public void setBetween(boolean bool) {
        this.between = bool;
        this.fireBetweenChanged();
    }

    public void fireBetweenChanged() {
        this.pcs.firePropertyChange(BETWEEN_EVENT, null, new Boolean(this.between));
    }

    public String getFirstSearch() {
        return this.firstSearch;
    }

    public void setFirstSearch(String s) {
        this.firstSearch = s;
        this.fireFirstSearchChanged();
    }

    public void fireFirstSearchChanged() {
        this.pcs.firePropertyChange(FIRST_SEARCH_EVENT, null, this.firstSearch);
    }

    public Double getSecondSearch() {
        return this.secondSearch;
    }

    public void setSecondSearch(Double s) {
        this.secondSearch = s;
        this.fireSecondSearchChanged();
    }

    public void fireSecondSearchChanged() {
        this.pcs.firePropertyChange(SECOND_SEARCH_EVENT, null, this.secondSearch);
    }

    public String getFirstCompare() {
        return this.firstCompare;
    }

    public void setFirstCompare(String s) {
        this.firstCompare = s;
        this.fireFirstCompareChanged();
    }

    public void fireFirstCompareChanged() {
        this.pcs.firePropertyChange(FIRST_COMPARE_EVENT, null, this.firstCompare);
    }

    public String getSecondCompare() {
        return this.secondCompare;
    }

    public void setSecondCompare(String s) {
        this.secondCompare = s;
        this.fireSecondCompareChanged();
    }

    public void fireSecondCompareChanged() {
        this.pcs.firePropertyChange(SECOND_COMPARE_EVENT, null, this.secondCompare);
    }

    public String[] getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public void setSelectedAttributes(String[] new_attr) {
        this.selectedAttributes = new_attr;
        this.fireSelectedAttributesModified();
    }

    public void fireSelectedAttributesModified() {
        this.pcs.firePropertyChange(SELECTED_ATTRIBUTES_EVENT, null, this.selectedAttributes);
    }

    public String output() {
        return null;
    }

    public Filter input(String desc) {
        return null;
    }
}

