/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import filter.cytoscape.BooleanMetaFilter;
import filter.model.Filter;
import filter.model.FilterManager;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BooleanMetaFilterEditor
extends FilterEditor
implements ActionListener,
ListSelectionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JList filterList;
    protected JComboBox comparisonBox;
    protected Set filters;
    protected Vector listModel;
    protected BooleanMetaFilter filter;
    protected String DEFAULT_FILTER_NAME = "BooleanMeta: ";
    protected String RESET_FITLER_NAME;
    protected String DEFAULT_COMPARISON = BooleanMetaFilter.AND;
    protected String RESET_COMPARISON;
    protected Object[] DEFAULT_FILTERS = new Object[0];
    protected Object[] RESET_FILTERS;
    protected Class RESET_CLASS;
    protected Class NODE_CLASS;
    protected Class EDGE_CLASS;
    protected Class NUMBER_CLASS;
    protected Class DEFAULT_CLASS;

    public BooleanMetaFilterEditor(Set filters) {
        this.filters = filters;
        this.identifier = "Boolean Filter";
        this.setBorder(new TitledBorder("Boolean Meta-Filter - Select nodes or edges based on a combination of other filters"));
        this.setLayout(new BorderLayout());
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        this.nameField.setText(this.identifier);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add((Component)namePanel, "North");
        JPanel all_panel = new JPanel();
        all_panel.setLayout(new BorderLayout());
        this.filterList = new JList();
        this.updateFilterList();
        this.filterList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.filterList);
        all_panel.add((Component)scrollPane, "Center");
        JPanel comparisonPanel = new JPanel();
        comparisonPanel.add(new JLabel("Select objects that pass "));
        this.comparisonBox = new JComboBox();
        this.comparisonBox.addItem(BooleanMetaFilter.AND);
        this.comparisonBox.addItem(BooleanMetaFilter.OR);
        this.comparisonBox.addItem(BooleanMetaFilter.XOR);
        this.comparisonBox.setSelectedIndex(0);
        this.comparisonBox.setEditable(false);
        this.comparisonBox.addActionListener(this);
        comparisonPanel.add(this.comparisonBox);
        comparisonPanel.add(new JLabel(" selected filters"));
        all_panel.add((Component)comparisonPanel, "North");
        all_panel.add((Component)new JButton(new AbstractAction("Update List of Filters"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        BooleanMetaFilterEditor.access$100(1.access$000(this.this$1));
                    }
                });
            }

            static /* synthetic */ BooleanMetaFilterEditor access$000(1 x0) {
                return x0.BooleanMetaFilterEditor.this;
            }
        }), "South");
        this.add((Component)all_panel, "Center");
        this.setDefaults();
    }

    private void updateFilterList() {
        this.listModel = new Vector();
        Iterator filterNameIt = this.filters.iterator();
        while (filterNameIt.hasNext()) {
            Filter nextFilter = FilterManager.defaultManager().getFilter((String)filterNameIt.next());
            if (nextFilter == null) continue;
            this.listModel.add(nextFilter);
        }
        this.filterList.setListData(this.listModel);
        this.filterList.addListSelectionListener(this);
        this.filterList.clearSelection();
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return BooleanMetaFilter.FILTER_ID;
    }

    public Filter getFilter() {
        Object[] filterArray = this.getFilters();
        String currentComparison = (String)this.comparisonBox.getSelectedItem();
        if (filterArray == null || filterArray.length == 0 || this.nameField.getText() == null) {
            return null;
        }
        return new BooleanMetaFilter(filterArray, currentComparison, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof BooleanMetaFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (BooleanMetaFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public Object[] getFilters() {
        return this.filterList.getSelectedValues();
    }

    public void setFilters(Object[] array) {
        this.updateFilterList();
        for (int idx = 0; idx < array.length; ++idx) {
            int index = this.listModel.indexOf(array[idx]);
            if (index <= -1) continue;
            this.filterList.addSelectionInterval(index, index);
        }
    }

    public String getComparison() {
        return (String)this.comparisonBox.getSelectedItem();
    }

    public void setComparison(String comparison) {
        this.comparisonBox.setSelectedItem(comparison);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.filterList) {
            this.fireFilterChanged();
        } else if (e.getSource() == this.comparisonBox) {
            this.fireComparisonChanged();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.fireFilterChanged();
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(BooleanMetaFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireFilterChanged() {
        this.pcs.firePropertyChange(BooleanMetaFilter.FILTER_BOX_EVENT, null, this.getFilters());
    }

    public void fireComparisonChanged() {
        this.pcs.firePropertyChange(BooleanMetaFilter.COMPARISON_EVENT, null, this.comparisonBox.getSelectedItem());
    }

    public void setDefaults() {
        this.setFilters(this.DEFAULT_FILTERS);
        this.setComparison(this.DEFAULT_COMPARISON);
    }

    public void readInFilter() {
        this.RESET_COMPARISON = this.filter.getComparison();
        this.RESET_FILTERS = this.filter.getFilters();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setFilters(this.RESET_FILTERS);
        this.setComparison(this.RESET_COMPARISON);
        this.fireFilterNameChanged();
    }

    static /* synthetic */ void access$100(BooleanMetaFilterEditor x0) {
        x0.updateFilterList();
    }
}

