/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import filter.model.Filter;
import filter.model.FilterManager;
import java.beans.PropertyChangeEvent;
import javax.swing.event.SwingPropertyChangeSupport;

public class BooleanMetaFilter
implements Filter {
    protected Object[] filters;
    protected String comparison;
    public static String AND = "ALL";
    public static String OR = "AT LEAST ONE";
    public static String XOR = "ONLY ONE";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_ID = "BooleanMetaFilter";
    public static String COMPARISON_EVENT = "COMPARISON_EVENT";
    public static String FILTER_EVENT = "FILTER_EVENT";
    public static String FILTER_BOX_EVENT = "FILTER_BOX";
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public BooleanMetaFilter(Object[] filters, String comparison, String identifier) {
        if (filters.length > 0 && filters[0] instanceof String) {
            Object[] actual_filters = new Object[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                actual_filters[i] = FilterManager.defaultManager().getFilter((String)filters[i]);
            }
            this.filters = actual_filters;
        } else {
            this.filters = filters;
        }
        this.comparison = comparison;
        this.identifier = identifier;
    }

    public BooleanMetaFilter(String filter_strings, String comparison, String identifier) {
        String[] filters = filter_strings.split(":");
        Object[] actual_filters = new Object[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            actual_filters[i] = FilterManager.defaultManager().getFilter(filters[i]);
        }
        this.filters = actual_filters;
        this.comparison = comparison;
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        if (this.filters.length == 0) {
            return false;
        }
        int count = 0;
        for (int idx = 0; idx < this.filters.length; ++idx) {
            boolean filterResult = ((Filter)this.filters[idx]).passesFilter(object);
            if (this.comparison == AND && !filterResult) {
                return false;
            }
            if (this.comparison == OR && filterResult) {
                return true;
            }
            if (this.comparison != XOR || !filterResult || ++count <= 1) continue;
            return false;
        }
        if (this.comparison == XOR && count == 1) {
            return true;
        }
        return this.comparison == AND;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return super.equals(other_object);
    }

    public Object clone() {
        return new BooleanMetaFilter(this.filters, this.comparison, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_BOX_EVENT) {
            this.setFilters((Object[])e.getNewValue());
        } else if (e.getPropertyName() == COMPARISON_EVENT) {
            this.setComparison((String)e.getNewValue());
        }
    }

    public void setComparison(String comparison) {
        this.comparison = comparison;
        this.pcs.firePropertyChange(COMPARISON_EVENT, null, comparison);
    }

    public String getComparison() {
        return this.comparison;
    }

    public void setFilters(Object[] filters) {
        this.filters = filters;
        this.pcs.firePropertyChange(FILTER_BOX_EVENT, null, filters);
    }

    public Object[] getFilters() {
        return this.filters;
    }

    public String output() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filter.cytoscape.BooleanMetaFilter,");
        for (int i = 0; i < this.filters.length; ++i) {
            buffer.append(this.filters[i].toString());
            if (i == this.filters.length - 1) continue;
            buffer.append(":");
        }
        buffer.append("," + this.getComparison() + ",");
        buffer.append(this.toString());
        return buffer.toString();
    }

    public Filter input(String desc) {
        return null;
    }
}

