/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import giny.model.GraphPerspective;
import giny.view.GraphView;
import java.awt.Color;
import java.util.Iterator;
import phoebe.util.GraphPartition;
import phoebe.util.SpanningTrees;

public class TreeLayout {
    static double increment = 50.0;
    GraphPerspective spanning;
    GraphPerspective perspective;
    GraphView view;
    OpenIntIntHashMap completed_nodes;

    public GraphPerspective doLayout(GraphView view) {
        this.view = view;
        this.perspective = view.getGraphPerspective();
        GraphPartition gp = new GraphPartition(this.perspective);
        Iterator partitions = gp.partition().iterator();
        int partition_count = 1;
        IntArrayList all_partitions = new IntArrayList(this.perspective.getEdgeCount());
        ++partition_count;
        int[] edges = (int[])partitions.next();
        all_partitions.addAllOf(new IntArrayList(edges));
        GraphPerspective partition = this.perspective.createGraphPerspective(new int[0], edges);
        SpanningTrees st = new SpanningTrees(partition);
        this.spanning = partition.createGraphPerspective(new int[0], st.mcst());
        double current_x = 0 * partition_count;
        double current_y = 0.0;
        this.completed_nodes = new OpenIntIntHashMap(partition.getNodeCount());
        int start_index = partition.getRootGraphNodeIndex(1);
        view.setNodeDoubleProperty(start_index, 0, current_x);
        view.setNodeDoubleProperty(start_index, 1, current_y);
        System.out.println(" Positioning : " + start_index + " " + current_x + " " + current_y);
        view.getNodeView(start_index).setUnselectedPaint(Color.cyan);
        this.completed_nodes.put(start_index, 1);
        this.layoutChildren(start_index, current_x, current_y += increment);
        all_partitions.trimToSize();
        return this.perspective.createGraphPerspective(new int[0], all_partitions.elements());
    }

    public double layoutChildren(int parent, double current_x, double current_y) {
        int index;
        int i;
        double child_x = current_x;
        int[] neighbors = this.spanning.neighborsArray(parent);
        for (i = 0; i < neighbors.length; ++i) {
            index = this.spanning.getRootGraphNodeIndex(neighbors[i]);
            if (this.completed_nodes.get(index) != 0) continue;
            System.out.println("    Setting Child of: " + parent + " -> " + index);
            this.view.setNodeDoubleProperty(index, 0, current_x);
            this.view.setNodeDoubleProperty(index, 1, current_y);
            System.out.println("      Positioning :" + index + " " + current_x + " " + current_y);
            this.view.getNodeView(index).setUnselectedPaint(Color.cyan);
            child_x += increment;
        }
        current_y += increment;
        current_x = 0.0;
        for (i = 0; i < neighbors.length; ++i) {
            index = this.spanning.getRootGraphNodeIndex(neighbors[i]);
            if (this.completed_nodes.get(index) != 0) continue;
            this.completed_nodes.put(index, 1);
            current_x += this.layoutChildren(neighbors[i], current_x, current_y);
        }
        return child_x;
    }
}

