/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import giny.model.GraphPerspective;
import giny.model.RootGraph;

public class SpanningTrees {
    protected GraphPerspective perspective;
    OpenIntIntHashMap nodes;

    public SpanningTrees(GraphPerspective perspective) {
        this.perspective = perspective;
    }

    public GraphPerspective getGraphPerspective() {
        return this.perspective;
    }

    public void setGraphPerspective(GraphPerspective perspective) {
        this.perspective = perspective;
    }

    public int[] mcst() {
        OpenIntIntHashMap edges = new OpenIntIntHashMap(this.perspective.getEdgeCount());
        this.nodes = new OpenIntIntHashMap(this.perspective.getNodeCount());
        int[] edge_indices = this.perspective.getEdgeIndicesArray();
        boolean inititalized = false;
        int nodes_left = this.perspective.getNodeCount();
        while (nodes_left > 0) {
            for (int i = 0; i < edge_indices.length; ++i) {
                int target = this.perspective.getEdgeTargetIndex(edge_indices[i]);
                int source = this.perspective.getEdgeSourceIndex(edge_indices[i]);
                if (!inititalized) {
                    this.nodes.put(source, 1);
                    this.nodes.put(target, 1);
                    --nodes_left;
                    --nodes_left;
                    inititalized = true;
                    edges.put(edge_indices[i], 1);
                    continue;
                }
                if (edges.get(edge_indices[i]) != 0 || this.nodes.get(source) == 1 && this.nodes.get(target) == 1) continue;
                if (this.nodes.get(source) == 1 && this.nodes.get(target) == 0) {
                    this.nodes.put(target, 1);
                    --nodes_left;
                    edges.put(edge_indices[i], 1);
                    continue;
                }
                if (this.nodes.get(source) != 0 || this.nodes.get(target) != 1) continue;
                this.nodes.put(source, 1);
                --nodes_left;
                edges.put(edge_indices[i], 1);
            }
        }
        IntArrayList forest = new IntArrayList(this.perspective.getEdgeCount());
        for (int i = 0; i < edge_indices.length; ++i) {
            if (edges.get(edge_indices[i]) != 1) continue;
            forest.add(edge_indices[i]);
        }
        forest.trimToSize();
        return forest.elements();
    }

    public void makeTree(GraphPerspective perspective) {
        int root = perspective.getRootGraphNodeIndex(1);
        this.nodes = new OpenIntIntHashMap(perspective.getNodeCount());
        this.nodes.put(root, 1);
        this.assignTree(root, perspective);
    }

    private void assignTree(int parent, GraphPerspective perspective) {
        RootGraph root_graph = perspective.getRootGraph();
        int[] neighbors = perspective.neighborsArray(parent);
        for (int i = 0; i < neighbors.length; ++i) {
            int child = perspective.getRootGraphNodeIndex(neighbors[i]);
            if (this.nodes.get(child) != 0) continue;
            root_graph.addNodeMetaChild(parent, child);
            this.nodes.put(child, 1);
            this.assignTree(child, perspective);
        }
    }

    public int[] kruskal() {
        return null;
    }

    public int[] old_kruskal(int starting_node) {
        IntArrayList edges = new IntArrayList(this.perspective.getEdgeCount());
        OpenIntIntHashMap nodes = new OpenIntIntHashMap(this.perspective.getNodeCount());
        int[] node_indices = this.perspective.getNodeIndicesArray();
        int[] new_indices = new int[node_indices.length - 1];
        System.arraycopy(node_indices, 1, new_indices, 0, new_indices.length);
        GraphPerspective spanning = this.perspective.getRootGraph().createGraphPerspective(new_indices, new int[0]);
        System.out.println("Spanning: " + spanning.getNodeCount() + " " + spanning.getEdgeCount());
        int[] edge_indices = this.perspective.getEdgeIndicesArray();
        for (int i = 0; i < edge_indices.length; ++i) {
            int target = this.perspective.getEdgeTargetIndex(edge_indices[i]);
            int source = this.perspective.getEdgeSourceIndex(edge_indices[i]);
            boolean include = false;
            if (spanning.getDegree(source) != 0 && spanning.getDegree(target) != 0) continue;
            edges.add(edge_indices[i]);
            if (edge_indices[i] > 0) {
                spanning.restoreEdge(this.perspective.getRootGraphEdgeIndex(edge_indices[i]));
                continue;
            }
            if (edge_indices[i] == 0) {
                System.out.println("Life Sucks.");
                continue;
            }
            spanning.restoreEdge(edge_indices[i]);
        }
        edges.trimToSize();
        return edges.elements();
    }
}

