/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PFishEye
extends PNode {
    public static double LENS_DRAGBAR_HEIGHT = 20.0;
    public static Paint DEFAULT_DRAGBAR_PAINT = Color.DARK_GRAY;
    public static Paint DEFAULT_LENS_PAINT = Color.LIGHT_GRAY;
    private PPath handle = new PPath();
    private PCamera camera;
    private PPath lens;
    private PDragEventHandler lensDragger;
    private PCanvas canvas;

    public PFishEye(PCanvas canvas) {
        this.handle.setPaint(DEFAULT_DRAGBAR_PAINT);
        this.handle.setPickable(false);
        this.handle.setPathToPolyline(new Point2D[]{new Point2D.Double(45.0, 50.0), new Point2D.Double(50.0, 45.0), new Point2D.Double(90.0, 85.0), new Point2D.Double(85.0, 90.0), new Point2D.Double(45.0, 50.0)});
        this.addChild(this.handle);
        this.lens = new PClip();
        this.lens.setPathToEllipse(0.0f, 0.0f, 60.0f, 60.0f);
        this.camera = new PCamera();
        this.camera.setPaint(DEFAULT_LENS_PAINT);
        this.camera.addLayer(0, canvas.getLayer());
        this.camera.setBounds(0.0, 0.0, 60.0, 60.0);
        this.lens.addChild(this.camera);
        this.addChild(this.lens);
        this.lensDragger = new PDragEventHandler();
        this.lensDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.addInputEventListener(this.lensDragger);
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                double scale = PFishEye.this.camera.getViewScale();
                PFishEye.this.camera.setViewTransform(PFishEye.this.getInverseTransform());
                PFishEye.this.camera.scaleViewAboutPoint(scale, PFishEye.this.camera.getViewBounds().getX(), PFishEye.this.camera.getViewBounds().getY());
            }
        });
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public PPath getDragBar() {
        return this.handle;
    }

    public PDragEventHandler getLensDraggerHandler() {
        return this.lensDragger;
    }

    public void addLayer(int index, PLayer layer) {
        this.camera.addLayer(index, layer);
    }

    public void removeLayer(PLayer layer) {
        this.camera.removeLayer(layer);
    }

    protected void layoutChildren() {
    }
}

