/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import java.awt.geom.Point2D;
import phoebe.util.PEdgeEndIcon;

public class PDeltaIcon
extends PEdgeEndIcon {
    protected double length;
    protected double sinTheta;
    protected double cosTheta;
    protected double midX;
    protected double midY;
    protected double botX;
    protected double botY;
    protected double topX;
    protected double topY;

    public PDeltaIcon(Point2D s, Point2D t, double l) {
        super(s, t);
        this.length = l * Math.sqrt(2.0);
        this.setStroke(null);
        this.calcPositions();
    }

    protected void calcPositions() {
        double x1 = this.target.getX();
        double y1 = this.target.getY();
        double x2 = this.source.getX();
        double y2 = this.source.getY();
        this.sinTheta = (y1 - y2) / this.lineLen;
        this.cosTheta = (x1 - x2) / this.lineLen;
        this.newY = y1 - this.sinTheta * this.length;
        this.newX = x1 - this.cosTheta * this.length;
        this.midY = y1 - this.sinTheta * this.length / 0.7;
        this.midX = x1 - this.cosTheta * this.length / 0.7;
        double theta = Math.acos(this.cosTheta);
        double topTheta = theta + 1.5707963267948966;
        double botTheta = theta - 1.5707963267948966;
        double sinTopTheta = Math.sin(topTheta);
        double cosTopTheta = Math.cos(topTheta);
        double sinBotTheta = Math.sin(botTheta);
        double cosBotTheta = Math.cos(botTheta);
        if (y2 > y1) {
            this.topY = this.midY + sinTopTheta * this.length / 2.0;
            this.botY = this.midY + sinBotTheta * this.length / 2.0;
        } else {
            this.topY = this.midY - sinTopTheta * this.length / 2.0;
            this.botY = this.midY - sinBotTheta * this.length / 2.0;
        }
        this.topX = this.midX - cosTopTheta * this.length / 2.0;
        this.botX = this.midX - cosBotTheta * this.length / 2.0;
    }

    public void drawIcon(Point2D s, Point2D t) {
        this.source = s;
        this.target = t;
        this.calcLineLen();
        this.calcPositions();
        float[] xs = new float[]{(float)this.topX, (float)this.target.getX(), (float)this.botX, (float)this.topX};
        float[] ys = new float[]{(float)this.topY, (float)this.target.getY(), (float)this.botY, (float)this.topY};
        this.setPathToPolyline(xs, ys);
    }
}

