/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import java.awt.geom.Point2D;
import phoebe.util.PEdgeEndIcon;

public class PCircleIcon
extends PEdgeEndIcon {
    protected double diameter;
    protected double sinTheta;
    protected double cosTheta;
    protected double midX;
    protected double midY;

    public PCircleIcon(Point2D s, Point2D t, double d) {
        super(s, t);
        this.setStroke(null);
        this.diameter = d;
        this.calcPositions();
    }

    protected void calcPositions() {
        double x1 = this.target.getX();
        double y1 = this.target.getY();
        double x2 = this.source.getX();
        double y2 = this.source.getY();
        this.sinTheta = (y1 - y2) / this.lineLen;
        this.cosTheta = (x1 - x2) / this.lineLen;
        this.newY = y1 - this.sinTheta * this.diameter;
        this.newX = x1 - this.cosTheta * this.diameter;
        this.midY = y1 - this.sinTheta * this.diameter / 2.0;
        this.midX = x1 - this.cosTheta * this.diameter / 2.0;
    }

    public void drawIcon(Point2D s, Point2D t) {
        this.source = s;
        this.target = t;
        this.calcLineLen();
        this.calcPositions();
        double ellipseX = this.midX - this.diameter / 2.0;
        double ellipseY = this.midY - this.diameter / 2.0;
        this.setPathToEllipse((float)ellipseX, (float)ellipseY, (float)this.diameter, (float)this.diameter);
    }
}

