/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import giny.model.GraphPerspective;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class GraphPartition {
    protected GraphPerspective perspective;

    public GraphPartition(GraphPerspective perspective) {
        this.perspective = perspective;
    }

    public GraphPerspective getGraphPerspective() {
        return this.perspective;
    }

    public void setGraphPerspective(GraphPerspective perspective) {
        this.perspective = perspective;
    }

    public List partition() {
        int i;
        int nodes_left;
        ArrayList<int[]> partitions = new ArrayList<int[]>();
        OpenIntIntHashMap edges = new OpenIntIntHashMap(this.perspective.getEdgeCount());
        OpenIntIntHashMap nodes = new OpenIntIntHashMap(this.perspective.getNodeCount());
        int[] nodes_arrays = this.perspective.getNodeIndicesArray();
        IntArrayList un_connected = new IntArrayList();
        IntArrayList connected = new IntArrayList();
        for (int i2 = 0; i2 < nodes_arrays.length; ++i2) {
            if (this.perspective.getDegree(nodes_arrays[i2]) == 0) {
                un_connected.add(nodes_arrays[i2]);
                continue;
            }
            connected.add(nodes_arrays[i2]);
        }
        connected.trimToSize();
        un_connected.trimToSize();
        int[] edge_indices = this.perspective.getEdgeIndicesArray();
        boolean inititalized = false;
        int last_nodes_left = nodes_left = connected.size();
        boolean found_new = true;
        while (nodes_left > 0) {
            if (nodes_left == last_nodes_left && inititalized && !found_new) {
                IntArrayList forest = new IntArrayList(this.perspective.getEdgeCount());
                for (i = 0; i < edge_indices.length; ++i) {
                    if (edges.get(edge_indices[i]) != 1) continue;
                    edges.put(edge_indices[i], 2);
                    forest.add(edge_indices[i]);
                }
                forest.trimToSize();
                partitions.add(forest.elements());
                System.out.println("un inititalized, added: " + forest.elements().length);
                inititalized = false;
            }
            last_nodes_left = nodes_left;
            found_new = false;
            for (int i3 = 0; i3 < edge_indices.length; ++i3) {
                int target = this.perspective.getEdgeTargetIndex(edge_indices[i3]);
                int source = this.perspective.getEdgeSourceIndex(edge_indices[i3]);
                if (!inititalized && edges.get(edge_indices[i3]) == 0) {
                    nodes.put(source, 1);
                    nodes.put(target, 1);
                    --nodes_left;
                    --nodes_left;
                    System.out.println("inititalized");
                    inititalized = true;
                    found_new = true;
                    edges.put(edge_indices[i3], 1);
                    continue;
                }
                if (edges.get(edge_indices[i3]) != 0 || nodes.get(source) == 1 && nodes.get(target) == 1) continue;
                if (nodes.get(source) == 1 && nodes.get(target) == 0) {
                    nodes.put(target, 1);
                    --nodes_left;
                    found_new = true;
                    edges.put(edge_indices[i3], 1);
                    continue;
                }
                if (nodes.get(source) != 0 || nodes.get(target) != 1) continue;
                nodes.put(source, 1);
                --nodes_left;
                found_new = true;
                edges.put(edge_indices[i3], 1);
            }
        }
        IntArrayList forest = new IntArrayList(this.perspective.getEdgeCount());
        for (i = 0; i < edge_indices.length; ++i) {
            if (edges.get(edge_indices[i]) != 1) continue;
            edges.put(edge_indices[i], 2);
            forest.add(edge_indices[i]);
        }
        forest.trimToSize();
        partitions.add(forest.elements());
        for (int j = 0; j < this.perspective.getNodeCount(); ++j) {
            if (nodes.get(j) != 0) continue;
            nodes.put(j, 1);
            --nodes_left;
            break;
        }
        for (i = 0; i < partitions.size(); ++i) {
            partitions.set(i, this.perspective.getConnectingNodeIndicesArray((int[])partitions.get(i)));
        }
        for (i = 0; i < un_connected.size(); ++i) {
            partitions.add(new int[]{un_connected.get(i)});
        }
        Object[] parts = partitions.toArray();
        Arrays.sort(parts, new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] one = (int[])o1;
                int[] two = (int[])o2;
                if (one.length == two.length) {
                    return 0;
                }
                if (one.length < two.length) {
                    return 1;
                }
                if (one.length > two.length) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        return Arrays.asList(parts);
    }
}

