/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import java.awt.geom.Point2D;
import java.util.Vector;
import phoebe.util.Cubic;

public class CubicGenerator {
    protected static int steps = 12;

    protected static Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    public static boolean pointsInLine(Point2D[] pts) {
        if (pts.length <= 2) {
            return true;
        }
        double epsilon = 0.05;
        double mainSlope = (pts[0].getY() - pts[pts.length - 1].getY()) / (pts[0].getX() - pts[pts.length - 1].getX());
        double testSlope = 0.0;
        for (int i = 1; i < pts.length - 1; ++i) {
            testSlope = (pts[0].getY() - pts[i].getY()) / (pts[0].getX() - pts[i].getX());
            if (!(Math.abs(testSlope - mainSlope) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static Point2D[] getPoints(Point2D[] points, int lineStyle) {
        if (lineStyle == 2 || CubicGenerator.pointsInLine(points)) {
            return points;
        }
        int[] xPoints = new int[points.length];
        int[] yPoints = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            Point2D pt = points[i];
            xPoints[i] = (int)pt.getX();
            yPoints[i] = (int)pt.getY();
        }
        Cubic[] X = CubicGenerator.calcNaturalCubic(points.length - 1, xPoints);
        Cubic[] Y = CubicGenerator.calcNaturalCubic(points.length - 1, yPoints);
        Vector<Point2D.Double> tempPoints = new Vector<Point2D.Double>();
        tempPoints.add(new Point2D.Double(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f))));
        for (int i = 0; i < X.length; ++i) {
            for (int j = 1; j <= steps; ++j) {
                float u = (float)j / (float)steps;
                tempPoints.add(new Point2D.Double(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u))));
            }
        }
        Point2D[] drawPoints = new Point2D[tempPoints.size()];
        for (int i = 0; i < drawPoints.length; ++i) {
            drawPoints[i] = (Point2D)tempPoints.get(i);
        }
        return drawPoints;
    }

    public static int getListIndex(Point2D pt, Point2D[] drawPoints, int lineStyle) {
        if (lineStyle == 1) {
            double minDist = Double.MAX_VALUE;
            int index = 0;
            for (int i = 0; i < drawPoints.length; ++i) {
                double tempDist = drawPoints[i].distanceSq(pt);
                if (!(tempDist < minDist)) continue;
                minDist = tempDist;
                index = i;
            }
            return Math.round((float)index / (float)steps - 0.5f);
        }
        for (int i = 0; i < drawPoints.length - 1; ++i) {
            Point2D[] points = new Point2D[]{drawPoints[i], pt, drawPoints[i + 1]};
            if (!CubicGenerator.pointsInLine(points) || !CubicGenerator.isMidPoint(points)) continue;
            return i;
        }
        return 0;
    }

    private static boolean isMidPoint(Point2D[] pts) {
        double maxX = Math.max(pts[0].getX(), pts[2].getX());
        double minX = Math.min(pts[0].getX(), pts[2].getX());
        double maxY = Math.max(pts[0].getY(), pts[2].getY());
        double minY = Math.min(pts[0].getY(), pts[2].getY());
        double midX = pts[1].getX();
        double midY = pts[1].getY();
        return midX <= maxX && midX >= minX && midY <= maxY && midY >= minY;
    }
}

