/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ColorInterpolator {
    public static final double DEFAULT_CENTER_VALUE = 0.0;
    public static final double DEFAULT_LOW_VALUE = -1.0;
    public static final double DEFAULT_HIGH_VALUE = 1.0;
    public static final Color DEFAULT_CENTER_COLOR = Color.white;
    public static final Color DEFAULT_LOW_COLOR = Color.red;
    public static final Color DEFAULT_HIGH_COLOR = Color.green;
    protected static final int LOW_COLOR = 1;
    protected static final int CENTER_COLOR = 2;
    protected static final int HIGH_COLOR = 3;
    protected double centerValue = 0.0;
    protected Color centerColor = null;
    protected double lowValue = 0.0;
    protected Color lowColor = null;
    protected double highValue = 0.0;
    protected Color highColor = null;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ColorInterpolator() {
        this(0.0, DEFAULT_CENTER_COLOR, -1.0, DEFAULT_LOW_COLOR, 1.0, DEFAULT_HIGH_COLOR);
    }

    public ColorInterpolator(double center_value, Color center_color, double low_value, Color low_color, double high_value, Color high_color) {
        this.setCenterValue(center_value);
        this.setCenterColor(center_color);
        this.setLowValue(low_value);
        this.setLowColor(low_color);
        this.setHighValue(high_value);
        this.setHighColor(high_color);
    }

    public Color colorFromValue(double value) {
        return ColorInterpolator.colorFromValue(this.centerValue, this.centerColor, this.lowValue, this.lowColor, this.highValue, this.highColor, value);
    }

    public void setCenterValue(double value) {
        if (this.centerValue == value) {
            return;
        }
        double old_value = this.centerValue;
        this.centerValue = value;
        this.pcs.firePropertyChange("centerValue", new Double(old_value), new Double(value));
    }

    public double getCenterValue() {
        return this.centerValue;
    }

    public void setLowValue(double value) {
        if (this.lowValue == value) {
            return;
        }
        double old_value = this.lowValue;
        this.lowValue = value;
        this.pcs.firePropertyChange("lowValue", new Double(old_value), new Double(value));
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public void setHighValue(double value) {
        if (this.highValue == value) {
            return;
        }
        double old_value = this.highValue;
        this.highValue = value;
        this.pcs.firePropertyChange("highValue", new Double(old_value), new Double(value));
    }

    public double getHighValue() {
        return this.highValue;
    }

    public void setCenterColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("The color must be non-null.");
        }
        if (this.centerColor != null && this.centerColor.equals(color)) {
            return;
        }
        Color old_color = this.centerColor;
        this.centerColor = color;
        this.pcs.firePropertyChange("centerColor", old_color, color);
    }

    public Color getCenterColor() {
        return this.centerColor;
    }

    public void setLowColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("The color must be non-null.");
        }
        if (this.lowColor != null && this.lowColor.equals(color)) {
            return;
        }
        Color old_color = this.lowColor;
        this.lowColor = color;
        this.pcs.firePropertyChange("lowColor", old_color, color);
    }

    public Color getLowColor() {
        return this.lowColor;
    }

    public void setHighColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("The color must be non-null.");
        }
        if (this.highColor != null && this.highColor.equals(color)) {
            return;
        }
        Color old_color = this.highColor;
        this.highColor = color;
        this.pcs.firePropertyChange("highColor", old_color, color);
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public ColorInterpolatorPanel createPanel() {
        ColorInterpolatorPanel panel = new ColorInterpolatorPanel();
        this.addPropertyChangeListener(panel);
        return panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(property, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.pcs.getPropertyChangeListeners(property);
    }

    public static Color colorFromValue(double center_value, Color center_color, double low_value, Color low_color, double high_value, Color high_color, double value) {
        Color value_color;
        int center_r = center_color.getRed();
        int center_g = center_color.getGreen();
        int center_b = center_color.getBlue();
        if (value == center_value) {
            value_color = center_color;
        } else if (value > center_value) {
            if (value >= high_value) {
                value_color = high_color;
            } else {
                int high_r = high_color.getRed();
                int high_g = high_color.getGreen();
                int high_b = high_color.getBlue();
                double value_percent = (value - center_value) / (high_value - center_value);
                int value_r = (int)(high_r > center_r ? (double)center_r + (double)(high_r - center_r) * value_percent : (double)center_r - (double)(center_r - high_r) * value_percent);
                int value_g = (int)(high_g > center_g ? (double)center_g + (double)(high_g - center_g) * value_percent : (double)center_g - (double)(center_g - high_g) * value_percent);
                int value_b = (int)(high_b > center_b ? (double)center_b + (double)(high_b - center_b) * value_percent : (double)center_b - (double)(center_b - high_b) * value_percent);
                value_color = new Color(value_r, value_g, value_b);
            }
        } else if (value <= low_value) {
            value_color = low_color;
        } else {
            int low_r = low_color.getRed();
            int low_g = low_color.getGreen();
            int low_b = low_color.getBlue();
            double value_percent = (center_value - value) / (center_value - low_value);
            int value_r = (int)(low_r > center_r ? (double)center_r + (double)(low_r - center_r) * value_percent : (double)center_r - (double)(center_r - low_r) * value_percent);
            int value_g = (int)(low_g > center_g ? (double)center_g + (double)(low_g - center_g) * value_percent : (double)center_g - (double)(center_g - low_g) * value_percent);
            int value_b = (int)(low_b > center_b ? (double)center_b + (double)(low_b - center_b) * value_percent : (double)center_b - (double)(center_b - low_b) * value_percent);
            value_color = new Color(value_r, value_g, value_b);
        }
        return value_color;
    }

    public class ColorInterpolatorPanel
    extends JPanel
    implements PropertyChangeListener {
        protected ColorCanvas lowColorCanvas;
        protected ColorCanvas centerColorCanvas;
        protected ColorCanvas highColorCanvas;

        public ColorInterpolatorPanel() {
            this.initializeColorInterpolatorPanel();
        }

        protected void initializeColorInterpolatorPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gb);
            this.setOpaque(true);
            this.setBackground(Color.lightGray);
            this.setForeground(Color.black);
            c.insets = new Insets(10, 10, 10, 10);
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.anchor = 10;
            c.fill = 2;
            c.gridy = 0;
            c.insets.bottom = 0;
            c.insets.right = 0;
            JLabel low_label = new JLabel("Low", 0);
            gb.setConstraints(low_label, c);
            this.add(low_label);
            c.insets.left = 0;
            JLabel center_label = new JLabel("Center", 0);
            gb.setConstraints(center_label, c);
            this.add(center_label);
            c.insets.right = 10;
            JLabel high_label = new JLabel("High", 0);
            gb.setConstraints(high_label, c);
            this.add(high_label);
            ++c.gridy;
            c.insets.top = 0;
            c.insets.right = 0;
            c.insets.left = 10;
            JTextField low_text_field = new JTextField(String.valueOf(ColorInterpolator.this.getLowValue()));
            low_text_field.setEditable(true);
            low_text_field.addActionListener(new ActionListener(this, low_text_field){
                private final /* synthetic */ JTextField val$low_text_field;
                private final /* synthetic */ ColorInterpolatorPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$low_text_field = val$low_text_field;
                }

                public void actionPerformed(ActionEvent event) {
                    try {
                        ColorInterpolatorPanel.access$000(this.this$1).setLowValue(Double.parseDouble(this.val$low_text_field.getText()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("WARNING: Unable to parse the value \"" + this.val$low_text_field.getText() + "\" as a double.");
                    }
                }
            });
            gb.setConstraints(low_text_field, c);
            this.add(low_text_field);
            c.insets.left = 0;
            JTextField center_text_field = new JTextField(String.valueOf(ColorInterpolator.this.getCenterValue()));
            center_text_field.setEditable(true);
            center_text_field.addActionListener(new ActionListener(this, center_text_field){
                private final /* synthetic */ JTextField val$center_text_field;
                private final /* synthetic */ ColorInterpolatorPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$center_text_field = val$center_text_field;
                }

                public void actionPerformed(ActionEvent event) {
                    try {
                        ColorInterpolatorPanel.access$000(this.this$1).setCenterValue(Double.parseDouble(this.val$center_text_field.getText()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("WARNING: Unable to parse the value \"" + this.val$center_text_field.getText() + "\" as a double.");
                    }
                }
            });
            gb.setConstraints(center_text_field, c);
            this.add(center_text_field);
            c.insets.right = 10;
            JTextField high_text_field = new JTextField(String.valueOf(ColorInterpolator.this.getHighValue()));
            high_text_field.setEditable(true);
            high_text_field.addActionListener(new ActionListener(this, high_text_field){
                private final /* synthetic */ JTextField val$high_text_field;
                private final /* synthetic */ ColorInterpolatorPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$high_text_field = val$high_text_field;
                }

                public void actionPerformed(ActionEvent event) {
                    try {
                        ColorInterpolatorPanel.access$000(this.this$1).setHighValue(Double.parseDouble(this.val$high_text_field.getText()));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("WARNING: Unable to parse the value \"" + this.val$high_text_field.getText() + "\" as a double.");
                    }
                }
            });
            gb.setConstraints(high_text_field, c);
            this.add(high_text_field);
            ++c.gridy;
            c.insets.bottom = 10;
            c.insets.right = 0;
            c.insets.left = 10;
            c.weighty = 1.0;
            c.fill = 1;
            c.gridheight = 0;
            this.lowColorCanvas = this.createColorCanvas(1);
            gb.setConstraints(this.lowColorCanvas, c);
            this.add(this.lowColorCanvas);
            c.insets.left = 0;
            this.centerColorCanvas = this.createColorCanvas(2);
            gb.setConstraints(this.centerColorCanvas, c);
            this.add(this.centerColorCanvas);
            c.insets.right = 10;
            this.highColorCanvas = this.createColorCanvas(3);
            gb.setConstraints(this.highColorCanvas, c);
            this.add(this.highColorCanvas);
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getPropertyName();
            if (property.equals("lowColor")) {
                this.lowColorCanvas.updateColorCanvas();
            } else if (property.equals("centerColor")) {
                this.centerColorCanvas.updateColorCanvas();
            } else if (property.equals("highColor")) {
                this.highColorCanvas.updateColorCanvas();
            }
        }

        protected ColorCanvas createColorCanvas(int which_color) {
            return new ColorCanvas(which_color);
        }

        public class ColorCanvas
        extends JLabel {
            protected int whichColor = 0;
            protected JColorChooser colorChooser;
            protected JDialog colorChooserDialog;

            public ColorCanvas(int which_color) {
                super(" ");
                this.initializeColorCanvas();
                this.setWhichColor(which_color);
            }

            protected void initializeColorCanvas() {
                this.setOpaque(true);
                this.setBorder(BorderFactory.createBevelBorder(1));
                this.colorChooser = new JColorChooser();
                this.colorChooserDialog = JColorChooser.createDialog(this, "Color", true, this.colorChooser, new ActionListener(this){
                    private final /* synthetic */ ColorCanvas this$2;
                    {
                        this.this$2 = this$2;
                    }

                    public void actionPerformed(ActionEvent event) {
                        switch (this.this$2.whichColor) {
                            case 1: {
                                ColorInterpolatorPanel.access$000(ColorCanvas.access$100(this.this$2)).setLowColor(this.this$2.colorChooser.getColor());
                                break;
                            }
                            case 2: {
                                ColorInterpolatorPanel.access$000(ColorCanvas.access$100(this.this$2)).setCenterColor(this.this$2.colorChooser.getColor());
                                break;
                            }
                            case 3: {
                                ColorInterpolatorPanel.access$000(ColorCanvas.access$100(this.this$2)).setHighColor(this.this$2.colorChooser.getColor());
                                break;
                            }
                        }
                        this.this$2.repaint();
                    }
                }, null);
                this.addMouseListener(this.createMouseListener());
            }

            public void setWhichColor(int which_color) {
                if (which_color < 1 || which_color > 3) {
                    throw new IllegalArgumentException("whichColor must be one of { LOW_COLOR, CENTER_COLOR, HIGH_COLOR }.");
                }
                this.whichColor = which_color;
                this.updateColorCanvas();
            }

            public int getWhichColor() {
                return this.whichColor;
            }

            public void updateColorCanvas() {
                switch (this.whichColor) {
                    case 1: {
                        this.setBackground(ColorInterpolator.this.getLowColor());
                        this.colorChooser.setColor(ColorInterpolator.this.getLowColor());
                        this.colorChooserDialog.setTitle("Low Color");
                        break;
                    }
                    case 2: {
                        this.setBackground(ColorInterpolator.this.getCenterColor());
                        this.colorChooser.setColor(ColorInterpolator.this.getCenterColor());
                        this.colorChooserDialog.setTitle("Center Color");
                        break;
                    }
                    case 3: {
                        this.setBackground(ColorInterpolator.this.getHighColor());
                        this.colorChooser.setColor(ColorInterpolator.this.getHighColor());
                        this.colorChooserDialog.setTitle("High Color");
                        break;
                    }
                    default: {
                        System.err.println("WARNING: The whichColor of a ColorCanvas is invalid: " + this.whichColor + ".");
                    }
                }
            }

            protected MouseListener createMouseListener() {
                return new MouseAdapter(this){
                    private final /* synthetic */ ColorCanvas this$2;
                    {
                        this.this$2 = this$2;
                    }

                    public void mouseClicked(MouseEvent event) {
                        if (event.getClickCount() == 2) {
                            this.this$2.colorChooserDialog.setVisible(true);
                        }
                    }
                };
            }

            static /* synthetic */ ColorInterpolatorPanel access$100(ColorCanvas x0) {
                return x0.ColorInterpolatorPanel.this;
            }
        }
    }
}

