/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.P3DRect;
import java.awt.Color;
import java.lang.reflect.Method;

public class ButtonNode
extends P3DRect {
    boolean doAction = false;
    boolean pressed = false;
    Method method;
    Object invokeApon;
    Object[] arguments;
    PText label;

    public ButtonNode(String text, Method m, Object parent, Object[] args) {
        super(0.0, 0.0, 100.0, 100.0);
        this.method = m;
        this.invokeApon = parent;
        this.arguments = args;
        this.setRaised(true);
        this.label = new PText(text);
        double w = this.label.getWidth();
        double h = this.label.getHeight();
        this.label.setOffset(10.0, 5.0);
        this.setBounds(0.0, 0.0, w + 20.0, h + 10.0);
        this.setPaint(Color.lightGray);
        this.addChild(this.label);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent event) {
                ButtonNode.this.setRaised(false);
                ButtonNode.this.doAction = true;
                ButtonNode.this.pressed = true;
                ButtonNode.this.setPaint(Color.gray);
            }

            public void mouseExited(PInputEvent event) {
                if (ButtonNode.this.pressed) {
                    ButtonNode.this.doAction = false;
                    ButtonNode.this.setRaised(true);
                }
            }

            public void mouseEntered(PInputEvent event) {
                if (ButtonNode.this.pressed) {
                    ButtonNode.this.doAction = true;
                    ButtonNode.this.setRaised(false);
                }
            }

            public void mouseReleased(PInputEvent event) {
                if (ButtonNode.this.doAction) {
                    try {
                        ButtonNode.this.method.invoke(ButtonNode.this.invokeApon, ButtonNode.this.arguments);
                    }
                    catch (Exception e) {
                        System.out.println("Action Didn't happen");
                        e.printStackTrace();
                    }
                    ButtonNode.this.doAction = false;
                }
                ButtonNode.this.pressed = false;
                ButtonNode.this.setRaised(true);
                ButtonNode.this.setPaint(Color.lightGray);
            }
        });
    }

    public void setText(String new_text) {
        this.label.setText(new_text);
    }
}

