/*
 * Decompiled with CFR 0.152.
 */
package phoebe.util;

import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import phoebe.PEdgeView;
import phoebe.PGraphView;
import phoebe.util.CubicGenerator;
import phoebe.util.PNamedHandle;
import phoebe.util.PPointLocator;

public class Bend
implements giny.view.Bend {
    protected Vector handlePointList;
    protected Vector handleList;
    protected Point2D sourcePoint;
    protected Point2D targetPoint;
    protected PEdgeView edgeView;
    protected PGraphView view;

    public Bend(Point2D sourcePoint, Point2D targetPoint, PEdgeView edgeView) {
        this.commonInit(sourcePoint, targetPoint, edgeView);
    }

    public Bend(Point2D sourcePoint, Point2D targetPoint, PEdgeView edgeView, List bendPoints) {
        this.commonInit(sourcePoint, targetPoint, edgeView);
        for (int i = 0; i < bendPoints.size(); ++i) {
            this.addHandle(i, (Point2D)bendPoints.get(i));
        }
    }

    private void commonInit(Point2D sourcePoint, Point2D targetPoint, PEdgeView edgeView) {
        this.sourcePoint = sourcePoint;
        this.targetPoint = targetPoint;
        this.edgeView = edgeView;
        this.handleList = new Vector();
        this.handlePointList = new Vector();
    }

    public void setHandles(List bendPoints) {
        int i;
        if (this.handleList.size() > 0) {
            for (i = 0; i < this.handleList.size(); ++i) {
                this.removeHandle(i);
            }
        } else {
            this.handlePointList.removeAllElements();
        }
        for (i = 0; i < bendPoints.size(); ++i) {
            this.addHandle(i, (Point2D)bendPoints.get(i));
        }
    }

    public List getHandles() {
        ArrayList<Point2D> l = new ArrayList<Point2D>();
        for (int i = 0; i < this.handlePointList.size(); ++i) {
            Point2D pt = (Point2D)((Point2D)this.handlePointList.get(i)).clone();
            l.add(pt);
        }
        return l;
    }

    public void moveHandle(int i, Point2D pt) {
        if (i == 0 && this.handlePointList.isEmpty()) {
            this.handlePointList.add(pt);
        }
        if (this.handlePointList.isEmpty() || i < 0) {
            return;
        }
        this.handlePointList.setElementAt(pt, i);
        if (this.handleList.size() > 0) {
            PHandle h = (PHandle)this.handleList.get(i);
            PLocator l = h.getLocator();
            l.locatePoint(pt);
        }
    }

    public Point2D getSourceHandlePoint() {
        if (this.handlePointList.size() == 0) {
            return this.targetPoint;
        }
        return (Point2D)this.handlePointList.get(0);
    }

    public Point2D getTargetHandlePoint() {
        if (this.handlePointList.size() == 0) {
            return this.sourcePoint;
        }
        return (Point2D)this.handlePointList.get(this.handlePointList.size() - 1);
    }

    public void addHandle(Point2D pt) {
        int index = CubicGenerator.getListIndex(pt, this.getDrawPoints(), this.edgeView.getLineType());
        this.actuallyAddHandle(index, pt);
    }

    public void addHandle(int insertIndex, Point2D pt) {
        if (insertIndex >= 0 && insertIndex <= this.handlePointList.size()) {
            this.actuallyAddHandle(insertIndex, pt);
        } else {
            System.out.println("Couldn't insert handle at index: " + insertIndex);
        }
    }

    private void actuallyAddHandle(int insertIndex, Point2D pt) {
        if (this.edgeView.isSelected()) {
            PNamedHandle h = this.createHandle(pt);
            h.addInputEventListener(this.edgeView.getEdgeHandler());
            this.edgeView.addChild(h);
            this.handleList.insertElementAt(h, insertIndex);
        }
        this.handlePointList.insertElementAt(pt, insertIndex);
        this.edgeView.updateEdgeView();
    }

    protected PNamedHandle createHandle(Point2D pt) {
        return new PNamedHandle(pt.toString(), new PPointLocator(this.edgeView, pt)){

            public void dragHandle(PDimension dim, PInputEvent aEvent) {
                Bend.this.edgeView.localToParent(dim);
                ((PPointLocator)this.getLocator()).update(dim.getWidth(), dim.getHeight());
                Bend.this.edgeView.updateEdgeView();
            }
        };
    }

    public void removeHandle(Point2D pt) {
        for (int i = 0; i < this.handleList.size(); ++i) {
            Rectangle2D.Double rect = new Rectangle2D.Double(pt.getX(), pt.getY(), 1.0, 1.0);
            if (!((PNamedHandle)this.handleList.get(i)).intersects(rect)) continue;
            this.removeHandle(i);
            break;
        }
    }

    public void removeHandle(PHandle h) {
        for (int i = 0; i < this.handleList.size(); ++i) {
            if (!((PNamedHandle)this.handleList.get(i)).equals(h)) continue;
            this.removeHandle(i);
            break;
        }
    }

    public void removeHandle(int i) {
        if (i >= 0 && i < this.handleList.size()) {
            this.edgeView.removeChild((PNamedHandle)this.handleList.get(i));
            this.handleList.removeElementAt(i);
            this.handlePointList.removeElementAt(i);
            System.out.println("HANDLE Removed at index: " + i);
        } else {
            System.out.println("Couldn't remove handle at index: " + i);
        }
    }

    public void removeAllHandles() {
        this.handlePointList.removeAllElements();
        this.drawUnselected();
    }

    public boolean handleAlreadyExists(Point2D pt) {
        for (int i = 0; i < this.handleList.size(); ++i) {
            Rectangle2D.Double rect = new Rectangle2D.Double(pt.getX(), pt.getY(), 1.0, 1.0);
            if (!((PNamedHandle)this.handleList.get(i)).intersects(rect)) continue;
            return true;
        }
        return false;
    }

    public void drawSelected() {
        for (int i = 0; i < this.handlePointList.size(); ++i) {
            PNamedHandle h = this.createHandle((Point2D)this.handlePointList.get(i));
            h.addInputEventListener(this.edgeView.getEdgeHandler());
            this.edgeView.addChild(h);
            this.handleList.add(h);
        }
    }

    public void drawUnselected() {
        for (int i = 0; i < this.handlePointList.size(); ++i) {
            if (i > this.handleList.size()) continue;
            this.edgeView.removeChild((PNamedHandle)this.handleList.get(i));
        }
        this.handleList.removeAllElements();
    }

    public Point2D[] getDrawPoints() {
        Point2D[] pts = new Point2D[this.handlePointList.size() + 2];
        pts[0] = this.sourcePoint;
        for (int i = 0; i < this.handlePointList.size(); ++i) {
            pts[i + 1] = (Point2D)this.handlePointList.get(i);
        }
        pts[this.handlePointList.size() + 1] = this.targetPoint;
        return CubicGenerator.getPoints(pts, this.edgeView.getLineType());
    }
}

