/*
 * Decompiled with CFR 0.152.
 */
package phoebe.test;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import phoebe.PGraphView;
import phoebe.PNodeView;
import phoebe.util.PLabel;

public class ArrowNode
extends PNodeView {
    PPath inPort;
    PPath outPort;

    public ArrowNode(int node_index, PGraphView view) {
        super(node_index, view);
    }

    public PNode getInPort() {
        return this.inPort;
    }

    public PNode getOutPort() {
        return this.outPort;
    }

    protected void initializeNodeView() {
        this.setOffset(this.view.getNodeDoubleProperty(this.rootGraphIndex, 0), this.view.getNodeDoubleProperty(this.rootGraphIndex, 1));
        this.setStroke(new BasicStroke(this.view.getNodeFloatProperty(this.rootGraphIndex, 6)));
        this.setUnselectedPaint((Paint)this.view.getNodeObjectProperty(this.rootGraphIndex, 3));
        this.inPort = PPath.createEllipse(-10.0f, 40.0f, 10.0f, 10.0f);
        this.outPort = PPath.createEllipse(125.0f, 20.0f, 10.0f, 10.0f);
        float x = 0.0f;
        float y = 50.0f;
        this.moveTo(0.0f, 50.0f);
        this.lineTo(55.0f, 50.0f);
        this.lineTo(55.0f, 30.0f);
        this.lineTo(100.0f, 30.0f);
        this.lineTo(100.0f, 40.0f);
        this.lineTo(125.0f, 25.0f);
        this.lineTo(100.0f, 10.0f);
        this.lineTo(100.0f, 20.0f);
        this.lineTo(45.0f, 20.0f);
        this.lineTo(45.0f, 40.0f);
        this.lineTo(0.0f, 40.0f);
        this.closePath();
        this.addChild(this.inPort);
        this.addChild(this.outPort);
        this.label = new PLabel(new Integer(this.getIndex()).toString(), this);
        this.label.updatePosition();
        this.label.setPickable(false);
        this.addChild(this.label);
        this.visible = true;
        this.selected = false;
        this.notUpdated = false;
        this.setPickable(true);
        this.invalidatePaint();
    }

    public boolean setBounds(Rectangle2D newBounds) {
        boolean r = super.setBounds(newBounds);
        this.inPort.setOffset(0.0, this.getHeight());
        this.outPort.setOffset(this.getWidth(), 0.5 * this.getHeight());
        return r;
    }
}

