/*
 * Decompiled with CFR 0.152.
 */
package phoebe.event;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import phoebe.PGraphView;

public class SquiggleEventHandler
extends PDragSequenceEventHandler {
    private PGraphView view;
    private PLayer squiggle_layer;
    private PCanvas canvas;
    private PPath squiggle;
    private Stroke CURRENT_STROKE = new BasicStroke(2.0f);
    private Paint CURRENT_PAINT = Color.red;

    public SquiggleEventHandler(PLayer layer, PCanvas canvas, PGraphView view) {
        this.squiggle_layer = layer;
        this.canvas = canvas;
        this.view = view;
        this.setEventFilter(new PInputEventFilter(16));
    }

    public void beginSquiggling() {
        this.canvas.getLayer().addChild(this.squiggle_layer);
        this.canvas.removeInputEventListener(this.view.getSelectionHandler());
        this.canvas.addInputEventListener(this);
    }

    public void stopSquiggling() {
        this.canvas.getLayer().removeChild(this.squiggle_layer);
        this.canvas.addInputEventListener(this.view.getSelectionHandler());
        this.canvas.removeInputEventListener(this);
    }

    public void clearSquiggles() {
        this.squiggle_layer.removeAllChildren();
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        Point2D p = e.getPosition();
        this.squiggle = new PPath();
        this.squiggle.addClientProperty("no_menu", "yes");
        this.squiggle.setStrokePaint(this.CURRENT_PAINT);
        this.squiggle.moveTo((float)p.getX(), (float)p.getY());
        this.squiggle.setStroke(new BasicStroke((float)(2.0 / e.getCamera().getViewScale())));
        this.squiggle_layer.addChild(this.squiggle);
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        this.updateSquiggle(e);
    }

    public void endDrag(PInputEvent e) {
        super.endDrag(e);
        this.updateSquiggle(e);
        this.squiggle = null;
    }

    public void updateSquiggle(PInputEvent aEvent) {
        Point2D p = aEvent.getPosition();
        this.squiggle.lineTo((float)p.getX(), (float)p.getY());
    }
}

