/*
 * Decompiled with CFR 0.152.
 */
package phoebe.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import phoebe.event.PToolTip;

public class PToolTipHandler
extends PBasicInputEventHandler {
    PCamera camera;
    PToolTip tooltipNode;

    public PToolTipHandler(PCamera camera) {
        this.camera = camera;
        this.tooltipNode = new PToolTip();
        this.tooltipNode.setPickable(false);
        camera.addChild(this.tooltipNode);
    }

    public void mouseMoved(PInputEvent event) {
        this.updateToolTip(event);
    }

    public void mouseDragged(PInputEvent event) {
        this.updateToolTip(event);
    }

    public void updateToolTip(PInputEvent event) {
        try {
            Point2D p = event.getCanvasPosition();
            event.getPath().canvasToLocal(p, (PNode)this.camera);
            String tip = (String)event.getInputManager().getMouseOver().getPickedNode().getClientProperty("tooltip");
            if (tip != null) {
                this.tooltipNode.setText(tip);
                this.tooltipNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
            } else {
                this.tooltipNode.setText("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

