/*
 * Decompiled with CFR 0.152.
 */
package phoebe.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import phoebe.util.PSmallBoundsHandle;

public class PSelectionHandler
extends PDragSequenceEventHandler {
    public static final String SELECTION_CHANGED_NOTIFICATION = "SELECTION_CHANGED_NOTIFICATION";
    static final int DASH_WIDTH = 5;
    static final int NUM_STROKES = 10;
    private Hashtable selection = null;
    private ArrayList selectableParents = null;
    private PPath marquee = null;
    private PNode marqueeParent = null;
    private Point2D presspt = null;
    private Point2D canvasPressPt = null;
    private float strokeNum = 0.0f;
    private Stroke[] strokes = null;
    private Hashtable allItems = null;
    private ArrayList unselectList = null;
    private HashMap marqueeMap = null;
    private PNode pressNode = null;
    private boolean deleteKeyActive = true;
    private boolean mouseDown = false;
    private boolean selectionMade = false;
    private PCamera camera;

    public PSelectionHandler(PNode marqueeParent, PNode selectableParent, PCamera camera) {
        this.marqueeParent = marqueeParent;
        this.selectableParents = new ArrayList();
        this.selectableParents.add(selectableParent);
        this.camera = camera;
        this.init();
    }

    public PSelectionHandler(PNode marqueeParent, ArrayList selectableParents) {
        this.marqueeParent = marqueeParent;
        this.selectableParents = selectableParents;
        this.init();
    }

    protected void init() {
        float[] dash = new float[]{5.0f, 5.0f};
        this.strokes = new Stroke[10];
        for (int i = 0; i < 10; ++i) {
            this.strokes[i] = new PFixedWidthStroke(3.0f);
        }
        this.selection = new Hashtable();
        this.allItems = new Hashtable();
        this.unselectList = new ArrayList();
        this.marqueeMap = new HashMap();
    }

    public void select(Collection items) {
        Iterator itemIt = items.iterator();
        while (itemIt.hasNext()) {
            PNode node = (PNode)itemIt.next();
            this.select(node);
        }
    }

    public void select(Map items) {
        Iterator itemIt = items.keySet().iterator();
        while (itemIt.hasNext()) {
            PNode node = (PNode)itemIt.next();
            this.select(node);
        }
    }

    public void select(PNode node) {
        if (this.isSelected(node)) {
            return;
        }
        if (node.getPickable() && node instanceof NodeView) {
            ((NodeView)((Object)node)).select();
            this.selection.put(node, Boolean.TRUE);
            this.decorateSelectedNode(node);
        }
    }

    public void decorateSelectedNode(PNode node) {
        PSmallBoundsHandle.addBoundsHandlesTo(node);
    }

    public void unselect(Collection items) {
        Iterator itemIt = items.iterator();
        while (itemIt.hasNext()) {
            PNode node = (PNode)itemIt.next();
            this.unselect(node);
        }
    }

    public void unselect(PNode node) {
        if (!this.isSelected(node)) {
            return;
        }
        if (node instanceof NodeView) {
            ((NodeView)((Object)node)).unselect();
            this.undecorateSelectedNode(node);
            this.selection.remove(node);
        }
    }

    public void undecorateSelectedNode(PNode node) {
        PSmallBoundsHandle.removeBoundsHandlesFrom(node);
    }

    public void unselectAll() {
        Enumeration en = this.selection.keys();
        while (en.hasMoreElements()) {
            PNode node = (PNode)en.nextElement();
            this.unselect(node);
        }
        this.selection.clear();
    }

    public boolean isSelected(PNode node) {
        return node != null && this.selection.containsKey(node);
    }

    public Collection getSelection() {
        ArrayList<PNode> sel = new ArrayList<PNode>();
        Enumeration en = this.selection.keys();
        while (en.hasMoreElements()) {
            PNode node = (PNode)en.nextElement();
            sel.add(node);
        }
        return sel;
    }

    protected boolean isSelectable(PNode node) {
        boolean selectable = false;
        Iterator parentsIt = this.selectableParents.iterator();
        block0: while (parentsIt.hasNext()) {
            PNode parent = (PNode)parentsIt.next();
            if (parent.getChildrenReference().contains(node)) {
                selectable = true;
                break;
            }
            if (!(parent instanceof PCamera)) continue;
            for (int i = 0; i < ((PCamera)parent).getLayerCount(); ++i) {
                PLayer layer = ((PCamera)parent).getLayer(i);
                if (!layer.getChildrenReference().contains(node)) continue;
                selectable = true;
                continue block0;
            }
        }
        return selectable;
    }

    public void addSelectableParent(PNode node) {
        this.selectableParents.add(node);
    }

    public void removeSelectableParent(PNode node) {
        this.selectableParents.remove(node);
    }

    public void setSelectableParent(PNode node) {
        this.selectableParents.clear();
        this.selectableParents.add(node);
    }

    public void setSelectableParents(Collection c) {
        this.selectableParents.clear();
        this.selectableParents.addAll(c);
    }

    public Collection getSelectableParents() {
        return (ArrayList)this.selectableParents.clone();
    }

    protected void startDrag(PInputEvent e) {
        super.startDrag(e);
        this.initializeSelection(e);
        if (this.isMarqueeSelection(e)) {
            this.initializeMarquee(e);
            if (!this.isOptionSelection(e)) {
                this.startMarqueeSelection(e);
            } else {
                this.startOptionMarqueeSelection(e);
            }
        } else if (!this.isOptionSelection(e)) {
            this.startStandardSelection(e);
        } else {
            this.startStandardOptionSelection(e);
        }
        try {
            Color bg = (Color)this.camera.getPaint();
            this.marquee.setStrokePaint(new Color(255 - bg.getRed(), 255 - bg.getGreen(), 135));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        if (this.isMarqueeSelection(e)) {
            this.updateMarquee(e);
            if (!this.isOptionSelection(e)) {
                this.computeMarqueeSelection(e);
            } else {
                this.computeOptionMarqueeSelection(e);
            }
        } else {
            this.dragStandardSelection(e);
        }
    }

    protected void endDrag(PInputEvent e) {
        super.endDrag(e);
        if (this.isMarqueeSelection(e)) {
            this.endMarqueeSelection(e);
        } else {
            this.endStandardSelection(e);
        }
    }

    public boolean isOptionSelection(PInputEvent pie) {
        return pie.isShiftDown();
    }

    protected boolean isMarqueeSelection(PInputEvent pie) {
        return this.pressNode == null;
    }

    protected void initializeSelection(PInputEvent pie) {
        this.canvasPressPt = pie.getCanvasPosition();
        this.presspt = pie.getPosition();
        this.pressNode = pie.getPath().getPickedNode();
        if (this.pressNode instanceof PCamera) {
            this.pressNode = null;
        }
    }

    protected void initializeMarquee(PInputEvent e) {
        this.marquee = PPath.createRectangle((float)this.presspt.getX(), (float)this.presspt.getY(), 0.0f, 0.0f);
        this.marquee.setPaint(null);
        this.marquee.setStrokePaint(Color.yellow);
        this.marquee.setStroke(this.strokes[0]);
        this.marqueeParent.addChild(this.marquee);
        this.marqueeMap.clear();
    }

    protected void startOptionMarqueeSelection(PInputEvent e) {
    }

    protected void startMarqueeSelection(PInputEvent e) {
        this.unselectAll();
    }

    protected void startStandardSelection(PInputEvent pie) {
        if (!this.isSelected(this.pressNode)) {
            this.unselectAll();
            this.select(this.pressNode);
        }
    }

    protected void startStandardOptionSelection(PInputEvent pie) {
        if (this.isSelected(this.pressNode)) {
            this.unselect(this.pressNode);
        } else {
            this.select(this.pressNode);
        }
    }

    protected void updateMarquee(PInputEvent pie) {
        PBounds b = new PBounds();
        if (this.marqueeParent instanceof PCamera) {
            b.add(this.canvasPressPt);
            b.add(pie.getCanvasPosition());
        } else {
            b.add(this.presspt);
            b.add(pie.getPosition());
        }
        this.marquee.setPathToRectangle((float)b.x, (float)b.y, (float)b.width, (float)b.height);
        b.reset();
        b.add(this.presspt);
        b.add(pie.getPosition());
        this.allItems.clear();
        PNodeFilter filter = this.createNodeFilter(b);
        Iterator parentsIt = this.selectableParents.iterator();
        while (parentsIt.hasNext()) {
            Collection items;
            PNode parent = (PNode)parentsIt.next();
            if (parent instanceof PCamera) {
                items = new ArrayList();
                for (int i = 0; i < ((PCamera)parent).getLayerCount(); ++i) {
                    ((PCamera)parent).getLayer(i).getAllNodes(filter, items);
                }
            } else {
                items = parent.getAllNodes(filter, null);
            }
            Iterator itemsIt = items.iterator();
            while (itemsIt.hasNext()) {
                this.allItems.put(itemsIt.next(), Boolean.TRUE);
            }
        }
    }

    protected void computeMarqueeSelection(PInputEvent pie) {
        PNode node;
        this.unselectList.clear();
        Enumeration selectionEn = this.selection.keys();
        while (selectionEn.hasMoreElements()) {
            node = (PNode)selectionEn.nextElement();
            if (this.allItems.containsKey(node)) continue;
            this.unselectList.add(node);
        }
        this.unselect(this.unselectList);
        selectionEn = this.allItems.keys();
        while (selectionEn.hasMoreElements()) {
            node = (PNode)selectionEn.nextElement();
            if (!this.selection.containsKey(node) && !this.marqueeMap.containsKey(node) && this.isSelectable(node)) {
                this.marqueeMap.put(node, Boolean.TRUE);
                continue;
            }
            if (this.isSelectable(node)) continue;
            this.allItems.remove(node);
        }
        this.select(this.allItems);
    }

    protected void computeOptionMarqueeSelection(PInputEvent pie) {
        PNode node;
        this.unselectList.clear();
        Enumeration selectionEn = this.selection.keys();
        while (selectionEn.hasMoreElements()) {
            node = (PNode)selectionEn.nextElement();
            if (this.allItems.containsKey(node) || !this.marqueeMap.containsKey(node)) continue;
            this.marqueeMap.remove(node);
            this.unselectList.add(node);
        }
        this.unselect(this.unselectList);
        selectionEn = this.allItems.keys();
        while (selectionEn.hasMoreElements()) {
            node = (PNode)selectionEn.nextElement();
            if (!this.selection.containsKey(node) && !this.marqueeMap.containsKey(node) && this.isSelectable(node)) {
                this.marqueeMap.put(node, Boolean.TRUE);
                continue;
            }
            if (this.isSelectable(node)) continue;
            this.allItems.remove(node);
        }
        this.select(this.allItems);
    }

    protected PNodeFilter createNodeFilter(PBounds bounds) {
        return new BoundsFilter(bounds);
    }

    protected PBounds getMarqueeBounds() {
        if (this.marquee != null) {
            return this.marquee.getBounds();
        }
        return new PBounds();
    }

    protected void dragStandardSelection(PInputEvent e) {
        PDimension d = e.getCanvasDelta();
        e.getTopCamera().localToView(d);
        PDimension gDist = new PDimension();
        Enumeration selectionEn = this.selection.keys();
        while (selectionEn.hasMoreElements()) {
            PNode node = (PNode)selectionEn.nextElement();
            gDist.setSize(d);
            node.getParent().globalToLocal(d);
            node.offset(d.getWidth(), d.getHeight());
        }
    }

    protected void endMarqueeSelection(PInputEvent e) {
        this.marquee.removeFromParent();
        this.marquee = null;
    }

    protected void endStandardSelection(PInputEvent e) {
        this.pressNode = null;
    }

    public void keyPressed(PInputEvent e) {
        switch (e.getKeyCode()) {
            case 127: {
                if (!this.deleteKeyActive) break;
                Enumeration selectionEn = this.selection.keys();
                while (selectionEn.hasMoreElements()) {
                    PNode node = (PNode)selectionEn.nextElement();
                    node.removeFromParent();
                }
                this.selection.clear();
            }
        }
    }

    public boolean getSupportDeleteKey() {
        return this.deleteKeyActive;
    }

    public boolean isDeleteKeyActive() {
        return this.deleteKeyActive;
    }

    public void setDeleteKeyActive(boolean deleteKeyActive) {
        this.deleteKeyActive = deleteKeyActive;
    }

    protected class BoundsFilter
    implements PNodeFilter {
        PBounds localBounds = new PBounds();
        PBounds bounds;

        protected BoundsFilter(PBounds bounds) {
            this.bounds = bounds;
        }

        public boolean accept(PNode node) {
            this.localBounds.setRect(this.bounds);
            node.globalToLocal(this.localBounds);
            boolean boundsIntersects = node.intersects(this.localBounds);
            boolean isMarquee = node == PSelectionHandler.this.marquee;
            return node.getPickable() && boundsIntersects && !isMarquee && !PSelectionHandler.this.selectableParents.contains(node) && !this.isCameraLayer(node);
        }

        public boolean acceptChildrenOf(PNode node) {
            return PSelectionHandler.this.selectableParents.contains(node) || this.isCameraLayer(node);
        }

        public boolean isCameraLayer(PNode node) {
            if (node instanceof PLayer) {
                Iterator i = PSelectionHandler.this.selectableParents.iterator();
                while (i.hasNext()) {
                    PNode parent = (PNode)i.next();
                    if (!(parent instanceof PCamera) || ((PCamera)parent).indexOfLayer((PLayer)node) == -1) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

