/*
 * Decompiled with CFR 0.152.
 */
package phoebe.event;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PNodeLocator;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Point2D;
import phoebe.PEdgeView;
import phoebe.PGraphView;
import phoebe.PNodeView;

public class PGraphEditEventHandler
extends PBasicInputEventHandler {
    protected NodeView node;
    protected PPath edge;
    protected boolean edgeStarted;
    protected Point2D startPoint;
    protected Point2D nextPoint;
    protected PCanvas canvas;
    protected PGraphView view;
    PNodeLocator locator;

    public PGraphEditEventHandler(PCanvas canvas, PGraphView view) {
        this.canvas = canvas;
        this.view = view;
        this.locator = new PNodeLocator(new PNode());
        this.setEventFilter(new PInputEventFilter(16));
    }

    public PCanvas getCanvas() {
        return this.canvas;
    }

    public void mousePressed(PInputEvent e) {
        super.mousePressed(e);
        if (e.isControlDown()) {
            this.nextPoint = e.getPosition();
            boolean onNode = false;
            if (e.getPickedNode() instanceof NodeView) {
                onNode = true;
                this.locator.setNode(e.getPickedNode());
                this.locator.locatePoint(this.nextPoint);
                this.nextPoint = e.getPickedNode().localToGlobal(this.nextPoint);
            }
            if (onNode && !this.edgeStarted) {
                this.edgeStarted = true;
                this.node = (NodeView)((Object)e.getPickedNode());
                this.edge = new PPath();
                this.getCanvas().getLayer().addChild(this.edge);
                this.edge.setStroke(new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
                this.edge.setPaint(Color.black);
                this.startPoint = this.nextPoint;
                this.updateEdge();
            } else if (onNode && this.edgeStarted && e.getPickedNode() != this.node) {
                this.edgeStarted = false;
                this.updateEdge();
                NodeView target = (NodeView)((Object)e.getPickedNode());
                NodeView source = this.node;
                int source_root_index = this.view.getGraphPerspective().getRootGraphNodeIndex(source.getGraphPerspectiveIndex());
                int target_root_index = this.view.getGraphPerspective().getRootGraphNodeIndex(target.getGraphPerspectiveIndex());
                PEdgeView edgeView = (PEdgeView)this.view.addEdgeView(this.view.getGraphPerspective().restoreEdge(this.view.getRootGraph().createEdge(source_root_index, target_root_index)));
                edgeView.setStrokeWidth(4.0f);
                edgeView.setUnselectedPaint(new GradientPaint(1.0f, 1.0f, Color.yellow, 20.0f, 20.0f, Color.magenta, true));
                edgeView.setSelectedPaint(new GradientPaint(1.0f, 1.0f, Color.black, 20.0f, 20.0f, Color.white, true));
                this.getCanvas().getLayer().removeChild(this.edge);
                this.edge = null;
                this.node = null;
            } else if (!onNode && !this.edgeStarted) {
                int per_index = this.view.getGraphPerspective().restoreNode(this.view.getRootGraph().createNode());
                this.node = this.view.addNodeView(per_index);
                this.node.setUnselectedPaint(Color.orange);
                this.node.setSelectedPaint(Color.red);
                ((PNodeView)this.node).setOffset(this.nextPoint);
            }
        }
    }

    public void mouseMoved(PInputEvent e) {
        super.mouseMoved(e);
        if (this.edgeStarted) {
            this.nextPoint = e.getPosition();
            this.updateEdge();
        }
    }

    public void updateEdge() {
        double x1 = this.startPoint.getX();
        double y1 = this.startPoint.getY();
        double x2 = this.nextPoint.getX();
        double y2 = this.nextPoint.getY();
        double lineLen = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double offset = 5.0;
        if (lineLen == 0.0) {
            lineLen = 1.0;
        }
        y2 += (y1 - y2) / lineLen * offset;
        x2 += (x1 - x2) / lineLen * offset;
        this.nextPoint.setLocation(x2, y2);
        this.edge.setPathToPolyline(new Point2D[]{this.startPoint, this.nextPoint});
    }
}

