/*
 * Decompiled with CFR 0.152.
 */
package phoebe.event;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.nodes.P3DRect;
import edu.umd.cs.piccolox.util.PNodeLocator;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PCanvasReferencia
extends PCanvas
implements PropertyChangeListener {
    PNode areaVisiblePNode;
    PCanvas viewedCanvas;
    PHandle h;
    boolean bCambioDesdeNode = false;
    boolean bCambioDesdeView = false;

    public PCanvasReferencia(PCanvas canvas, PLayer layer) {
        this.viewedCanvas = canvas;
        this.bCambioDesdeNode = false;
        this.bCambioDesdeView = false;
        this.h = null;
        PropertyChangeListener changeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PCanvasReferencia.this.updateFromViewed();
            }
        };
        this.viewedCanvas.getCamera().addPropertyChangeListener(changeListener);
        this.getCamera().addLayer(0, layer);
        this.areaVisiblePNode = new P3DRect();
        this.areaVisiblePNode.setPaint(new Color(128, 128, 255));
        this.areaVisiblePNode.setTransparency(0.8f);
        this.areaVisiblePNode.setBounds(0.0, 0.0, 100.0, 100.0);
        this.getCamera().addChild(this.areaVisiblePNode);
        this.adjustHandles();
        this.removeInputEventListener(this.getPanEventHandler());
        this.removeInputEventListener(this.getZoomEventHandler());
        this.areaVisiblePNode.addPropertyChangeListener("bounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PCanvasReferencia.this.updateFromView();
            }
        });
        this.areaVisiblePNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PCanvasReferencia.this.updateFromView();
            }
        });
        this.areaVisiblePNode.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PCanvasReferencia.this.updateFromView();
            }
        });
    }

    public void addLayer(PLayer new_layer) {
        this.getCamera().addLayer(new_layer);
    }

    public void removeLayer(PLayer old_layer) {
        this.getCamera().removeLayer(old_layer);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFromViewed();
    }

    public void updateFromView() {
        if (this.bCambioDesdeView) {
            this.bCambioDesdeView = false;
            return;
        }
        Rectangle2D drag_box_bounds = this.getCamera().localToGlobal(this.areaVisiblePNode.getBoundsReference());
        double dragHeight = drag_box_bounds.getHeight();
        double dragWidth = drag_box_bounds.getWidth();
        double dragX = drag_box_bounds.getX();
        double dragY = drag_box_bounds.getY();
        double viewHeight = this.getCamera().getFullBounds().getHeight();
        double viewWidth = this.getCamera().getFullBounds().getWidth();
        double canvasHeight = this.viewedCanvas.getCamera().getFullBounds().getHeight();
        double canvasWidth = this.viewedCanvas.getCamera().getFullBounds().getWidth();
        double viewedX = canvasWidth * dragX / viewWidth;
        double viewedY = canvasHeight * dragY / viewHeight;
        double viewedHeight = canvasHeight * dragHeight / viewHeight;
        double viewedWidth = canvasWidth * dragWidth / viewWidth;
        double zoom = this.getCamera().getViewScale();
        this.bCambioDesdeNode = true;
        this.viewedCanvas.getCamera().animateViewToCenterBounds(new Rectangle2D.Double(viewedX / zoom, viewedY / zoom, viewedWidth / zoom, viewedHeight / zoom), true, 0L);
    }

    public void updateFromViewed() {
        if (this.bCambioDesdeNode) {
            this.bCambioDesdeNode = false;
            return;
        }
        double viewHeight = this.getCamera().getFullBounds().getHeight();
        double viewWidth = this.getCamera().getFullBounds().getWidth();
        double canvasHeight = this.viewedCanvas.getCamera().getFullBounds().getHeight();
        double canvasWidth = this.viewedCanvas.getCamera().getFullBounds().getWidth();
        double viewedX = this.viewedCanvas.getCamera().getViewBounds().getX();
        double viewedY = this.viewedCanvas.getCamera().getViewBounds().getY();
        double viewedHeight = this.viewedCanvas.getCamera().getViewBounds().getHeight();
        double viewedWidth = this.viewedCanvas.getCamera().getViewBounds().getWidth();
        double dragX = viewWidth * viewedX / canvasWidth;
        double dragY = viewHeight * viewedY / canvasHeight;
        double dragWidth = viewWidth * viewedWidth / canvasWidth;
        double dragHeight = viewHeight * viewedHeight / canvasHeight;
        double zoom = this.getCamera().getViewScale();
        this.bCambioDesdeView = true;
        this.areaVisiblePNode.setBounds(dragX * zoom, dragY * zoom, dragWidth * zoom, dragHeight * zoom);
        this.adjustHandles();
    }

    public void adjustHandles() {
        if (this.h != null) {
            PBoundsHandle.removeBoundsHandlesFrom(this.areaVisiblePNode);
            this.areaVisiblePNode.removeChild(this.h);
            this.h = null;
        }
        this.h = new PHandle(new PNodeLocator(this.areaVisiblePNode)){

            public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
                double w = PCanvasReferencia.this.areaVisiblePNode.getWidth();
                double h = PCanvasReferencia.this.areaVisiblePNode.getHeight();
                double x = PCanvasReferencia.this.areaVisiblePNode.getX();
                double y = PCanvasReferencia.this.areaVisiblePNode.getY();
                PCanvasReferencia.this.areaVisiblePNode.setBounds(x + aLocalDimension.getWidth(), y + aLocalDimension.getHeight(), w, h);
            }
        };
        this.areaVisiblePNode.addChild(this.h);
        PBoundsHandle.addBoundsHandlesTo(this.areaVisiblePNode);
    }
}

