/*
 * Decompiled with CFR 0.152.
 */
package phoebe.event;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BirdsEyeView
extends PCanvas
implements PropertyChangeListener {
    PPath areaVisiblePNode;
    PCanvas viewedCanvas;
    PropertyChangeListener changeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BirdsEyeView.this.updateFromViewed();
        }
    };
    int layerCount;

    public BirdsEyeView() {
        this.areaVisiblePNode = PPath.createRectangle(0.0f, 0.0f, 100.0f, 100.0f);
        this.areaVisiblePNode.setPaint(new Color(0.2f, 0.3f, 0.8f, 0.3f));
        this.areaVisiblePNode.setStroke(new PFixedWidthStroke(2.0f));
        this.areaVisiblePNode.setStrokePaint(Color.red);
        this.getCamera().addChild(this.areaVisiblePNode);
        this.getCamera().addInputEventListener(new PDragSequenceEventHandler(){

            protected void startDrag(PInputEvent e) {
                if (e.getPickedNode() == BirdsEyeView.this.areaVisiblePNode) {
                    super.startDrag(e);
                }
            }

            protected void drag(PInputEvent e) {
                PDimension dim = e.getDelta();
                BirdsEyeView.this.viewedCanvas.getCamera().translateView(0.0 - dim.getWidth(), 0.0 - dim.getHeight());
            }
        });
        this.removeInputEventListener(this.getPanEventHandler());
        this.removeInputEventListener(this.getZoomEventHandler());
        this.setDefaultRenderQuality(0);
    }

    public void connect(PCanvas canvas, PLayer[] viewed_layers) {
        this.viewedCanvas = canvas;
        this.layerCount = 0;
        this.viewedCanvas.getCamera().addPropertyChangeListener(this.changeListener);
        this.layerCount = 0;
        while (this.layerCount < viewed_layers.length) {
            this.getCamera().addLayer(this.layerCount, viewed_layers[this.layerCount]);
            ++this.layerCount;
        }
    }

    public void addLayer(PLayer new_layer) {
        this.getCamera().addLayer(new_layer);
        ++this.layerCount;
    }

    public void removeLayer(PLayer old_layer) {
        this.getCamera().removeLayer(old_layer);
        --this.layerCount;
    }

    public void disconnect() {
        this.viewedCanvas.getCamera().removePropertyChangeListener(this.changeListener);
        for (int i = 0; i < this.getCamera().getLayerCount(); ++i) {
            this.getCamera().removeLayer(i);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFromViewed();
    }

    public void updateFromViewed() {
        double ul_camera_x = this.viewedCanvas.getCamera().getViewBounds().getX();
        double ul_camera_y = this.viewedCanvas.getCamera().getViewBounds().getY();
        double lr_camera_x = ul_camera_x + this.viewedCanvas.getCamera().getViewBounds().getWidth();
        double lr_camera_y = ul_camera_y + this.viewedCanvas.getCamera().getViewBounds().getHeight();
        PBounds drag_bounds = this.getCamera().getUnionOfLayerFullBounds();
        double ul_layer_x = ((RectangularShape)drag_bounds).getX();
        double ul_layer_y = ((RectangularShape)drag_bounds).getY();
        double lr_layer_x = ((RectangularShape)drag_bounds).getX() + ((RectangularShape)drag_bounds).getWidth();
        double lr_layer_y = ((RectangularShape)drag_bounds).getY() + ((RectangularShape)drag_bounds).getHeight();
        double viewedX = ul_camera_x < ul_layer_x ? ul_layer_x : ul_camera_x;
        double viewedY = ul_camera_y < ul_layer_y ? ul_layer_y : ul_camera_y;
        double viewedWidth = lr_camera_x < lr_layer_x ? lr_camera_x - viewedX : lr_layer_x - viewedX;
        double viewedHeight = lr_camera_y < lr_layer_y ? lr_camera_y - viewedY : lr_layer_y - viewedY;
        Rectangle2D bounds = new Rectangle2D.Double(viewedX, viewedY, viewedWidth, viewedHeight);
        bounds = this.getCamera().viewToLocal(bounds);
        this.areaVisiblePNode.setBounds(bounds);
        this.getCamera().animateViewToCenterBounds(drag_bounds, true, 0L);
    }
}

