/*
 * Decompiled with CFR 0.152.
 */
package phoebe;

import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.GraphView;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import phoebe.PGraphView;
import phoebe.util.PLabel;

public class PNodeView
extends PPath
implements NodeView,
PropertyChangeListener {
    protected int rootGraphIndex;
    protected PGraphView view;
    protected PLabel label;
    protected boolean selected;
    protected boolean visible;
    protected boolean notUpdated;

    public PNodeView(int node_index, PGraphView view) {
        this(node_index, view, Double.MAX_VALUE, Double.MAX_VALUE, Integer.MAX_VALUE, null, null, null, Float.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, null);
    }

    public PNodeView(int node_index, PGraphView view, double x_positon, double y_positon, int shape, Paint paint, Paint selection_paint, Paint border_paint, float border_width, double width, double height, String label) {
        if (view == null) {
            throw new IllegalArgumentException("A PNodeView must belong to a PGraphView");
        }
        this.view = view;
        if (node_index == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("A node_index must be passed to create a PNodeView");
        }
        this.rootGraphIndex = node_index >= 0 ? view.getGraphPerspective().getRootGraphNodeIndex(node_index) : node_index;
        if (x_positon != Double.MAX_VALUE) {
            view.setNodeDoubleProperty(this.rootGraphIndex, 0, x_positon);
        }
        if (y_positon != Double.MAX_VALUE) {
            view.setNodeDoubleProperty(this.rootGraphIndex, 1, y_positon);
        }
        if (shape != Integer.MAX_VALUE) {
            view.setNodeIntProperty(this.rootGraphIndex, 2, shape);
        }
        if (paint != null) {
            view.setNodeObjectProperty(this.rootGraphIndex, 3, paint);
        }
        if (paint != null) {
            view.setNodeObjectProperty(this.rootGraphIndex, 4, selection_paint);
        }
        if (border_paint != null) {
            view.setNodeObjectProperty(this.rootGraphIndex, 5, border_paint);
        }
        if (border_width != Float.MAX_VALUE) {
            view.setNodeFloatProperty(this.rootGraphIndex, 6, border_width);
        }
        if (width != Double.MAX_VALUE) {
            view.setNodeDoubleProperty(this.rootGraphIndex, 7, width);
        }
        if (height != Double.MAX_VALUE) {
            view.setNodeDoubleProperty(this.rootGraphIndex, 8, height);
        }
        if (label != null) {
            view.setNodeObjectProperty(this.rootGraphIndex, 9, label);
        }
        this.initializeNodeView();
    }

    protected void initializeNodeView() {
        this.setOffset(this.view.getNodeDoubleProperty(this.rootGraphIndex, 0), this.view.getNodeDoubleProperty(this.rootGraphIndex, 1));
        this.setHeight(20.0);
        this.setWidth(20.0);
        this.setStrokePaint(Color.black);
        this.setPaint(Color.white);
        this.visible = true;
        this.selected = false;
        this.notUpdated = false;
        this.setPickable(true);
        this.invalidatePaint();
    }

    public int getIndex() {
        return this.rootGraphIndex;
    }

    public String toString() {
        return "Node: " + this.rootGraphIndex;
    }

    public GraphView getGraphView() {
        return this.view;
    }

    public Node getNode() {
        RootGraph rootGraph = this.view.getGraphPerspective().getRootGraph();
        return rootGraph.getNode(this.rootGraphIndex);
    }

    public int getGraphPerspectiveIndex() {
        return this.view.getGraphPerspective().getNodeIndex(this.rootGraphIndex);
    }

    public int getRootGraphIndex() {
        return this.rootGraphIndex;
    }

    public List getEdgeViewsList(NodeView otherNode) {
        return this.view.getEdgeViewsList(this.getNode(), otherNode.getNode());
    }

    public int getShape() {
        return this.view.getNodeIntProperty(this.rootGraphIndex, 2);
    }

    public void setSelectedPaint(Paint paint) {
        this.view.setNodeObjectProperty(this.rootGraphIndex, 4, paint);
        if (this.selected) {
            this.setPaint(paint);
        }
    }

    public Paint getSelectedPaint() {
        return (Paint)this.view.getNodeObjectProperty(this.rootGraphIndex, 4);
    }

    public void setUnselectedPaint(Paint paint) {
        this.view.setNodeObjectProperty(this.rootGraphIndex, 3, paint);
        if (!this.selected) {
            this.setPaint(paint);
        }
    }

    public Paint getUnselectedPaint() {
        return (Paint)this.view.getNodeObjectProperty(this.rootGraphIndex, 3);
    }

    public void setBorderPaint(Paint b_paint) {
        this.view.setNodeObjectProperty(this.rootGraphIndex, 5, b_paint);
        super.setStrokePaint(b_paint);
    }

    public Paint getBorderPaint() {
        return (Paint)this.view.getNodeObjectProperty(this.rootGraphIndex, 5);
    }

    public void setBorderWidth(float border_width) {
        this.view.setNodeFloatProperty(this.rootGraphIndex, 6, border_width);
        super.setStroke(new BasicStroke(border_width));
    }

    public float getBorderWidth() {
        return this.view.getNodeFloatProperty(this.rootGraphIndex, 6);
    }

    public void setBorder(Stroke stroke) {
        super.setStroke(stroke);
    }

    public Stroke getBorder() {
        return super.getStroke();
    }

    public boolean setWidth(double width) {
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 7, width);
        super.setWidth(width);
        return true;
    }

    public double getWidth() {
        return super.getWidth();
    }

    public boolean setHeight(double height) {
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 8, height);
        super.setHeight(height);
        return true;
    }

    public double getHeight() {
        return super.getHeight();
    }

    public Label getLabel() {
        if (this.label == null) {
            this.label = new PLabel(null, this);
            this.label.setPickable(false);
            this.addChild(this.label);
            this.label.updatePosition();
        }
        return this.label;
    }

    public int getDegree() {
        return this.view.getGraphPerspective().getDegree(this.getNode());
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void setOffset(double x, double y) {
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 0, x);
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 1, y);
        super.setOffset(x, y);
    }

    public void setOffset(Point2D point) {
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 0, point.getX());
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 1, point.getY());
        super.setOffset(point);
    }

    public void offset(double dx, double dy) {
        super.offset(dx, dy);
        Point2D p = this.getOffset();
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 0, p.getX());
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 1, p.getY());
    }

    public void setXPosition(double new_x_position) {
        this.setXPosition(new_x_position, true);
    }

    public void setXPosition(double new_x_position, boolean update) {
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 0, new_x_position);
        if (update) {
            this.setNodePosition(false);
        } else {
            this.notUpdated = true;
        }
    }

    public double getXPosition() {
        if (this.notUpdated) {
            return this.view.getNodeDoubleProperty(this.rootGraphIndex, 0);
        }
        return this.localToGlobal(this.getBounds()).getX();
    }

    public void setYPosition(double new_y_position) {
        this.setYPosition(new_y_position, true);
    }

    public void setYPosition(double new_y_position, boolean update) {
        this.view.setNodeDoubleProperty(this.rootGraphIndex, 1, new_y_position);
        if (update) {
            this.setNodePosition(false);
        } else {
            this.notUpdated = true;
        }
    }

    public double getYPosition() {
        if (this.notUpdated) {
            return this.view.getNodeDoubleProperty(this.rootGraphIndex, 1);
        }
        return this.localToGlobal(this.getBounds()).getY();
    }

    public void setNodePosition(boolean animate) {
        if (animate) {
            PTransformActivity pTransformActivity = this.animateToPositionScaleRotation(this.view.getNodeDoubleProperty(this.rootGraphIndex, 0), this.view.getNodeDoubleProperty(this.rootGraphIndex, 1), 1.0, 0.0, 2000L);
        } else {
            this.setOffset(this.view.getNodeDoubleProperty(this.rootGraphIndex, 0), this.view.getNodeDoubleProperty(this.rootGraphIndex, 1));
        }
        this.firePropertyChange("Offset", null, this);
        this.notUpdated = false;
    }

    public void select() {
        this.selected = true;
        super.setPaint((Paint)this.view.getNodeObjectProperty(this.rootGraphIndex, 4));
        this.view.nodeSelected(this);
    }

    public void unselect() {
        this.selected = false;
        super.setPaint((Paint)this.view.getNodeObjectProperty(this.rootGraphIndex, 3));
        this.view.nodeUnselected(this);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean setSelected(boolean selected) {
        if (selected) {
            this.view.getSelectionHandler().select(this);
        } else {
            this.view.getSelectionHandler().unselect(this);
        }
        return this.selected;
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        boolean b = super.setBounds(x, y, width, height);
        this.firePropertyChange("BoundsChanged", null, this);
        if (this.label != null) {
            this.label.updatePosition();
        }
        return b;
    }

    public void setShape(int shape) {
        PBounds bounds = this.getBounds();
        float x = (float)this.getWidth();
        float y = (float)this.getHeight();
        Point2D offset = this.getOffset();
        this.view.setNodeIntProperty(this.rootGraphIndex, 2, shape);
        if (shape == 0) {
            this.setPathTo(PPath.createPolyline(new float[]{0.0f * x, 2.0f * x, 1.0f * x, 0.0f * x}, new float[]{2.0f * y, 2.0f * y, 0.0f * y, 2.0f * y}).getPathReference());
        } else if (shape == 7) {
            GeneralPath path = new GeneralPath();
            path.moveTo(1.0f, 0.0f);
            path.lineTo(2.0f, 0.0f);
            path.quadTo(3.0f, 0.0f, 3.0f, 1.0f);
            path.lineTo(3.0f, 2.0f);
            path.quadTo(3.0f, 3.0f, 2.0f, 3.0f);
            path.lineTo(1.0f, 3.0f);
            path.quadTo(0.0f, 3.0f, 0.0f, 2.0f);
            path.lineTo(0.0f, 1.0f);
            path.quadTo(0.0f, 0.0f, 1.0f, 0.0f);
            path.closePath();
            this.setPathTo(path);
        } else if (shape == 1) {
            this.setPathTo(PPath.createPolyline(new float[]{1.0f * x, 2.0f * x, 1.0f * x, 0.0f * x, 1.0f * x}, new float[]{0.0f * y, 1.0f * y, 2.0f * y, 1.0f * y, 0.0f * y}).getPathReference());
        } else if (shape == 2) {
            this.setPathTo(PPath.createEllipse((float)this.getBounds().getX(), (float)this.getBounds().getY(), (float)this.getBounds().getWidth(), (float)this.getBounds().getHeight()).getPathReference());
        } else if (shape == 3) {
            this.setPathTo(PPath.createPolyline(new float[]{0.0f * x, 1.0f * x, 2.0f * x, 3.0f * x, 2.0f * x, 1.0f * x, 0.0f * x}, new float[]{1.0f * y, 2.0f * y, 2.0f * y, 1.0f * y, 0.0f * y, 0.0f * y, 1.0f * y}).getPathReference());
        } else if (shape == 4) {
            this.setPathTo(PPath.createPolyline(new float[]{0.0f * x, 0.0f * x, 1.0f * x, 2.0f * x, 3.0f * x, 3.0f * x, 2.0f * x, 1.0f * x, 0.0f * x}, new float[]{1.0f * y, 2.0f * y, 3.0f * y, 3.0f * y, 2.0f * y, 1.0f * y, 0.0f * y, 0.0f * y, 1.0f * y}).getPathReference());
        } else if (shape == 5) {
            this.setPathTo(PPath.createPolyline(new float[]{0.0f * x, 1.0f * x, 3.0f * x, 2.0f * x, 0.0f * x}, new float[]{0.0f * y, 1.0f * y, 1.0f * y, 0.0f * y, 0.0f * y}).getPathReference());
        } else if (shape == 6) {
            this.setPathToRectangle((float)this.getX(), (float)this.getY(), x, y);
        }
        this.setX(bounds.getX());
        this.setY(bounds.getY());
        this.setWidth(bounds.getWidth());
        this.setHeight(bounds.getHeight());
        if (this.label != null) {
            this.label.updatePosition();
        }
        this.firePropertyChange("Offset", null, this);
    }

    public void setShape(int shape, double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setShape(shape);
        this.firePropertyChange("Offset", null, this);
    }

    public void setFont(Font font) {
        this.label.setFont(font);
    }

    public void setToolTip(String tip) {
        this.addClientProperty("tooltip", tip);
    }

    public void moveBy(double dx, double dy) {
        this.offset(dx, dy);
    }

    public void setCenter(double x, double y) {
        this.setOffset(x, y);
    }

    public void setLocation(double x, double y) {
        this.setOffset(x, y);
    }

    public void setSize(double w, double h) {
        this.setHeight(h);
        this.setWidth(w);
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public void setLabelText(String newL) {
        this.label.setText(newL);
    }
}

