/*
 * Decompiled with CFR 0.152.
 */
package phoebe;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import coltginy.ColtGraphViewModel;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolox.swing.PScrollPane;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import phoebe.PEdgeView;
import phoebe.PNodeView;
import phoebe.event.BirdsEyeView;
import phoebe.event.PContextMenu;
import phoebe.event.PEdgeHandler;
import phoebe.event.PEdgeSelectionHandler;
import phoebe.event.PGraphEditEventHandler;
import phoebe.event.PSelectionHandler;
import phoebe.event.PToolTipHandler;
import phoebe.event.SquiggleEventHandler;
import phoebe.util.PrintingFixTextNode;

public class PGraphView
extends ColtGraphViewModel
implements GraphView {
    protected boolean isInitialized = false;
    private PCanvas canvas;
    protected OpenIntObjectHashMap nodeViewMap;
    protected OpenIntObjectHashMap edgeViewMap;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected JPanel viewComponent;
    protected PSelectionHandler selectionHandler;
    protected PEdgeSelectionHandler edgeSelectionHandler;
    protected PGraphEditEventHandler graphEditEventHandler;
    protected PEdgeHandler edgeHandler;
    protected PContextMenu contextMenu;
    protected PToolTipHandler toolTipHandler;
    protected SquiggleEventHandler squiggleEventHandler;
    protected boolean edgeSelection = false;
    protected boolean nodeSelection = false;
    protected PLayer nodeLayer;
    protected PLayer edgeLayer;
    protected PLayer objectLayer;
    protected PLayer squiggleLayer;
    protected Color DEFAULT_BACKGROUND_COLOR = new Color(60, 98, 176);
    protected Object[] NODE_DEFAULTS;
    protected Object[] EDGE_DEFAULTS;
    protected HashMap contextMenuStore;
    protected boolean noNodeSelection = true;
    protected IntArrayList nodeSelectionList;
    protected boolean noEdgeSelection = true;
    protected IntArrayList edgeSelectionList;
    protected ChangeEvent phoebeGraphViewChangeEvent;
    protected static boolean firePiccoloEvents = true;
    EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$giny$view$GraphViewChangeListener;
    static /* synthetic */ Class class$phoebe$PGraphView;

    public PGraphView(String identifier, GraphPerspective perspective, boolean setup) {
        super(identifier, perspective);
        this.initializePGraphView(setup);
    }

    public PGraphView(String identifier, GraphPerspective perspective) {
        super(identifier, perspective);
        this.initializePGraphView(true);
    }

    public PGraphView(GraphPerspective perspective) {
        super(perspective);
        this.initializePGraphView(true);
    }

    protected void initializePGraphView(boolean setup) {
        this.isInitialized = true;
        this.viewComponent = new JPanel();
        this.viewComponent.setLayout(new BorderLayout());
        this.canvas = new PCanvas();
        PScrollPane scroll = new PScrollPane(this.canvas);
        this.viewComponent.add((Component)scroll, "Center");
        this.getCanvas().getCamera().setPaint(this.DEFAULT_BACKGROUND_COLOR);
        this.nodeLayer = new PLayer(){

            public void addChild(int index, PNode child) {
                PNode oldParent = child.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(child);
                }
                child.setParent(this);
                this.getChildrenReference().add(index, child);
                child.invalidatePaint();
                this.invalidateFullBounds();
                if (firePiccoloEvents) {
                    this.firePropertyChange("children", null, this.getChildrenReference());
                }
            }
        };
        this.edgeLayer = new PLayer(){

            public void addChild(int index, PNode child) {
                PNode oldParent = child.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(child);
                }
                child.setParent(this);
                this.getChildrenReference().add(index, child);
                child.invalidatePaint();
                this.invalidateFullBounds();
                if (firePiccoloEvents) {
                    this.firePropertyChange("children", null, this.getChildrenReference());
                }
            }
        };
        this.objectLayer = new PLayer();
        this.squiggleLayer = new PLayer();
        this.getCanvas().getLayer().addChild(this.edgeLayer);
        this.getCanvas().getLayer().addChild(this.nodeLayer);
        this.getCanvas().getLayer().addChild(this.objectLayer);
        this.initializeEventHandlers();
        this.nodeViewMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(this.perspective.getNodeCount()));
        this.edgeViewMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(this.perspective.getEdgeCount()));
        this.contextMenuStore = new HashMap(5);
        this.NODE_DEFAULTS = new Object[]{new Double(this.DEFAULT_X), new Double(this.DEFAULT_Y), new Integer(4), DEFAULT_NODE_PAINT, DEFAULT_NODE_SELECTION_PAINT, DEFAULT_BORDER_PAINT, new Float(1.0f), new Double(20.0), new Double(20.0), "Node"};
        this.EDGE_DEFAULTS = new Object[]{new Integer(0), new Integer(0), new Float(1.0f), new Integer(2), DEFAULT_EDGE_STROKE_PAINT, DEFAULT_EDGE_STROKE_PAINT_SELECTION, new Integer(2), DEFAULT_EDGE_END_PAINT, DEFAULT_EDGE_END_PAINT, new Integer(3), DEFAULT_EDGE_END_PAINT, DEFAULT_EDGE_END_PAINT};
        if (setup) {
            this.createViewableObjects();
        }
        this.ensureNodeSelectionCapacity();
        this.ensureEdgeSelectionCapacity();
    }

    protected void initializeEventHandlers() {
        this.selectionHandler = new PSelectionHandler(this.getCanvas().getLayer(), this.getNodeLayer(), this.getCanvas().getCamera());
        this.selectionHandler.setEventFilter(new PInputEventFilter(16));
        this.edgeSelectionHandler = new PEdgeSelectionHandler(this.getCanvas().getLayer(), this.getEdgeLayer(), this.getCanvas().getCamera());
        this.edgeSelectionHandler.setEventFilter(new PInputEventFilter(16));
        this.graphEditEventHandler = new PGraphEditEventHandler(this.getCanvas(), this);
        this.getCanvas().getPanEventHandler().setEventFilter(new PInputEventFilter(8));
        PZoomEventHandler zoomer = new PZoomEventHandler(){

            public void dragActivityFinalStep(PInputEvent e) {
                if (e.getCamera().getViewScale() < 0.45) {
                    PGraphView.this.getCanvas().setDefaultRenderQuality(0);
                } else {
                    PGraphView.this.getCanvas().setDefaultRenderQuality(1);
                }
            }
        };
        zoomer.setMinScale(0.05);
        zoomer.setMaxScale(20.0);
        zoomer.setEventFilter(new PInputEventFilter(4));
        this.getCanvas().setZoomEventHandler(zoomer);
        this.edgeHandler = new PEdgeHandler(this);
        this.getCanvas().addInputEventListener(this.edgeHandler);
        this.contextMenu = new PContextMenu(this);
        this.contextMenu.setEventFilter(new PInputEventFilter(4));
        this.getCanvas().addInputEventListener(this.contextMenu);
        this.toolTipHandler = new PToolTipHandler(this.getCanvas().getCamera());
        this.getCanvas().getCamera().addInputEventListener(this.toolTipHandler);
        this.squiggleEventHandler = new SquiggleEventHandler(this.squiggleLayer, this.getCanvas(), this);
    }

    public PEdgeHandler getEdgeHandler() {
        return this.edgeHandler;
    }

    public void nodeSelected(PNodeView node) {
        ChangeEvent event = this.getChangeEvent();
        event.reset();
        int index = node.getGraphPerspectiveIndex();
        try {
            this.nodeSelectionList.set(index, 1);
        }
        catch (IndexOutOfBoundsException e) {
            this.ensureNodeSelectionCapacity();
            this.nodeSelectionList.set(index, 1);
        }
        this.noNodeSelection = false;
        event.addSelectedNodeIndex(node.getRootGraphIndex());
        if (event != null) {
            this.fireGraphViewChanged(event);
        }
    }

    public void nodeUnselected(PNodeView node) {
        ChangeEvent event = this.getChangeEvent();
        event.reset();
        int index = node.getGraphPerspectiveIndex();
        try {
            this.nodeSelectionList.set(index, 0);
        }
        catch (IndexOutOfBoundsException e) {
            this.ensureNodeSelectionCapacity();
            this.nodeSelectionList.set(index, 0);
        }
        this.noNodeSelection = false;
        event.addUnselectedNodeIndex(node.getRootGraphIndex());
        if (event != null) {
            this.fireGraphViewChanged(event);
        }
    }

    public void edgeSelected(PEdgeView edge) {
        ChangeEvent event = this.getChangeEvent();
        event.reset();
        int index = edge.getGraphPerspectiveIndex();
        try {
            this.edgeSelectionList.set(index, 1);
        }
        catch (IndexOutOfBoundsException e) {
            this.ensureEdgeSelectionCapacity();
            this.edgeSelectionList.set(index, 1);
        }
        this.noEdgeSelection = false;
        event.addSelectedEdgeIndex(edge.getRootGraphIndex());
        if (event != null) {
            this.fireGraphViewChanged(event);
        }
    }

    public void edgeUnselected(PEdgeView edge) {
        ChangeEvent event = this.getChangeEvent();
        event.reset();
        int index = edge.getGraphPerspectiveIndex();
        if (index <= 0) {
            this.clearEdgeSelectionList();
            event.addUnselectedEdge(edge.getEdge());
            event.addUnselectedEdgeIndex(edge.getEdge().getRootGraphIndex());
        } else {
            try {
                this.edgeSelectionList.set(index, 0);
            }
            catch (IndexOutOfBoundsException e) {
                this.ensureEdgeSelectionCapacity();
                this.edgeSelectionList.set(index, 0);
            }
            event.addUnselectedEdgeIndex(edge.getRootGraphIndex());
        }
        if (event != null) {
            this.fireGraphViewChanged(event);
        }
    }

    protected void clearNodeSelectionList() {
        int[] zeroes = new int[this.perspective.getNodeCount() + 1];
        for (int i = 0; i < this.perspective.getNodeCount(); ++i) {
            zeroes[i] = 0;
        }
        this.nodeSelectionList = (IntArrayList)this.nodeSelectionList.elements(zeroes);
    }

    protected void ensureNodeSelectionCapacity() {
        int[] fill = new int[this.perspective.getNodeCount() + 1];
        Arrays.fill(fill, 0);
        this.nodeSelectionList = new IntArrayList(fill);
    }

    protected void clearEdgeSelectionList() {
        int[] zeroes = new int[this.perspective.getEdgeCount() + 1];
        Arrays.fill(zeroes, 0);
        this.edgeSelectionList.elements(zeroes);
    }

    protected void ensureEdgeSelectionCapacity() {
        int[] fill = new int[this.perspective.getEdgeCount() + 1];
        Arrays.fill(fill, 0);
        this.edgeSelectionList = new IntArrayList(fill);
    }

    protected void listSelection() {
        for (int i = 0; i < this.nodeSelectionList.size() + 1; ++i) {
            if (this.nodeSelectionList.get(i) != 1) continue;
            System.out.println("Selected: " + i + " :: " + this.nodeSelectionList.get(i));
        }
    }

    protected void listEdgeSelection() {
        for (int i = 0; i < this.edgeSelectionList.size() + 1; ++i) {
            System.out.println("Selected: " + i + " :: " + this.edgeSelectionList.get(i));
        }
    }

    public int[] getSelectedNodeIndices() {
        IntArrayList selected = new IntArrayList(this.nodeSelectionList.size());
        for (int i = 1; i < this.nodeSelectionList.size(); ++i) {
            if (this.nodeSelectionList.get(i) != 1) continue;
            selected.add(this.perspective.getRootGraphNodeIndex(i));
        }
        selected.trimToSize();
        return selected.elements();
    }

    public List getSelectedNodes() {
        ArrayList<NodeView> selected = new ArrayList<NodeView>(this.nodeSelectionList.size());
        for (int i = 1; i < this.nodeSelectionList.size(); ++i) {
            if (this.nodeSelectionList.get(i) != 1) continue;
            selected.add(this.getNodeView(i));
        }
        return selected;
    }

    public int[] getSelectedEdgeIndices() {
        IntArrayList selected = new IntArrayList(this.edgeSelectionList.size());
        for (int i = 1; i < this.edgeSelectionList.size(); ++i) {
            if (this.edgeSelectionList.get(i) != 1) continue;
            selected.add(this.perspective.getRootGraphEdgeIndex(i));
        }
        selected.trimToSize();
        return selected.elements();
    }

    public List getSelectedEdges() {
        ArrayList<EdgeView> selected = new ArrayList<EdgeView>(this.edgeSelectionList.size());
        for (int i = 1; i < this.edgeSelectionList.size(); ++i) {
            if (this.edgeSelectionList.get(i) != 1) continue;
            selected.add(this.getEdgeView(i));
        }
        return selected;
    }

    public void prepareToPrint() {
        this.getCanvas().getCamera().addClientProperty(PrintingFixTextNode.PRINTING_CLIENT_PROPERTY_KEY, "true");
    }

    public void donePrinting() {
        this.getCanvas().getCamera().addClientProperty(PrintingFixTextNode.PRINTING_CLIENT_PROPERTY_KEY, null);
    }

    public double getWidth() {
        return this.getCanvas().getWidth();
    }

    public double getHeight() {
        return this.getCanvas().getHeight();
    }

    public void addGraphViewChangeListener(GraphViewChangeListener listener) {
        this.listenerList.add(class$giny$view$GraphViewChangeListener == null ? (class$giny$view$GraphViewChangeListener = PGraphView.class$("giny.view.GraphViewChangeListener")) : class$giny$view$GraphViewChangeListener, listener);
    }

    public void removeGraphViewChangeListener(GraphViewChangeListener listener) {
        this.listenerList.remove(class$giny$view$GraphViewChangeListener == null ? (class$giny$view$GraphViewChangeListener = PGraphView.class$("giny.view.GraphViewChangeListener")) : class$giny$view$GraphViewChangeListener, listener);
    }

    protected void fireGraphViewChanged(ChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$giny$view$GraphViewChangeListener == null ? PGraphView.class$("giny.view.GraphViewChangeListener") : class$giny$view$GraphViewChangeListener)) continue;
            ((GraphViewChangeListener)listeners[i + 1]).graphViewChanged(event);
        }
        event.reset();
    }

    protected ChangeEvent getChangeEvent() {
        if (this.phoebeGraphViewChangeEvent == null) {
            this.phoebeGraphViewChangeEvent = this.createChangeEvent();
        }
        return this.phoebeGraphViewChangeEvent;
    }

    protected ChangeEvent createChangeEvent() {
        return new ChangeEvent();
    }

    public void setBackgroundPaint(Paint paint) {
        this.getCanvas().getCamera().setPaint(paint);
    }

    public Paint getBackgroundPaint() {
        return this.getCanvas().getCamera().getPaint();
    }

    public boolean nodeSelectionEnabled() {
        return this.nodeSelection;
    }

    public boolean edgeSelectionEnabled() {
        return this.edgeSelection;
    }

    public void enableNodeSelection() {
        if (!this.nodeSelection) {
            this.getCanvas().addInputEventListener(this.getSelectionHandler());
        }
        this.nodeSelection = true;
    }

    public void disableNodeSelection() {
        if (this.nodeSelection) {
            this.getCanvas().removeInputEventListener(this.getSelectionHandler());
        }
        this.nodeSelection = false;
    }

    public PSelectionHandler getSelectionHandler() {
        return this.selectionHandler;
    }

    public void enableEdgeSelection() {
        if (!this.edgeSelection) {
            this.getCanvas().addInputEventListener(this.getEdgeSelectionHandler());
        }
        this.edgeSelection = true;
    }

    public void disableEdgeSelection() {
        if (this.edgeSelection) {
            this.getCanvas().removeInputEventListener(this.getEdgeSelectionHandler());
        }
        this.edgeSelection = false;
    }

    public PEdgeSelectionHandler getEdgeSelectionHandler() {
        return this.edgeSelectionHandler;
    }

    public void enablePanning() {
        this.getCanvas().addInputEventListener(this.getCanvas().getPanEventHandler());
    }

    public void disablePanning() {
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
    }

    public SquiggleEventHandler getSquiggleHandler() {
        return this.squiggleEventHandler;
    }

    public void openNodeEditor(NodeView nv) {
    }

    public JComponent getBirdsEyeView() {
        BirdsEyeView canvas = new BirdsEyeView();
        canvas.connect(this.getCanvas(), new PLayer[]{this.getCanvas().getLayer()});
        return canvas;
    }

    public Component getComponent() {
        return this.viewComponent;
    }

    public PCanvas getCanvas() {
        return this.canvas;
    }

    public PLayer getNodeLayer() {
        return this.nodeLayer;
    }

    public PLayer getEdgeLayer() {
        return this.edgeLayer;
    }

    public PLayer getObjectLayer() {
        return this.objectLayer;
    }

    public void addToNodeLayer(PNode node) {
        this.nodeLayer.addChild(node);
    }

    public void addToEdgeLayer(PNode edge) {
        this.edgeLayer.addChild(edge);
    }

    protected void createViewableObjects() {
        firePiccoloEvents = false;
        long time = System.currentTimeMillis();
        int[] node_indices = this.perspective.getNodeIndicesArray();
        ArrayList<PNodeView> node_view_list = new ArrayList<PNodeView>(node_indices.length);
        for (int index = 0; index < node_indices.length; ++index) {
            if (this.DEFAULT_X % 2000.0 == 0.0) {
                this.DEFAULT_Y += 100.0;
                this.DEFAULT_X = 100.0;
            } else {
                this.DEFAULT_X += 100.0;
            }
            this.NODE_DEFAULTS[0] = new Double(this.DEFAULT_X);
            this.NODE_DEFAULTS[1] = new Double(this.DEFAULT_Y);
            this.setAllNodePropertyData(node_indices[index], (Object[])this.NODE_DEFAULTS.clone());
            PNodeView node_view = new PNodeView(node_indices[index], this);
            this.nodeViewMap.put(node_indices[index], node_view);
            node_view_list.add(node_view);
            this.addToNodeLayer(node_view);
        }
        System.out.println("Create Nodes took: " + (System.currentTimeMillis() - time));
        int[] edge_indices = this.perspective.getEdgeIndicesArray();
        ArrayList<PEdgeView> edge_view_list = new ArrayList<PEdgeView>(edge_indices.length);
        for (int i = 0; i < edge_indices.length; ++i) {
            int source_index = this.perspective.getEdgeSourceIndex(edge_indices[i]);
            int target_index = this.perspective.getEdgeTargetIndex(edge_indices[i]);
            this.EDGE_DEFAULTS[0] = new Integer(source_index);
            this.EDGE_DEFAULTS[1] = new Integer(target_index);
            this.setAllEdgePropertyData(edge_indices[i], (Object[])this.EDGE_DEFAULTS.clone());
            PEdgeView edge_view = new PEdgeView(edge_indices[i], this);
            this.addToEdgeLayer(edge_view);
            edge_view_list.add(edge_view);
            this.edgeViewMap.put(edge_indices[i], edge_view);
        }
        firePiccoloEvents = true;
        System.out.println("Create Viewable Object took: " + (System.currentTimeMillis() - time));
    }

    public NodeView addNodeView(int node_index) {
        this.ensureNodeSelectionCapacity();
        if (node_index > 0) {
            node_index = this.getGraphPerspective().getRootGraphNodeIndex(node_index);
        }
        if (this.DEFAULT_X % 2000.0 == 0.0) {
            this.DEFAULT_Y += 100.0;
            this.DEFAULT_X = 100.0;
        } else {
            this.DEFAULT_X += 100.0;
        }
        this.NODE_DEFAULTS[0] = new Double(this.DEFAULT_X);
        this.NODE_DEFAULTS[1] = new Double(this.DEFAULT_Y);
        this.setAllNodePropertyData(node_index, (Object[])this.NODE_DEFAULTS.clone());
        PNodeView node_view = new PNodeView(node_index, this);
        this.nodeViewMap.put(node_index, node_view);
        this.addToNodeLayer(node_view);
        return node_view;
    }

    public EdgeView addEdgeView(int edge_index) {
        this.ensureEdgeSelectionCapacity();
        if (edge_index > 0) {
            edge_index = this.getGraphPerspective().getRootGraphEdgeIndex(edge_index);
        }
        this.EDGE_DEFAULTS[0] = new Integer(this.getGraphPerspective().getRootGraph().getEdgeSourceIndex(edge_index));
        this.EDGE_DEFAULTS[1] = new Integer(this.getGraphPerspective().getRootGraph().getEdgeTargetIndex(edge_index));
        this.setAllEdgePropertyData(edge_index, (Object[])this.EDGE_DEFAULTS.clone());
        PEdgeView edge_view = new PEdgeView(edge_index, this);
        this.addToEdgeLayer(edge_view);
        this.edgeViewMap.put(edge_index, edge_view);
        return edge_view;
    }

    public EdgeView addEdgeView(String class_name, int edge_index) {
        this.ensureEdgeSelectionCapacity();
        PNode edge_view = null;
        try {
            Class<?> custom_class = Class.forName(class_name);
            Class[] types = new Class[]{Integer.TYPE, class$phoebe$PGraphView == null ? (class$phoebe$PGraphView = PGraphView.class$("phoebe.PGraphView")) : class$phoebe$PGraphView};
            if (edge_index > 0) {
                edge_index = this.getGraphPerspective().getRootGraphEdgeIndex(edge_index);
            }
            this.EDGE_DEFAULTS[0] = new Integer(this.getGraphPerspective().getRootGraph().getEdgeSourceIndex(edge_index));
            this.EDGE_DEFAULTS[1] = new Integer(this.getGraphPerspective().getRootGraph().getEdgeTargetIndex(edge_index));
            this.setAllEdgePropertyData(edge_index, (Object[])this.EDGE_DEFAULTS.clone());
            Object[] values = new Object[]{new Integer(edge_index), this};
            Constructor<?> custom_constructor = custom_class.getConstructor(types);
            edge_view = (PNode)custom_constructor.newInstance(values);
            this.edgeViewMap.put(edge_index, edge_view);
            this.addToEdgeLayer(edge_view);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (EdgeView)((Object)edge_view);
    }

    public NodeView addNodeView(String class_name, int node_index) {
        this.ensureNodeSelectionCapacity();
        PNode node_view = null;
        try {
            Class<?> custom_class = Class.forName(class_name);
            Class[] types = new Class[]{Integer.TYPE, class$phoebe$PGraphView == null ? (class$phoebe$PGraphView = PGraphView.class$("phoebe.PGraphView")) : class$phoebe$PGraphView};
            if (node_index > 0) {
                node_index = this.getGraphPerspective().getRootGraphNodeIndex(node_index);
            }
            if (this.nodeViewMap.get(node_index) != null) {
                this.nodeLayer.removeChild((PNode)this.nodeViewMap.get(node_index));
                Object[] values = new Object[]{new Integer(node_index), this};
                Constructor<?> custom_constructor = custom_class.getConstructor(types);
                node_view = (PNode)custom_constructor.newInstance(values);
                this.nodeViewMap.put(node_index, node_view);
                this.addToNodeLayer(node_view);
                int[] neighbors = this.getGraphPerspective().neighborsArray(node_index);
                for (int i = 0; i < neighbors.length; ++i) {
                    PEdgeView edge;
                    int j;
                    int[] edge_array = this.getGraphPerspective().getEdgeIndicesArray(node_index, neighbors[i], true);
                    int[] opposite_direction_edge_array = this.getGraphPerspective().getEdgeIndicesArray(neighbors[i], node_index, true);
                    if (edge_array != null) {
                        for (j = 0; j < edge_array.length; ++j) {
                            edge = (PEdgeView)this.getEdgeView(edge_array[j]);
                            edge.updateConnection(this.getGraphPerspective().getNodeIndex(node_index));
                        }
                    }
                    if (opposite_direction_edge_array == null) continue;
                    for (j = 0; j < opposite_direction_edge_array.length; ++j) {
                        edge = (PEdgeView)this.getEdgeView(opposite_direction_edge_array[j]);
                        edge.updateConnection(this.getGraphPerspective().getNodeIndex(node_index));
                    }
                }
            } else {
                if (this.DEFAULT_X % 2000.0 == 0.0) {
                    this.DEFAULT_Y += 100.0;
                    this.DEFAULT_X = 100.0;
                } else {
                    this.DEFAULT_X += 100.0;
                }
                this.NODE_DEFAULTS[0] = new Double(this.DEFAULT_X);
                this.NODE_DEFAULTS[1] = new Double(this.DEFAULT_Y);
                this.setAllNodePropertyData(node_index, (Object[])this.NODE_DEFAULTS.clone());
                Object[] values = new Object[]{new Integer(node_index), this};
                Constructor<?> custom_constructor = custom_class.getConstructor(types);
                node_view = (PNode)custom_constructor.newInstance(values);
                this.nodeViewMap.put(node_index, node_view);
                this.addToNodeLayer(node_view);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (NodeView)((Object)node_view);
    }

    public NodeView addNodeView(int node_index, NodeView node_view_replacement) {
        this.ensureNodeSelectionCapacity();
        if (node_index > 0) {
            node_index = this.getGraphPerspective().getRootGraphNodeIndex(node_index);
        }
        if (!(node_view_replacement instanceof PNode)) {
            return null;
        }
        PNode node_view = (PNode)((Object)node_view_replacement);
        if (this.nodeViewMap.get(node_index) != null) {
            this.nodeLayer.removeChild((PNode)this.nodeViewMap.get(node_index));
            this.nodeViewMap.put(node_index, node_view);
            this.addToNodeLayer(node_view);
            int[] neighbors = this.getGraphPerspective().neighborsArray(node_index);
            for (int i = 0; i < neighbors.length; ++i) {
                PEdgeView edge;
                int j;
                int[] edge_array = this.getGraphPerspective().getEdgeIndicesArray(node_index, neighbors[i], true);
                int[] opposite_direction_edge_array = this.getGraphPerspective().getEdgeIndicesArray(neighbors[i], node_index, true);
                if (edge_array != null) {
                    for (j = 0; j < edge_array.length; ++j) {
                        edge = (PEdgeView)this.getEdgeView(edge_array[j]);
                        if (edge == null) continue;
                        edge.updateConnection(this.getGraphPerspective().getNodeIndex(node_index));
                    }
                }
                if (opposite_direction_edge_array == null) continue;
                for (j = 0; j < opposite_direction_edge_array.length; ++j) {
                    edge = (PEdgeView)this.getEdgeView(opposite_direction_edge_array[j]);
                    if (edge == null) continue;
                    edge.updateConnection(this.getGraphPerspective().getNodeIndex(node_index));
                }
            }
        } else {
            this.nodeViewMap.put(node_index, node_view);
            this.addToNodeLayer(node_view);
        }
        return (NodeView)((Object)node_view);
    }

    public NodeView removeNodeView(NodeView node_view) {
        try {
            ((PNode)((Object)node_view)).removeFromParent();
        }
        catch (Exception e) {
            return null;
        }
        this.nodeViewMap.removeKey(this.perspective.getRootGraphNodeIndex(node_view.getGraphPerspectiveIndex()));
        this.ensureNodeSelectionCapacity();
        this.nodeSelectionList.setQuick(node_view.getGraphPerspectiveIndex(), 0);
        return node_view;
    }

    public NodeView removeNodeView(Node node) {
        PNodeView node_view = (PNodeView)this.getNodeView(node);
        try {
            node_view.removeFromParent();
        }
        catch (Exception e) {
            return null;
        }
        this.nodeViewMap.removeKey(this.perspective.getRootGraphNodeIndex(node_view.getGraphPerspectiveIndex()));
        this.ensureNodeSelectionCapacity();
        this.nodeSelectionList.setQuick(node_view.getGraphPerspectiveIndex(), 0);
        return node_view;
    }

    public NodeView removeNodeView(int node) {
        PNodeView node_view = (PNodeView)this.getNodeView(node);
        try {
            node_view.removeFromParent();
        }
        catch (Exception e) {
            return null;
        }
        this.nodeViewMap.removeKey(this.perspective.getRootGraphNodeIndex(node_view.getGraphPerspectiveIndex()));
        this.ensureNodeSelectionCapacity();
        this.nodeSelectionList.setQuick(node_view.getGraphPerspectiveIndex(), 0);
        return node_view;
    }

    public EdgeView removeEdgeView(EdgeView edge_view) {
        try {
            ((PNode)((Object)edge_view)).removeFromParent();
        }
        catch (Exception e) {
            return null;
        }
        this.edgeViewMap.removeKey(this.perspective.getRootGraphEdgeIndex(edge_view.getGraphPerspectiveIndex()));
        this.ensureEdgeSelectionCapacity();
        this.edgeSelectionList.setQuick(edge_view.getGraphPerspectiveIndex(), 0);
        return edge_view;
    }

    public EdgeView removeEdgeView(Edge edge) {
        PEdgeView edge_view = (PEdgeView)this.getEdgeView(edge);
        try {
            edge_view.removeFromParent();
        }
        catch (Exception e) {
            return null;
        }
        this.edgeViewMap.removeKey(this.perspective.getRootGraphEdgeIndex(edge_view.getGraphPerspectiveIndex()));
        this.ensureEdgeSelectionCapacity();
        this.edgeSelectionList.setQuick(edge_view.getGraphPerspectiveIndex(), 0);
        return edge_view;
    }

    public EdgeView removeEdgeView(int edge) {
        PEdgeView edge_view = (PEdgeView)this.getEdgeView(edge);
        try {
            edge_view.removeFromParent();
        }
        catch (Exception e) {
            return null;
        }
        if (edge < 0) {
            boolean yes = this.edgeViewMap.removeKey(edge);
        } else {
            boolean bl = this.edgeViewMap.removeKey(this.perspective.getRootGraphEdgeIndex(edge_view.getGraphPerspectiveIndex()));
        }
        this.ensureEdgeSelectionCapacity();
        this.edgeSelectionList.setQuick(edge_view.getGraphPerspectiveIndex(), 0);
        return edge_view;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String new_identifier) {
        if (this.identifier == null ? new_identifier == null : new_identifier != null && this.identifier.equals(new_identifier)) {
            return;
        }
        String old_identifier = this.identifier;
        this.identifier = new_identifier;
        this.pcs.firePropertyChange("identifier", old_identifier, new_identifier);
    }

    public double getZoom() {
        return this.getCanvas().getCamera().getViewScale();
    }

    public void setZoom(double d) {
        Point2D point = this.getCanvas().getCamera().getBounds().getCenter2D();
        point = this.getCanvas().getCamera().localToView(point);
        this.getCanvas().getCamera().scaleViewAboutPoint(d, point.getX(), point.getY());
    }

    public void fitContent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PGraphView.this.getCanvas().getCamera().animateViewToCenterBounds(PGraphView.this.getCanvas().getLayer().getFullBounds(), true, 500L);
                if (PGraphView.this.getCanvas().getCamera().getViewScale() < 0.45) {
                    PGraphView.this.getCanvas().setDefaultRenderQuality(0);
                }
            }
        });
    }

    public void updateView() {
    }

    public RootGraph getRootGraph() {
        return this.perspective.getRootGraph();
    }

    public List getNodeViewsList() {
        ArrayList<NodeView> list = new ArrayList<NodeView>(this.getNodeViewCount());
        int[] gp_indices = this.perspective.getNodeIndicesArray();
        for (int i = 0; i < gp_indices.length; ++i) {
            list.add(this.getNodeView(gp_indices[i]));
        }
        return list;
    }

    public Iterator getNodeViewsIterator() {
        return this.getNodeViewsList().iterator();
    }

    public int getNodeViewCount() {
        return this.perspective.getNodeCount();
    }

    public int getEdgeViewCount() {
        return this.perspective.getEdgeCount();
    }

    public NodeView getNodeView(Node node) {
        return this.getNodeView(node.getRootGraphIndex());
    }

    public NodeView getNodeView(int index) {
        if (index > 0) {
            return (NodeView)this.nodeViewMap.get(this.perspective.getRootGraphNodeIndex(index));
        }
        return (NodeView)this.nodeViewMap.get(index);
    }

    public List getEdgeViewsList() {
        ArrayList<EdgeView> list = new ArrayList<EdgeView>(this.getEdgeViewCount());
        int[] gp_indices = this.perspective.getEdgeIndicesArray();
        for (int i = 0; i < gp_indices.length; ++i) {
            list.add(this.getEdgeView(gp_indices[i]));
        }
        return list;
    }

    public List getEdgeViewsList(Node oneNode, Node otherNode) {
        List edges = this.perspective.edgesList(oneNode.getRootGraphIndex(), otherNode.getRootGraphIndex(), true);
        if (edges == null || edges.size() == 0) {
            return null;
        }
        Iterator it = edges.iterator();
        ArrayList<EdgeView> edgeViews = new ArrayList<EdgeView>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            edgeViews.add(this.getEdgeView(e));
        }
        if (edgeViews.size() > 0) {
            return edgeViews;
        }
        return null;
    }

    public List getEdgeViewsList(int from_node_index, int to_node_index, boolean include_undirected_edges) {
        List edges_list = this.perspective.edgesList(from_node_index, to_node_index, include_undirected_edges);
        ArrayList<EdgeView> view_list = new ArrayList<EdgeView>();
        Iterator edges_iterator = edges_list.iterator();
        while (edges_iterator.hasNext()) {
            int[] edge_array = (int[])edges_iterator.next();
            view_list.add(this.getEdgeView(edge_array[0]));
        }
        return view_list;
    }

    public EdgeView getEdgeView(int edge_index) {
        if (edge_index > 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
            return (EdgeView)this.edgeViewMap.get(edge_index);
        }
        return (EdgeView)this.edgeViewMap.get(edge_index);
    }

    public Iterator getEdgeViewsIterator() {
        return this.getEdgeViewsList().iterator();
    }

    public EdgeView getEdgeView(Edge edge) {
        return (EdgeView)this.edgeViewMap.get(edge.getRootGraphIndex());
    }

    public int edgeCount() {
        return this.perspective.getEdgeCount();
    }

    public int nodeCount() {
        return this.perspective.getNodeCount();
    }

    public boolean hideNodeView(NodeView nv) {
        return this.hideNodeView(nv, true);
    }

    public boolean hideNodeView(NodeView nv, boolean hide_adjacent_edges) {
        ChangeEvent event = this.getChangeEvent();
        event.reset();
        this.hideGraphObject(nv);
        event.addHiddenNodeIndex(nv.getRootGraphIndex());
        if (hide_adjacent_edges) {
            int[] na = this.getGraphPerspective().neighborsArray(nv.getGraphPerspectiveIndex());
            for (int i = 0; i < na.length; ++i) {
                int[] edges = this.getGraphPerspective().getEdgeIndicesArray(nv.getGraphPerspectiveIndex(), na[i], true, true);
                if (edges == null) continue;
                for (int j = 0; j < edges.length; ++j) {
                    this.hideGraphObject(this.getEdgeView(edges[j]));
                    event.addHiddenEdgeIndex(edges[j]);
                }
            }
        }
        if (event != null) {
            this.fireGraphViewChanged(event);
        }
        return true;
    }

    public boolean hideEdgeView(EdgeView ev) {
        ChangeEvent event = this.getChangeEvent();
        event.reset();
        event.addHiddenEdgeIndex(ev.getRootGraphIndex());
        if (event != null) {
            this.fireGraphViewChanged(event);
        }
        return this.hideGraphObject(ev);
    }

    public boolean showNodeView(NodeView nv) {
        return this.showNodeView(nv, true);
    }

    public boolean showNodeView(NodeView nv, boolean show_adjacent_edges) {
        if (!this.getGraphPerspective().containsNode(nv.getNode())) {
            return false;
        }
        this.showGraphObject(nv);
        if (show_adjacent_edges) {
            int[] na = this.getGraphPerspective().neighborsArray(nv.getGraphPerspectiveIndex());
            for (int i = 0; i < na.length; ++i) {
                int[] edges = this.getGraphPerspective().getEdgeIndicesArray(nv.getGraphPerspectiveIndex(), na[i], true, true);
                if (edges == null) continue;
                for (int j = 0; j < edges.length; ++j) {
                    this.showGraphObject(this.getEdgeView(edges[j]));
                }
            }
        }
        return true;
    }

    public boolean showEdgeView(EdgeView ev) {
        if (!this.getGraphPerspective().containsEdge(ev.getEdge())) {
            return false;
        }
        return this.showGraphObject(ev);
    }

    public boolean hideGraphObject(Object object) {
        PNode obj = (PNode)object;
        try {
            ((PNode)object).removeFromParent();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean showGraphObject(Object object) {
        if (object == null) {
            return false;
        }
        PNode obj = (PNode)object;
        try {
            if (obj.getParent() != null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (object instanceof NodeView) {
            this.nodeLayer.addChild((PNode)object);
            return true;
        }
        if (object instanceof EdgeView) {
            this.edgeLayer.addChild((PNode)object);
            return true;
        }
        return false;
    }

    public boolean hideGraphObjects(List objects) {
        Iterator pnodes = objects.iterator();
        while (pnodes.hasNext()) {
            this.hideGraphObject((PNode)pnodes.next());
        }
        return true;
    }

    public boolean showGraphObjects(List objects) {
        Iterator pnodes = objects.iterator();
        while (pnodes.hasNext()) {
            this.showGraphObject((PNode)pnodes.next());
        }
        return true;
    }

    public Object[] getContextMethods(String class_name, boolean plus_superclass) {
        if (class_name.startsWith("class ")) {
            class_name = class_name.substring(6, class_name.length());
        }
        if (plus_superclass) {
            try {
                return this.getContextMethods(class_name, null);
            }
            catch (Exception ex) {
                System.out.println("Exception encounterd getting methods");
                ex.printStackTrace();
                return null;
            }
        }
        return (Object[])this.contextMenuStore.get(class_name);
    }

    public Object[] getContextMethods(String class_name, Object[] methods) {
        if (class_name.startsWith("class ")) {
            class_name = class_name.substring(6, class_name.length());
        }
        try {
            Class<?> c = Class.forName(class_name);
            if (methods == null) {
                methods = (Object[])this.contextMenuStore.get(class_name);
            } else {
                Object[] new_methods = (Object[])this.contextMenuStore.get(class_name);
                if (new_methods != null) {
                    Object[] return_methods = new Object[new_methods.length + methods.length];
                    System.arraycopy(methods, 0, return_methods, 0, methods.length);
                    System.arraycopy(new_methods, 0, return_methods, methods.length, new_methods.length);
                    methods = return_methods;
                }
            }
            Class<?> sc = c.getSuperclass();
            if (!sc.getName().equals("java.lang.Object")) {
                return this.getContextMethods(sc.getName(), methods);
            }
            return methods;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return methods;
        }
    }

    public boolean addContextMethod(String class_name, String method_class_name, String method_name, Object[] args, ClassLoader loader) {
        Object[] new_store;
        Object old_store;
        if (class_name.startsWith("class ")) {
            class_name = class_name.substring(6, class_name.length());
        }
        if ((old_store = this.contextMenuStore.get(class_name)) == null) {
            new_store = new Object[]{new Object[]{method_class_name, method_name, args, loader}};
        } else {
            Object[] store = (Object[])old_store;
            new_store = new Object[store.length + 1];
            System.arraycopy(store, 0, new_store, 0, store.length);
            new_store[store.length] = new Object[]{method_class_name, method_name, args, loader};
        }
        this.contextMenuStore.put(class_name, new_store);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ChangeEvent
    extends GraphViewChangeEvent {
        protected int type;
        protected int[] restoredNodeIndices;
        protected int[] restoredEdgeIndices;
        protected int[] hiddenNodeIndices;
        protected int[] hiddenEdgeIndices;
        protected int[] selectedNodeIndices;
        protected int[] unselectedNodeIndices;
        protected int[] selectedEdgeIndices;
        protected int[] unselectedEdgeIndices;
        protected Node[] restoredNodes;
        protected Edge[] restoredEdges;
        protected Node[] hiddenNodes;
        protected Edge[] hiddenEdges;
        protected Node[] selectedNodes;
        protected Node[] unselectedNodes;
        protected Edge[] selectedEdges;
        protected Edge[] unselectedEdges;

        ChangeEvent() {
            super(PGraphView.this);
            this.reset();
        }

        public void reset() {
            this.type = 0;
            this.restoredNodeIndices = null;
            this.restoredEdgeIndices = null;
            this.hiddenNodeIndices = null;
            this.hiddenEdgeIndices = null;
            this.restoredNodes = null;
            this.restoredEdges = null;
            this.hiddenNodes = null;
            this.hiddenEdges = null;
        }

        public int getType() {
            return this.type;
        }

        public boolean isNodesRestoredType() {
            return (this.type & 1) != 0;
        }

        public boolean isEdgesRestoredType() {
            return (this.type & 2) != 0;
        }

        public boolean isNodesHiddenType() {
            return (this.type & 4) != 0;
        }

        public boolean isEdgesHiddenType() {
            return (this.type & 8) != 0;
        }

        public boolean isNodesSelectedType() {
            return (this.type & 0x10) != 0;
        }

        public boolean isNodesUnselectedType() {
            return (this.type & 0x20) != 0;
        }

        public boolean isEdgesSelectedType() {
            return (this.type & 0x40) != 0;
        }

        public boolean isEdgesUnselectedType() {
            return (this.type & 0x80) != 0;
        }

        public Node[] getSelectedNodes() {
            if ((this.type & 0x10) == 0) {
                return null;
            }
            if (this.selectedNodes == null) {
                this.selectedNodes = new Node[this.selectedNodeIndices.length];
                for (int node_i = 0; node_i < this.selectedNodes.length; ++node_i) {
                    this.selectedNodes[node_i] = ((PGraphView)this.source).getGraphPerspective().getNode(this.selectedNodeIndices[node_i]);
                }
            }
            return this.selectedNodes;
        }

        public int[] getSelectedNodeIndices() {
            if ((this.type & 0x10) == 0) {
                return null;
            }
            if (this.selectedNodeIndices == null) {
                this.selectedNodeIndices = new int[this.selectedNodes.length];
                for (int node_i = 0; node_i < this.selectedNodeIndices.length; ++node_i) {
                    this.selectedNodeIndices[node_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.selectedNodes[node_i]);
                }
            }
            return this.selectedNodeIndices;
        }

        public Node[] getUnselectedNodes() {
            if ((this.type & 0x20) == 0) {
                return null;
            }
            if (this.unselectedNodes == null) {
                this.unselectedNodes = new Node[this.unselectedNodeIndices.length];
                for (int node_i = 0; node_i < this.unselectedNodes.length; ++node_i) {
                    this.unselectedNodes[node_i] = ((PGraphView)this.source).getGraphPerspective().getNode(this.unselectedNodeIndices[node_i]);
                }
            }
            return this.unselectedNodes;
        }

        public int[] getUnselectedNodeIndices() {
            if ((this.type & 0x20) == 0) {
                return null;
            }
            if (this.unselectedNodeIndices == null) {
                this.unselectedNodeIndices = new int[this.unselectedNodes.length];
                for (int node_i = 0; node_i < this.unselectedNodeIndices.length; ++node_i) {
                    this.unselectedNodeIndices[node_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.unselectedNodes[node_i]);
                }
            }
            return this.unselectedNodeIndices;
        }

        public Edge[] getSelectedEdges() {
            if ((this.type & 0x40) == 0) {
                return null;
            }
            if (this.selectedEdges == null) {
                this.selectedEdges = new Edge[this.selectedEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.selectedEdges.length; ++edge_i) {
                    this.selectedEdges[edge_i] = ((PGraphView)this.source).getGraphPerspective().getEdge(this.selectedEdgeIndices[edge_i]);
                }
            }
            return this.selectedEdges;
        }

        public int[] getSelectedEdgeIndices() {
            if ((this.type & 0x40) == 0) {
                return null;
            }
            if (this.selectedEdgeIndices == null) {
                this.selectedEdgeIndices = new int[this.selectedEdges.length];
                for (int edge_i = 0; edge_i < this.selectedEdgeIndices.length; ++edge_i) {
                    this.selectedEdgeIndices[edge_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.selectedEdges[edge_i]);
                }
            }
            return this.selectedEdgeIndices;
        }

        public Edge[] getUnselectedEdges() {
            if ((this.type & 0x80) == 0) {
                return null;
            }
            if (this.unselectedEdges == null) {
                this.unselectedEdges = new Edge[this.unselectedEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.unselectedEdges.length; ++edge_i) {
                    this.unselectedEdges[edge_i] = ((PGraphView)this.source).getGraphPerspective().getEdge(this.unselectedEdgeIndices[edge_i]);
                }
            }
            return this.unselectedEdges;
        }

        public int[] getUnselectedEdgeIndices() {
            if ((this.type & 0x80) == 0) {
                return null;
            }
            if (this.unselectedEdgeIndices == null) {
                this.unselectedEdgeIndices = new int[this.unselectedEdges.length];
                for (int edge_i = 0; edge_i < this.unselectedEdgeIndices.length; ++edge_i) {
                    this.unselectedEdgeIndices[edge_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.unselectedEdges[edge_i]);
                }
            }
            return this.unselectedEdgeIndices;
        }

        public Node[] getRestoredNodes() {
            if ((this.type & 1) == 0) {
                return null;
            }
            if (this.restoredNodes == null) {
                this.restoredNodes = new Node[this.restoredNodeIndices.length];
                for (int node_i = 0; node_i < this.restoredNodes.length; ++node_i) {
                    this.restoredNodes[node_i] = ((PGraphView)this.source).getGraphPerspective().getNode(this.restoredNodeIndices[node_i]);
                }
            }
            return this.restoredNodes;
        }

        public Edge[] getRestoredEdges() {
            if ((this.type & 2) == 0) {
                return null;
            }
            if (this.restoredEdges == null) {
                this.restoredEdges = new Edge[this.restoredEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.restoredEdges.length; ++edge_i) {
                    this.restoredEdges[edge_i] = ((PGraphView)this.source).getGraphPerspective().getEdge(this.restoredEdgeIndices[edge_i]);
                }
            }
            return this.restoredEdges;
        }

        public Node[] getHiddenNodes() {
            if ((this.type & 4) == 0) {
                return null;
            }
            if (this.hiddenNodes == null) {
                this.hiddenNodes = new Node[this.hiddenNodeIndices.length];
                for (int node_i = 0; node_i < this.hiddenNodes.length; ++node_i) {
                    this.hiddenNodes[node_i] = ((PGraphView)this.source).getGraphPerspective().getNode(this.hiddenNodeIndices[node_i]);
                }
            }
            return this.hiddenNodes;
        }

        public Edge[] getHiddenEdges() {
            if ((this.type & 8) == 0) {
                return null;
            }
            if (this.hiddenEdges == null) {
                this.hiddenEdges = new Edge[this.hiddenEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.hiddenEdges.length; ++edge_i) {
                    this.hiddenEdges[edge_i] = ((PGraphView)this.source).getGraphPerspective().getEdge(this.hiddenEdgeIndices[edge_i]);
                }
            }
            return this.hiddenEdges;
        }

        public int[] getRestoredNodeIndices() {
            if ((this.type & 1) == 0) {
                return null;
            }
            if (this.restoredNodeIndices == null) {
                this.restoredNodeIndices = new int[this.restoredNodes.length];
                for (int node_i = 0; node_i < this.restoredNodeIndices.length; ++node_i) {
                    this.restoredNodeIndices[node_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.restoredNodes[node_i]);
                }
            }
            return this.restoredNodeIndices;
        }

        public int[] getRestoredEdgeIndices() {
            if ((this.type & 2) == 0) {
                return null;
            }
            if (this.restoredEdgeIndices == null) {
                this.restoredEdgeIndices = new int[this.restoredEdges.length];
                for (int edge_i = 0; edge_i < this.restoredEdgeIndices.length; ++edge_i) {
                    this.restoredEdgeIndices[edge_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.restoredEdges[edge_i]);
                }
            }
            return this.restoredEdgeIndices;
        }

        public int[] getHiddenNodeIndices() {
            if ((this.type & 4) == 0) {
                return null;
            }
            if (this.hiddenNodeIndices == null) {
                this.hiddenNodeIndices = new int[this.hiddenNodes.length];
                for (int node_i = 0; node_i < this.hiddenNodeIndices.length; ++node_i) {
                    this.hiddenNodeIndices[node_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.hiddenNodes[node_i]);
                }
            }
            return this.hiddenNodeIndices;
        }

        public int[] getHiddenEdgeIndices() {
            if ((this.type & 8) == 0) {
                return null;
            }
            if (this.hiddenEdgeIndices == null) {
                this.hiddenEdgeIndices = new int[this.hiddenEdges.length];
                for (int edge_i = 0; edge_i < this.hiddenEdgeIndices.length; ++edge_i) {
                    this.hiddenEdgeIndices[edge_i] = PGraphView.this.getGraphPerspective().getRootGraph().getIndex(this.hiddenEdges[edge_i]);
                }
            }
            return this.hiddenEdgeIndices;
        }

        public void addHiddenNode(Node node) {
            if ((this.type & 4) == 0) {
                this.hiddenNodes = new Node[1];
                this.hiddenNodes[0] = node;
                this.type |= 4;
            } else {
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + 1];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    new_hidden_nodes[this.hiddenNodes.length] = node;
                    this.hiddenNodes = new_hidden_nodes;
                }
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + 1];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    new_hidden_node_indices[this.hiddenNodeIndices.length] = node.getRootGraphIndex();
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
            }
        }

        public void addHiddenNodes(Node[] nodes) {
            if ((this.type & 4) == 0) {
                this.hiddenNodes = nodes;
                this.type |= 4;
            } else {
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + nodes.length];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    System.arraycopy(nodes, 0, new_hidden_nodes, this.hiddenNodes.length, nodes.length);
                    this.hiddenNodes = new_hidden_nodes;
                }
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + nodes.length];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_hidden_node_indices[this.hiddenNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
            }
        }

        public void addHiddenNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 4) == 0) {
                this.hiddenNodeIndices = new int[1];
                this.hiddenNodeIndices[0] = node_index;
                this.type |= 4;
            } else {
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + 1];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    new_hidden_node_indices[this.hiddenNodeIndices.length] = node_index;
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + 1];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    new_hidden_nodes[this.hiddenNodes.length] = PGraphView.this.getGraphPerspective().getRootGraph().getNode(node_index);
                    this.hiddenNodes = new_hidden_nodes;
                }
            }
        }

        public void addHiddenNodeIndices(int[] node_indices) {
            if ((this.type & 4) == 0) {
                this.hiddenNodeIndices = node_indices;
                this.type |= 4;
            } else {
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + node_indices.length];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_hidden_node_indices, this.hiddenNodeIndices.length, node_indices.length);
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + node_indices.length];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_hidden_nodes[this.hiddenNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.hiddenNodes = new_hidden_nodes;
                }
            }
        }

        public void addRestoredNode(Node node) {
            if ((this.type & 1) == 0) {
                this.restoredNodes = new Node[1];
                this.restoredNodes[0] = node;
                this.type |= 1;
            } else {
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + 1];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    new_restored_nodes[this.restoredNodes.length] = node;
                    this.restoredNodes = new_restored_nodes;
                }
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + 1];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    new_restored_node_indices[this.restoredNodeIndices.length] = node.getRootGraphIndex();
                    this.restoredNodeIndices = new_restored_node_indices;
                }
            }
        }

        public void addRestoredNodes(Node[] nodes) {
            if ((this.type & 1) == 0) {
                this.restoredNodes = nodes;
                this.type |= 1;
            } else {
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + nodes.length];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    System.arraycopy(nodes, 0, new_restored_nodes, this.restoredNodes.length, nodes.length);
                    this.restoredNodes = new_restored_nodes;
                }
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + nodes.length];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_restored_node_indices[this.restoredNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.restoredNodeIndices = new_restored_node_indices;
                }
            }
        }

        public void addRestoredNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 1) == 0) {
                this.restoredNodeIndices = new int[1];
                this.restoredNodeIndices[0] = node_index;
                this.type |= 1;
            } else {
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + 1];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    new_restored_node_indices[this.restoredNodeIndices.length] = node_index;
                    this.restoredNodeIndices = new_restored_node_indices;
                }
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + 1];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    new_restored_nodes[this.restoredNodes.length] = PGraphView.this.getGraphPerspective().getRootGraph().getNode(node_index);
                    this.restoredNodes = new_restored_nodes;
                }
            }
        }

        public void addRestoredNodeIndices(int[] node_indices) {
            if ((this.type & 1) == 0) {
                this.restoredNodeIndices = node_indices;
                this.type |= 1;
            } else {
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + node_indices.length];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_restored_node_indices, this.restoredNodeIndices.length, node_indices.length);
                    this.restoredNodeIndices = new_restored_node_indices;
                }
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + node_indices.length];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_restored_nodes[this.restoredNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.restoredNodes = new_restored_nodes;
                }
            }
        }

        public void addHiddenEdge(Edge edge) {
            if ((this.type & 8) == 0) {
                this.hiddenEdges = new Edge[1];
                this.hiddenEdges[0] = edge;
                this.type |= 8;
            } else {
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + 1];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    new_hidden_edges[this.hiddenEdges.length] = edge;
                    this.hiddenEdges = new_hidden_edges;
                }
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + 1];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    new_hidden_edge_indices[this.hiddenEdgeIndices.length] = edge.getRootGraphIndex();
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
            }
        }

        public void addHiddenEdges(Edge[] edges) {
            if ((this.type & 8) == 0) {
                this.hiddenEdges = edges;
                this.type |= 8;
            } else {
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + edges.length];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    System.arraycopy(edges, 0, new_hidden_edges, this.hiddenEdges.length, edges.length);
                    this.hiddenEdges = new_hidden_edges;
                }
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + edges.length];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_hidden_edge_indices[this.hiddenEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
            }
        }

        public void addHiddenEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 8) == 0) {
                this.hiddenEdgeIndices = new int[1];
                this.hiddenEdgeIndices[0] = edge_index;
                this.type |= 8;
            } else {
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + 1];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    new_hidden_edge_indices[this.hiddenEdgeIndices.length] = edge_index;
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + 1];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    new_hidden_edges[this.hiddenEdges.length] = PGraphView.this.getGraphPerspective().getRootGraph().getEdge(edge_index);
                    this.hiddenEdges = new_hidden_edges;
                }
            }
        }

        public void addHiddenEdgeIndices(int[] edge_indices) {
            if ((this.type & 8) == 0) {
                this.hiddenEdgeIndices = edge_indices;
                this.type |= 8;
            } else {
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_hidden_edge_indices, this.hiddenEdgeIndices.length, edge_indices.length);
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + edge_indices.length];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_hidden_edges[this.hiddenEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.hiddenEdges = new_hidden_edges;
                }
            }
        }

        public void addRestoredEdge(Edge edge) {
            if ((this.type & 2) == 0) {
                this.restoredEdges = new Edge[1];
                this.restoredEdges[0] = edge;
                this.type |= 2;
            } else {
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + 1];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    new_restored_edges[this.restoredEdges.length] = edge;
                    this.restoredEdges = new_restored_edges;
                }
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + 1];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    new_restored_edge_indices[this.restoredEdgeIndices.length] = edge.getRootGraphIndex();
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
            }
        }

        public void addRestoredEdges(Edge[] edges) {
            if ((this.type & 2) == 0) {
                this.restoredEdges = edges;
                this.type |= 2;
            } else {
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + edges.length];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    System.arraycopy(edges, 0, new_restored_edges, this.restoredEdges.length, edges.length);
                    this.restoredEdges = new_restored_edges;
                }
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + edges.length];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_restored_edge_indices[this.restoredEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
            }
        }

        public void addRestoredEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 2) == 0) {
                this.restoredEdgeIndices = new int[1];
                this.restoredEdgeIndices[0] = edge_index;
                this.type |= 2;
            } else {
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + 1];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    new_restored_edge_indices[this.restoredEdgeIndices.length] = edge_index;
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + 1];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    new_restored_edges[this.restoredEdges.length] = PGraphView.this.getGraphPerspective().getRootGraph().getEdge(edge_index);
                    this.restoredEdges = new_restored_edges;
                }
            }
        }

        public void addRestoredEdgeIndices(int[] edge_indices) {
            if ((this.type & 2) == 0) {
                this.restoredEdgeIndices = edge_indices;
                this.type |= 2;
            } else {
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_restored_edge_indices, this.restoredEdgeIndices.length, edge_indices.length);
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + edge_indices.length];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_restored_edges[this.restoredEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.restoredEdges = new_restored_edges;
                }
            }
        }

        public void addSelectedNode(Node node) {
            if ((this.type & 0x10) == 0) {
                this.selectedNodes = new Node[1];
                this.selectedNodes[0] = node;
                this.type |= 0x10;
            } else {
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + 1];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    new_selected_nodes[this.selectedNodes.length] = node;
                    this.selectedNodes = new_selected_nodes;
                }
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + 1];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    new_selected_node_indices[this.selectedNodeIndices.length] = node.getRootGraphIndex();
                    this.selectedNodeIndices = new_selected_node_indices;
                }
            }
        }

        public void addSelectedNodes(Node[] nodes) {
            if ((this.type & 0x10) == 0) {
                this.selectedNodes = nodes;
                this.type |= 0x10;
            } else {
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + nodes.length];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    System.arraycopy(nodes, 0, new_selected_nodes, this.selectedNodes.length, nodes.length);
                    this.selectedNodes = new_selected_nodes;
                }
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + nodes.length];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_selected_node_indices[this.selectedNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.selectedNodeIndices = new_selected_node_indices;
                }
            }
        }

        public void addSelectedNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 0x10) == 0) {
                this.selectedNodeIndices = new int[1];
                this.selectedNodeIndices[0] = node_index;
                this.type |= 0x10;
            } else {
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + 1];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    new_selected_node_indices[this.selectedNodeIndices.length] = node_index;
                    this.selectedNodeIndices = new_selected_node_indices;
                }
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + 1];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    new_selected_nodes[this.selectedNodes.length] = PGraphView.this.getGraphPerspective().getRootGraph().getNode(node_index);
                    this.selectedNodes = new_selected_nodes;
                }
            }
        }

        public void addSelectedNodeIndices(int[] node_indices) {
            if ((this.type & 0x10) == 0) {
                this.selectedNodeIndices = node_indices;
                this.type |= 0x10;
            } else {
                this.selectedNodeIndices = node_indices;
            }
        }

        public void addUnselectedNode(Node node) {
            if ((this.type & 0x20) == 0) {
                this.unselectedNodes = new Node[1];
                this.unselectedNodes[0] = node;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + 1];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    new_unselected_nodes[this.unselectedNodes.length] = node;
                    this.unselectedNodes = new_unselected_nodes;
                }
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + 1];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    new_unselected_node_indices[this.unselectedNodeIndices.length] = node.getRootGraphIndex();
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
            }
        }

        public void addUnselectedNodes(Node[] nodes) {
            if ((this.type & 0x20) == 0) {
                this.unselectedNodes = nodes;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + nodes.length];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    System.arraycopy(nodes, 0, new_unselected_nodes, this.unselectedNodes.length, nodes.length);
                    this.unselectedNodes = new_unselected_nodes;
                }
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + nodes.length];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_unselected_node_indices[this.unselectedNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
            }
        }

        public void addUnselectedNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 0x20) == 0) {
                this.unselectedNodeIndices = new int[1];
                this.unselectedNodeIndices[0] = node_index;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + 1];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    new_unselected_node_indices[this.unselectedNodeIndices.length] = node_index;
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + 1];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    new_unselected_nodes[this.unselectedNodes.length] = PGraphView.this.getGraphPerspective().getRootGraph().getNode(node_index);
                    this.unselectedNodes = new_unselected_nodes;
                }
            }
        }

        public void addUnselectedNodeIndices(int[] node_indices) {
            if ((this.type & 0x20) == 0) {
                this.unselectedNodeIndices = node_indices;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + node_indices.length];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_unselected_node_indices, this.unselectedNodeIndices.length, node_indices.length);
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + node_indices.length];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_unselected_nodes[this.unselectedNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.unselectedNodes = new_unselected_nodes;
                }
            }
        }

        public void addSelectedEdge(Edge edge) {
            if ((this.type & 0x40) == 0) {
                this.selectedEdges = new Edge[1];
                this.selectedEdges[0] = edge;
                this.type |= 0x40;
            } else {
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + 1];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    new_selected_edges[this.selectedEdges.length] = edge;
                    this.selectedEdges = new_selected_edges;
                }
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + 1];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    new_selected_edge_indices[this.selectedEdgeIndices.length] = edge.getRootGraphIndex();
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
            }
        }

        public void addSelectedEdges(Edge[] edges) {
            if ((this.type & 0x40) == 0) {
                this.selectedEdges = edges;
                this.type |= 0x40;
            } else {
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + edges.length];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    System.arraycopy(edges, 0, new_selected_edges, this.selectedEdges.length, edges.length);
                    this.selectedEdges = new_selected_edges;
                }
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + edges.length];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_selected_edge_indices[this.selectedEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
            }
        }

        public void addSelectedEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 0x40) == 0) {
                this.selectedEdgeIndices = new int[1];
                this.selectedEdgeIndices[0] = edge_index;
                this.type |= 0x40;
            } else {
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + 1];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    new_selected_edge_indices[this.selectedEdgeIndices.length] = edge_index;
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + 1];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    new_selected_edges[this.selectedEdges.length] = PGraphView.this.getGraphPerspective().getRootGraph().getEdge(edge_index);
                    this.selectedEdges = new_selected_edges;
                }
            }
        }

        public void addSelectedEdgeIndices(int[] edge_indices) {
            if ((this.type & 0x40) == 0) {
                this.selectedEdgeIndices = edge_indices;
                this.type |= 0x40;
            } else {
                this.selectedEdgeIndices = edge_indices;
            }
        }

        public void addUnselectedEdge(Edge edge) {
            if ((this.type & 0x80) == 0) {
                this.unselectedEdges = new Edge[1];
                this.unselectedEdges[0] = edge;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + 1];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    new_unselected_edges[this.unselectedEdges.length] = edge;
                    this.unselectedEdges = new_unselected_edges;
                }
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + 1];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    new_unselected_edge_indices[this.unselectedEdgeIndices.length] = edge.getRootGraphIndex();
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
            }
        }

        public void addUnselectedEdges(Edge[] edges) {
            if ((this.type & 0x80) == 0) {
                this.unselectedEdges = edges;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + edges.length];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    System.arraycopy(edges, 0, new_unselected_edges, this.unselectedEdges.length, edges.length);
                    this.unselectedEdges = new_unselected_edges;
                }
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + edges.length];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_unselected_edge_indices[this.unselectedEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
            }
        }

        public void addUnselectedEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((PGraphView)this.source).getGraphPerspective().getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 0x80) == 0) {
                this.unselectedEdgeIndices = new int[1];
                this.unselectedEdgeIndices[0] = edge_index;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + 1];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    new_unselected_edge_indices[this.unselectedEdgeIndices.length] = edge_index;
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + 1];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    new_unselected_edges[this.unselectedEdges.length] = PGraphView.this.getGraphPerspective().getRootGraph().getEdge(edge_index);
                    this.unselectedEdges = new_unselected_edges;
                }
            }
        }

        public void addUnselectedEdgeIndices(int[] edge_indices) {
            if ((this.type & 0x80) == 0) {
                this.unselectedEdgeIndices = edge_indices;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_unselected_edge_indices, this.unselectedEdgeIndices.length, edge_indices.length);
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + edge_indices.length];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_unselected_edges[this.unselectedEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.unselectedEdges = new_unselected_edges;
                }
            }
        }
    }
}

