/*
 * Decompiled with CFR 0.152.
 */
package phoebe;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import edu.umd.cs.piccolox.util.PNodeLocator;
import giny.model.Edge;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import phoebe.PGraphView;
import phoebe.PNodeView;
import phoebe.event.PEdgeHandler;
import phoebe.util.Bend;
import phoebe.util.PArrowIcon;
import phoebe.util.PCircleIcon;
import phoebe.util.PDeltaIcon;
import phoebe.util.PDiamondIcon;
import phoebe.util.PEdgeEndIcon;
import phoebe.util.PLabel;
import phoebe.util.PNullIcon;
import phoebe.util.PTIcon;

public class PEdgeView
extends PPath
implements EdgeView,
PropertyChangeListener {
    protected int rootGraphIndex;
    protected PGraphView view;
    protected Point2D sourcePoint;
    protected Point2D targetPoint;
    protected Vector handlePointList;
    protected NodeView source;
    protected NodeView target;
    protected PNodeLocator targetLocator;
    protected PNodeLocator sourceLocator;
    protected PEdgeEndIcon sourceEdgeEnd;
    protected PEdgeEndIcon targetEdgeEnd;
    protected boolean selected;
    protected PLabel label;
    protected Point2D[] drawPoints;
    protected Bend bend;
    protected boolean inLargeGraph;
    protected boolean selfEdge = false;

    public PEdgeView(int edge_index, PGraphView view) {
        this(edge_index, view, Float.MAX_VALUE, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, null, null);
    }

    public PEdgeView(Edge edge, PGraphView view) {
        this(edge.getRootGraphIndex(), view, Float.MAX_VALUE, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, null, null);
    }

    public PEdgeView(int edge_index, PGraphView view, float width, int line_type, Paint paint, Paint selection_paint, int source_end, Paint source_end_paint, Paint source_end_selected_paint, int target_end, Paint target_end_paint, Paint target_end_selected_paint) {
        if (view == null) {
            throw new IllegalArgumentException("A PEdgeView must belong to a PGraphView");
        }
        this.view = view;
        if (edge_index == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("A edge_index must be passed to create a PEdgeView");
        }
        this.rootGraphIndex = edge_index >= 0 ? view.getGraphPerspective().getRootGraphEdgeIndex(edge_index) : edge_index;
        if (width != Float.MAX_VALUE) {
            view.setEdgeFloatProperty(this.rootGraphIndex, 2, width);
        }
        if (line_type != Integer.MAX_VALUE) {
            view.setEdgeIntProperty(this.rootGraphIndex, 3, line_type);
        }
        if (paint != null) {
            view.setEdgeObjectProperty(this.rootGraphIndex, 4, paint);
        }
        if (selection_paint != null) {
            view.setEdgeObjectProperty(this.rootGraphIndex, 5, selection_paint);
        }
        if (source_end != Integer.MAX_VALUE) {
            view.setEdgeIntProperty(this.rootGraphIndex, 6, source_end);
        }
        if (source_end_paint != null) {
            view.setEdgeObjectProperty(this.rootGraphIndex, 7, source_end_paint);
        }
        if (source_end_selected_paint != null) {
            view.setEdgeObjectProperty(this.rootGraphIndex, 8, source_end_selected_paint);
        }
        if (target_end != Integer.MAX_VALUE) {
            view.setEdgeIntProperty(this.rootGraphIndex, 9, target_end);
        }
        if (target_end_paint != null) {
            view.setEdgeObjectProperty(this.rootGraphIndex, 10, target_end_paint);
        }
        if (target_end_selected_paint != null) {
            view.setEdgeObjectProperty(this.rootGraphIndex, 11, target_end_selected_paint);
        }
        this.initializeEdgeView();
    }

    protected void initializeEdgeView() {
        this.source = this.view.getNodeView(this.view.getEdgeIntProperty(this.rootGraphIndex, 0));
        this.target = this.view.getNodeView(this.view.getEdgeIntProperty(this.rootGraphIndex, 1));
        this.setStrokePaint((Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 4));
        this.setStroke(new BasicStroke(this.view.getEdgeFloatProperty(this.rootGraphIndex, 2), 1, 1));
        if (this.source == this.target) {
            this.selfEdge = true;
            this.targetLocator = PBoundsLocator.createSouthLocator((PNode)((Object)this.target));
            this.sourceLocator = PBoundsLocator.createSouthLocator((PNode)((Object)this.source));
        } else {
            this.targetLocator = new PNodeLocator((PNode)((Object)this.target));
            this.sourceLocator = new PNodeLocator((PNode)((Object)this.source));
        }
        this.targetPoint = this.targetLocator.locatePoint(this.targetPoint);
        this.sourcePoint = this.sourceLocator.locatePoint(this.sourcePoint);
        this.targetPoint = ((PNode)((Object)this.target)).localToGlobal(this.targetPoint);
        this.sourcePoint = ((PNode)((Object)this.source)).localToGlobal(this.sourcePoint);
        if (this.sourcePoint == this.targetPoint) {
            this.sourcePoint.setLocation(this.sourcePoint.getX(), this.sourcePoint.getY() + 1.0);
        }
        ((PNode)((Object)this.source)).addPropertyChangeListener(this);
        ((PNode)((Object)this.target)).addPropertyChangeListener(this);
        this.view.getEdgeLayer().addPropertyChangeListener(this);
        this.bend = new Bend(this.sourcePoint, this.targetPoint, this);
        this.setSourceEdgeEndType(this.view.getEdgeIntProperty(this.rootGraphIndex, 6));
        this.sourceEdgeEnd.setPaint((Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 7));
        this.setTargetEdgeEndType(this.view.getEdgeIntProperty(this.rootGraphIndex, 9));
        this.targetEdgeEnd.setPaint((Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 10));
        this.sourceEdgeEnd.setStroke(null);
        this.targetEdgeEnd.setStroke(null);
        this.setPickable(true);
        this.drawPoints = this.bend.getDrawPoints();
        this.updateEdgeView();
    }

    public Label getLabel() {
        if (this.label == null) {
            this.label = new PLabel(null, this);
            this.label.updatePosition();
            this.label.setPickable(false);
            this.addChild(this.label);
        }
        return this.label;
    }

    public String toString() {
        if (this.source == null || this.target == null || this.source.getNode() == null || this.target.getNode() == null) {
            return "edge root index = " + this.rootGraphIndex;
        }
        return this.source.getNode().getRootGraphIndex() + "->" + this.target.getNode().getRootGraphIndex() + " (" + this.rootGraphIndex + ")";
    }

    public PEdgeHandler getEdgeHandler() {
        return this.view.getEdgeHandler();
    }

    public void setSourceNode(NodeView node_view) {
        ((PNode)((Object)this.source)).removePropertyChangeListener(this);
        this.source = node_view;
        this.sourceLocator = new PNodeLocator((PNode)((Object)this.source));
        this.sourcePoint = this.sourceLocator.locatePoint(this.sourcePoint);
        this.sourcePoint = ((PNode)((Object)this.source)).localToGlobal(this.sourcePoint);
        ((PNode)((Object)this.source)).addPropertyChangeListener(this);
        this.updateEdgeView();
    }

    public void setTargetNode(NodeView node_view) {
        ((PNode)((Object)this.target)).removePropertyChangeListener(this);
        this.target = node_view;
        this.targetLocator = new PNodeLocator((PNode)((Object)this.target));
        this.targetPoint = this.targetLocator.locatePoint(this.targetPoint);
        this.targetPoint = ((PNode)((Object)this.target)).localToGlobal(this.targetPoint);
        ((PNode)((Object)this.target)).addPropertyChangeListener(this);
        this.updateEdgeView();
    }

    public void updateConnection(int node_index) {
        if (node_index < 0) {
            node_index = this.view.getGraphPerspective().getNodeIndex(node_index);
        }
        if (node_index == this.source.getGraphPerspectiveIndex()) {
            this.setSourceNode(this.view.getNodeView(node_index));
        }
        if (node_index == this.target.getGraphPerspectiveIndex()) {
            this.setTargetNode(this.view.getNodeView(node_index));
        }
    }

    public int getGraphPerspectiveIndex() {
        return this.view.getGraphPerspective().getEdgeIndex(this.rootGraphIndex);
    }

    public int getRootGraphIndex() {
        return this.rootGraphIndex;
    }

    public Edge getEdge() {
        RootGraph rootGraph = this.view.getGraphPerspective().getRootGraph();
        return rootGraph.getEdge(this.rootGraphIndex);
    }

    public GraphView getGraphView() {
        return this.view;
    }

    public giny.view.Bend getBend() {
        return this.bend;
    }

    public void clearBends() {
        this.bend.removeAllHandles();
    }

    public void setStrokeWidth(float width) {
        this.view.setEdgeFloatProperty(this.rootGraphIndex, 2, width);
        this.setStroke(new BasicStroke(width));
    }

    public float getStrokeWidth() {
        return this.view.getEdgeFloatProperty(this.rootGraphIndex, 2);
    }

    public void setLineType(int line_type) {
        this.view.setEdgeIntProperty(this.rootGraphIndex, 3, line_type);
        this.updateEdgeView();
    }

    public int getLineType() {
        return this.view.getEdgeIntProperty(this.rootGraphIndex, 3);
    }

    public void setUnselectedPaint(Paint paint) {
        this.view.setEdgeObjectProperty(this.rootGraphIndex, 4, paint);
        if (!this.selected) {
            super.setStrokePaint(paint);
        }
    }

    public Paint getUnselectedPaint() {
        return (Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 4);
    }

    public void setSelectedPaint(Paint paint) {
        this.view.setEdgeObjectProperty(this.rootGraphIndex, 5, paint);
        if (this.selected) {
            super.setStrokePaint(paint);
        }
    }

    public Paint getSelectedPaint() {
        return (Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 5);
    }

    public Paint getSourceEdgeEndPaint() {
        return (Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 7);
    }

    public Paint getSourceEdgeEndSelectedPaint() {
        return (Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 8);
    }

    public Paint getTargetEdgeEndPaint() {
        return (Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 10);
    }

    public Paint getTargetEdgeEndSelectedPaint() {
        return (Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 11);
    }

    public void setSourceEdgeEndSelectedPaint(Paint paint) {
        this.view.setEdgeObjectProperty(this.rootGraphIndex, 8, paint);
        if (this.selected) {
            this.sourceEdgeEnd.setPaint(paint);
        }
    }

    public void setSourceEdgeEndStrokePaint(Paint paint) {
        this.sourceEdgeEnd.setStrokePaint(paint);
    }

    public void setTargetEdgeEndSelectedPaint(Paint paint) {
        this.view.setEdgeObjectProperty(this.rootGraphIndex, 11, paint);
        if (this.selected) {
            this.targetEdgeEnd.setPaint(paint);
        }
    }

    public void setTargetEdgeEndStrokePaint(Paint paint) {
        this.targetEdgeEnd.setStrokePaint(paint);
    }

    public void setSourceEdgeEndPaint(Paint paint) {
        this.view.setEdgeObjectProperty(this.rootGraphIndex, 7, paint);
        if (!this.selected) {
            this.sourceEdgeEnd.setPaint(paint);
        }
    }

    public void setTargetEdgeEndPaint(Paint paint) {
        this.view.setEdgeObjectProperty(this.rootGraphIndex, 10, paint);
        if (!this.selected) {
            this.targetEdgeEnd.setPaint(paint);
        }
    }

    public void setSourceEdgeEnd(int type) {
        this.setSourceEdgeEndType(type);
        this.updateEdgeView();
    }

    public void setTargetEdgeEnd(int type) {
        this.setTargetEdgeEndType(type);
        this.updateEdgeView();
    }

    public void select() {
        this.setSelected(true);
    }

    public void unselect() {
        this.setSelected(false);
    }

    public boolean setSelected(boolean state) {
        if (state != this.selected) {
            this.selected = state;
            if (this.selected) {
                this.drawSelected();
                this.view.edgeSelected(this);
            } else {
                this.drawUnselected();
                this.view.edgeUnselected(this);
            }
            this.updateEdgeView();
        }
        return state;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void updateEdgeView() {
        this.targetPoint = this.targetLocator.locatePoint(this.targetPoint);
        this.sourcePoint = this.sourceLocator.locatePoint(this.sourcePoint);
        this.targetPoint = ((PNode)((Object)this.target)).localToGlobal(this.targetPoint);
        this.sourcePoint = ((PNode)((Object)this.source)).localToGlobal(this.sourcePoint);
        if (this.selfEdge) {
            float width = (float)((PNode)((Object)this.target)).getWidth();
            float height = (float)((PNode)((Object)this.target)).getHeight();
            this.setPathToEllipse((float)(this.sourcePoint.getX() - 0.25 * (double)width), (float)(this.sourcePoint.getY() - 0.25 * (double)height), width * 0.5f, height * 0.5f);
            return;
        }
        this.updateTargetPointView();
        this.updateSourcePointView();
        int[] same_edges = this.view.getGraphPerspective().getEdgeIndicesArray(this.source.getRootGraphIndex(), this.target.getRootGraphIndex(), true, true);
        if (same_edges.length != 1) {
            for (int i = 0; i < same_edges.length; ++i) {
                double theta;
                double O;
                int num;
                double A;
                double y;
                double x;
                boolean foo;
                double b;
                double a;
                if (same_edges[i] != this.getGraphPerspectiveIndex() || same_edges.length % 2 == 1 && i == 0) continue;
                if (same_edges.length % 2 == 0) {
                    a = (this.sourcePoint.getX() + this.targetPoint.getX()) / 2.0;
                    b = (this.sourcePoint.getY() + this.targetPoint.getY()) / 2.0;
                    if (this.source.getGraphPerspectiveIndex() > this.target.getGraphPerspectiveIndex()) {
                        foo = true;
                        x = this.sourcePoint.getX();
                        y = this.sourcePoint.getY();
                    } else {
                        foo = false;
                        x = this.targetPoint.getX();
                        y = this.targetPoint.getY();
                    }
                    A = Math.sqrt((x - a) * (x - a) + (y - b) * (y - b));
                    num = i / 2;
                    O = i % 2 == 0 ? (double)(10 * (num + 1)) : (double)(-10 * (num + 1));
                    theta = Math.atan(O / A);
                    if (foo) {
                        if (a < this.sourcePoint.getX()) {
                            theta += Math.PI;
                        }
                    } else if (x < this.targetPoint.getX()) {
                        theta += Math.PI;
                    }
                    this.bend.moveHandle(0, new Point2D.Double(a += O * Math.cos(theta), b += O * Math.sin(theta)));
                    continue;
                }
                if (same_edges.length % 2 != 1) continue;
                a = (this.sourcePoint.getX() + this.targetPoint.getX()) / 2.0;
                b = (this.sourcePoint.getY() + this.targetPoint.getY()) / 2.0;
                if (this.source.getGraphPerspectiveIndex() > this.target.getGraphPerspectiveIndex()) {
                    foo = true;
                    x = this.sourcePoint.getX();
                    y = this.sourcePoint.getY();
                } else {
                    foo = false;
                    x = this.targetPoint.getX();
                    y = this.targetPoint.getY();
                }
                A = Math.sqrt((x - a) * (x - a) + (y - b) * (y - b));
                num = i / 2;
                O = i % 2 == 1 ? (double)(10 * (num + 1)) : (double)(-10 * (num + 1));
                theta = Math.atan(O / A);
                double length = Math.sqrt(A * A + O * O);
                if (foo) {
                    if (a < this.sourcePoint.getX()) {
                        theta += Math.PI;
                    }
                } else if (x < this.targetPoint.getX()) {
                    theta += Math.PI;
                }
                this.bend.moveHandle(0, new Point2D.Double(a += O * Math.cos(theta), b += O * Math.sin(theta)));
            }
        }
        if (!this.inLargeGraph) {
            this.updateTargetArrow();
            this.updateSourceArrow();
        }
        this.updateLine();
    }

    public void updateTargetArrow() {
        this.targetEdgeEnd.drawIcon(this.bend.getTargetHandlePoint(), this.targetPoint);
        this.targetPoint.setLocation(this.targetEdgeEnd.getNewX(), this.targetEdgeEnd.getNewY());
    }

    public void updateSourceArrow() {
        this.sourceEdgeEnd.drawIcon(this.bend.getSourceHandlePoint(), this.sourcePoint);
        this.sourcePoint.setLocation(this.sourceEdgeEnd.getNewX(), this.sourceEdgeEnd.getNewY());
    }

    public void setThisEdgeEnd(PNodeView view, int type) {
        if (view == this.source) {
            this.setSourceEdgeEnd(type);
        } else if (view == this.target) {
            this.setTargetEdgeEnd(type);
        } else {
            this.setTargetEdgeEnd(type);
            this.setSourceEdgeEnd(type);
        }
    }

    public int getSourceEdgeEnd() {
        return this.view.getEdgeIntProperty(this.rootGraphIndex, 6);
    }

    public int getTargetEdgeEnd() {
        return this.view.getEdgeIntProperty(this.rootGraphIndex, 9);
    }

    protected void setSourceEdgeEndType(int type) {
        if (this.sourceEdgeEnd != null) {
            this.removeChild(this.sourceEdgeEnd);
        }
        this.sourceEdgeEnd = null;
        this.view.setEdgeIntProperty(this.rootGraphIndex, 6, type);
        switch (type) {
            case 0: {
                this.sourceEdgeEnd = new PNullIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                break;
            }
            case 1: {
                this.sourceEdgeEnd = new PDeltaIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 8.0);
                this.sourceEdgeEnd.setPaint(Color.white);
                break;
            }
            case 2: {
                this.sourceEdgeEnd = new PDeltaIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 8.0);
                this.sourceEdgeEnd.setPaint(Color.black);
                break;
            }
            case 3: {
                this.sourceEdgeEnd = new PDeltaIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 8.0);
                this.sourceEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 4: {
                this.sourceEdgeEnd = new PArrowIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 8.0);
                this.sourceEdgeEnd.setPaint(Color.white);
                break;
            }
            case 5: {
                this.sourceEdgeEnd = new PArrowIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 8.0);
                this.sourceEdgeEnd.setPaint(Color.black);
                break;
            }
            case 6: {
                this.sourceEdgeEnd = new PArrowIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 8.0);
                this.sourceEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 7: {
                this.sourceEdgeEnd = new PDiamondIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(Color.white);
                break;
            }
            case 8: {
                this.sourceEdgeEnd = new PDiamondIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(Color.black);
                break;
            }
            case 9: {
                this.sourceEdgeEnd = new PDiamondIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 10: {
                this.sourceEdgeEnd = new PCircleIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(Color.white);
                break;
            }
            case 11: {
                this.sourceEdgeEnd = new PCircleIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(Color.black);
                break;
            }
            case 12: {
                this.sourceEdgeEnd = new PCircleIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 13: {
                this.sourceEdgeEnd = new PTIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(Color.white);
                break;
            }
            case 14: {
                this.sourceEdgeEnd = new PTIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(Color.black);
                break;
            }
            case 15: {
                this.sourceEdgeEnd = new PTIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                this.sourceEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            default: {
                this.sourceEdgeEnd = new PNullIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
            }
        }
        this.addChild(this.sourceEdgeEnd);
        this.sourcePoint.setLocation(this.sourceEdgeEnd.getNewX(), this.sourceEdgeEnd.getNewY());
    }

    protected void setTargetEdgeEndType(int type) {
        if (this.targetEdgeEnd != null) {
            this.removeChild(this.targetEdgeEnd);
        }
        this.targetEdgeEnd = null;
        this.view.setEdgeIntProperty(this.rootGraphIndex, 9, type);
        switch (type) {
            case 0: {
                this.targetEdgeEnd = new PNullIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
                break;
            }
            case 1: {
                this.targetEdgeEnd = new PDeltaIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 8.0);
                this.targetEdgeEnd.setPaint(Color.white);
                break;
            }
            case 2: {
                this.targetEdgeEnd = new PDeltaIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 8.0);
                this.targetEdgeEnd.setPaint(Color.black);
                break;
            }
            case 3: {
                this.targetEdgeEnd = new PDeltaIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 8.0);
                this.targetEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 4: {
                this.targetEdgeEnd = new PArrowIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 8.0);
                this.targetEdgeEnd.setPaint(Color.white);
                break;
            }
            case 5: {
                this.targetEdgeEnd = new PArrowIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 8.0);
                this.targetEdgeEnd.setPaint(Color.black);
                break;
            }
            case 6: {
                this.targetEdgeEnd = new PArrowIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 8.0);
                this.targetEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 7: {
                this.targetEdgeEnd = new PDiamondIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(Color.white);
                break;
            }
            case 8: {
                this.targetEdgeEnd = new PDiamondIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(Color.black);
                break;
            }
            case 9: {
                this.targetEdgeEnd = new PDiamondIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 10: {
                this.targetEdgeEnd = new PCircleIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(Color.white);
                break;
            }
            case 11: {
                this.targetEdgeEnd = new PCircleIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(Color.black);
                break;
            }
            case 12: {
                this.targetEdgeEnd = new PCircleIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            case 13: {
                this.targetEdgeEnd = new PTIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(Color.white);
                break;
            }
            case 14: {
                this.targetEdgeEnd = new PTIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(Color.black);
                break;
            }
            case 15: {
                this.targetEdgeEnd = new PTIcon(this.bend.getTargetHandlePoint(), this.sourcePoint, 10.0);
                this.targetEdgeEnd.setPaint(this.getUnselectedPaint());
                break;
            }
            default: {
                this.targetEdgeEnd = new PNullIcon(this.bend.getSourceHandlePoint(), this.targetPoint, 10.0);
            }
        }
        this.addChild(this.targetEdgeEnd);
        this.targetPoint.setLocation(this.targetEdgeEnd.getNewX(), this.targetEdgeEnd.getNewY());
    }

    protected void updateTargetPointView() {
        if (!this.inLargeGraph) {
            if (this.view.getNodeIntProperty(this.view.getGraphPerspective().getEdgeTargetIndex(this.rootGraphIndex), 2) == 2) {
                Point2D tempPoint = this.bend.getTargetHandlePoint();
                double O = this.targetPoint.getY() - tempPoint.getY();
                double A = this.targetPoint.getX() - tempPoint.getX();
                double theta = Math.atan(O / A);
                double width = ((PNode)((Object)this.target)).getWidth() / 2.0;
                double height = ((PNode)((Object)this.target)).getHeight() / 2.0;
                if (tempPoint.getX() < this.targetPoint.getX()) {
                    theta += Math.PI;
                }
                this.targetPoint.setLocation(width * Math.cos(theta) + this.targetPoint.getX(), height * Math.sin(theta) + this.targetPoint.getY());
            } else {
                PathIterator target_iterator = ((PPath)((Object)this.target)).getPathReference().getPathIterator(((PNode)((Object)this.target)).getLocalToGlobalTransform(new PAffineTransform()));
                Point2D tempPoint = this.bend.getTargetHandlePoint();
                double edge_slope = (this.targetPoint.getY() - tempPoint.getY()) / (this.targetPoint.getX() - tempPoint.getX());
                double edge_b = this.targetPoint.getY() - edge_slope * this.targetPoint.getX();
                double[] current_seg = new double[6];
                double closest_distance = Double.MAX_VALUE;
                double closest_Y = 0.0;
                double closest_X = 0.0;
                target_iterator.currentSegment(current_seg);
                double last_X = current_seg[0];
                double last_Y = current_seg[1];
                target_iterator.next();
                while (!target_iterator.isDone()) {
                    double intersection_Y;
                    double intersection_X;
                    target_iterator.currentSegment(current_seg);
                    if (current_seg[0] == last_X) {
                        intersection_X = last_X;
                        intersection_Y = edge_slope * intersection_X + edge_b;
                    } else {
                        double current_slope = (current_seg[1] - last_Y) / (current_seg[0] - last_X);
                        double current_b = current_seg[1] - current_slope * current_seg[0];
                        intersection_X = (edge_b - current_b) / (current_slope - edge_slope);
                        intersection_Y = current_slope * intersection_X + current_b;
                    }
                    if (intersection_X < Math.min(current_seg[0], last_X) || intersection_X > Math.max(current_seg[0], last_X) || intersection_Y < Math.min(current_seg[1], last_Y) || intersection_Y > Math.max(current_seg[1], last_Y)) {
                        last_X = current_seg[0];
                        last_Y = current_seg[1];
                        target_iterator.next();
                        continue;
                    }
                    double current_distance = Math.sqrt((intersection_X - tempPoint.getX()) * (intersection_X - tempPoint.getX()) + (intersection_Y - tempPoint.getY()) * (intersection_Y - tempPoint.getY()));
                    if (current_distance < closest_distance) {
                        closest_X = intersection_X;
                        closest_Y = intersection_Y;
                        closest_distance = current_distance;
                    }
                    last_X = current_seg[0];
                    last_Y = current_seg[1];
                    target_iterator.next();
                }
                if (closest_distance != Double.MAX_VALUE) {
                    this.targetPoint.setLocation(closest_X, closest_Y);
                }
            }
        } else {
            this.targetPoint = this.targetLocator.locatePoint(this.targetPoint);
            this.drawPoints[1] = this.targetPoint = ((PNode)((Object)this.target)).localToGlobal(this.targetPoint);
        }
    }

    protected void updateSourcePointView() {
        if (!this.inLargeGraph) {
            if (this.view.getNodeIntProperty(this.view.getGraphPerspective().getEdgeSourceIndex(this.rootGraphIndex), 2) == 2) {
                Point2D tempPoint = this.bend.getSourceHandlePoint();
                double O = this.sourcePoint.getY() - tempPoint.getY();
                double A = this.sourcePoint.getX() - tempPoint.getX();
                double theta = Math.atan(O / A);
                double width = ((PNode)((Object)this.source)).getWidth() / 2.0;
                double height = ((PNode)((Object)this.source)).getHeight() / 2.0;
                if (tempPoint.getX() < this.sourcePoint.getX()) {
                    theta += Math.PI;
                }
                this.sourcePoint.setLocation(width * Math.cos(theta) + this.sourcePoint.getX(), height * Math.sin(theta) + this.sourcePoint.getY());
            } else {
                PathIterator source_iterator = ((PPath)((Object)this.source)).getPathReference().getPathIterator(((PNode)((Object)this.source)).getLocalToGlobalTransform(new PAffineTransform()));
                Point2D tempPoint = this.bend.getSourceHandlePoint();
                double edge_slope = (this.sourcePoint.getY() - tempPoint.getY()) / (this.sourcePoint.getX() - tempPoint.getX());
                double edge_b = this.sourcePoint.getY() - edge_slope * this.sourcePoint.getX();
                double[] current_seg = new double[6];
                double closest_distance = Double.MAX_VALUE;
                double closest_Y = 0.0;
                double closest_X = 0.0;
                source_iterator.currentSegment(current_seg);
                double last_X = current_seg[0];
                double last_Y = current_seg[1];
                source_iterator.next();
                while (!source_iterator.isDone()) {
                    double intersection_Y;
                    double intersection_X;
                    source_iterator.currentSegment(current_seg);
                    if (current_seg[0] == last_X) {
                        intersection_X = last_X;
                        intersection_Y = edge_slope * intersection_X + edge_b;
                    } else {
                        double current_slope = (current_seg[1] - last_Y) / (current_seg[0] - last_X);
                        double current_b = current_seg[1] - current_slope * current_seg[0];
                        intersection_X = (edge_b - current_b) / (current_slope - edge_slope);
                        intersection_Y = current_slope * intersection_X + current_b;
                    }
                    if (intersection_X < Math.min(current_seg[0], last_X) || intersection_X > Math.max(current_seg[0], last_X) || intersection_Y < Math.min(current_seg[1], last_Y) || intersection_Y > Math.max(current_seg[1], last_Y)) {
                        last_X = current_seg[0];
                        last_Y = current_seg[1];
                        source_iterator.next();
                        continue;
                    }
                    double current_distance = Math.sqrt((intersection_X - tempPoint.getX()) * (intersection_X - tempPoint.getX()) + (intersection_Y - tempPoint.getY()) * (intersection_Y - tempPoint.getY()));
                    if (current_distance < closest_distance) {
                        closest_X = intersection_X;
                        closest_Y = intersection_Y;
                        closest_distance = current_distance;
                    }
                    last_X = current_seg[0];
                    last_Y = current_seg[1];
                    source_iterator.next();
                }
                if (closest_distance != Double.MAX_VALUE) {
                    this.sourcePoint.setLocation(closest_X, closest_Y);
                }
            }
        } else {
            this.sourcePoint = this.sourceLocator.locatePoint(this.sourcePoint);
            this.sourcePoint = ((PNode)((Object)this.source)).localToGlobal(this.sourcePoint);
        }
    }

    public void updateLine() {
        if (!this.inLargeGraph) {
            this.drawPoints = this.bend.getDrawPoints();
        }
        this.setPathToPolyline(this.drawPoints);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Offset")) {
            if (((NodeView)evt.getNewValue()).getGraphPerspectiveIndex() == this.target.getGraphPerspectiveIndex()) {
                this.updateEdgeView();
            } else if (((NodeView)evt.getNewValue()).getGraphPerspectiveIndex() == this.source.getGraphPerspectiveIndex()) {
                this.updateEdgeView();
            }
        } else if (evt.getPropertyName().equals("BoundsChanged")) {
            if (((NodeView)evt.getNewValue()).getGraphPerspectiveIndex() == this.target.getGraphPerspectiveIndex()) {
                this.updateEdgeView();
            } else if (((NodeView)evt.getNewValue()).getGraphPerspectiveIndex() == this.source.getGraphPerspectiveIndex()) {
                this.updateEdgeView();
            }
        } else if (evt.getPropertyName() == "transform") {
            this.updateEdgeView();
        }
    }

    public boolean intersects(Point2D pt) {
        double rectSize = 20.0;
        for (int i = 0; i < this.drawPoints.length - 1; ++i) {
            Line2D.Double l = new Line2D.Double(this.drawPoints[i], this.drawPoints[i + 1]);
            Rectangle2D.Double rect = new Rectangle2D.Double(pt.getX() - rectSize / 2.0, pt.getY() - rectSize / 2.0, rectSize, rectSize);
            if (!l.intersects(rect)) continue;
            return true;
        }
        return false;
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
    }

    public void drawSelected() {
        this.bend.drawSelected();
        this.setPaint(null);
        super.setStrokePaint((Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 5));
    }

    public void drawUnselected() {
        this.bend.drawUnselected();
        this.setPaint(null);
        super.setStrokePaint((Paint)this.view.getEdgeObjectProperty(this.rootGraphIndex, 4));
    }

    public void setToolTip(String tip) {
        this.addClientProperty("tooltip", tip);
    }
}

