/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.graphicsio.swf.SWFActionSet;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFDictionary;
import org.freehep.graphicsio.swf.SWFHeader;
import org.freehep.graphicsio.swf.SWFSpriteTagSet;
import org.freehep.graphicsio.swf.SWFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedInputStream;

public class SWFInputStream
extends TaggedInputStream
implements SWFConstants {
    private SWFDictionary dictionary = new SWFDictionary();
    private byte[] jpegTable;
    private SWFHeader header;

    public SWFInputStream(InputStream is) throws IOException {
        this(is, 6);
    }

    public SWFInputStream(InputStream is, int version) throws IOException {
        this(is, new SWFTagSet(version), new SWFActionSet(version));
    }

    public SWFInputStream(InputStream is, SWFSpriteTagSet tagSet, SWFActionSet actionSet) throws IOException {
        super(is, tagSet, actionSet, true);
    }

    public float readFixed() throws IOException {
        this.byteAlign();
        int frac = this.readUnsignedByte();
        int whole = this.readUnsignedByte();
        return (float)(whole |= this.readUnsignedByte() << 8) + (float)(frac |= this.readUnsignedByte() << 8) / 65536.0f;
    }

    public Rectangle2D readRect() throws IOException {
        this.byteAlign();
        int nbits = (int)this.readUBits(5);
        int xmin = (int)this.readSBits(nbits);
        int xmax = (int)this.readSBits(nbits);
        int ymin = (int)this.readSBits(nbits);
        int ymax = (int)this.readSBits(nbits);
        return new Rectangle2D.Double(xmin / 20, ymin / 20, (xmax - xmin) / 20, (ymax - ymin) / 20);
    }

    public Color readColor(boolean alpha) throws IOException {
        int r = this.readUnsignedByte();
        int g = this.readUnsignedByte();
        int b = this.readUnsignedByte();
        int a = alpha ? this.readUnsignedByte() : 255;
        return new Color(r, g, b, a);
    }

    public AffineTransform readMatrix() throws IOException {
        int nbits;
        this.byteAlign();
        float sx = 1.0f;
        float sy = 1.0f;
        float kx = 0.0f;
        float ky = 0.0f;
        float tx = 0.0f;
        float ty = 0.0f;
        if (this.readBitFlag()) {
            nbits = (int)this.readUBits(5);
            sx = this.readFBits(nbits);
            sy = this.readFBits(nbits);
        }
        if (this.readBitFlag()) {
            nbits = (int)this.readUBits(5);
            kx = this.readFBits(nbits);
            ky = this.readFBits(nbits);
        }
        nbits = (int)this.readUBits(5);
        tx = (float)this.readSBits(nbits) / 20.0f;
        ty = (float)this.readSBits(nbits) / 20.0f;
        return new AffineTransform(sx, ky, kx, sy, tx, ty);
    }

    public String readString() throws IOException {
        if (this.getVersion() >= 6) {
            String s = this.readUTF();
            this.readByte();
            return s;
        }
        return this.readAsciiZString();
    }

    public int readLanguageCode() throws IOException {
        return this.readUnsignedByte();
    }

    protected TagHeader readTagHeader() throws IOException {
        this.byteAlign();
        int temp = this.read();
        if (temp == -1) {
            return null;
        }
        int tagID = (temp |= this.readUnsignedByte() << 8) >> 6;
        long length = temp & FIELD_MASK[5];
        if (length == 63L) {
            length = this.readUnsignedInt();
        }
        return new TagHeader(tagID, length);
    }

    protected ActionHeader readActionHeader() throws IOException {
        int actionCode = this.readUnsignedByte();
        if (actionCode == 0) {
            return null;
        }
        int length = 0;
        if ((actionCode & 0x80) > 0) {
            length = this.readUnsignedShort();
        }
        return new ActionHeader(actionCode, length);
    }

    public SWFHeader readHeader() throws IOException {
        if (this.header == null) {
            this.header = new SWFHeader(this);
        }
        return this.header;
    }

    public SWFDictionary getDictionary() {
        return this.dictionary;
    }

    public void setJPEGTable(byte[] table) {
        this.jpegTable = table;
    }

    public byte[] getJPEGTable() {
        return this.jpegTable;
    }

    public int getVersion() {
        return ((SWFSpriteTagSet)this.tagSet).getVersion();
    }
}

