/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.pluginmanager.PluginDownload;
import org.freehep.application.studio.pluginmanager.PluginInfoPanel;
import org.freehep.application.studio.pluginmanager.PluginInstallDialog;
import org.freehep.application.studio.pluginmanager.PluginManager;

class PluginManagerDialog
extends JDialog
implements ActionListener {
    private DefaultMutableTreeNode loadedtree;
    private JButton install;
    private JButton remove;
    private JButton update;
    private JOptionPane updatepane;
    private JTree tree;
    private List installablePlugins;
    private List updatablePlugins;
    private Map updateMap;
    private PluginInfoPanel info;
    private PluginManager manager;
    private Studio app;

    PluginManagerDialog(Studio studio, PluginManager manager) {
        this.app = studio;
        this.manager = manager;
        JPanel c = new JPanel(new BorderLayout());
        c.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.setRootVisible(false);
        this.tree.setVisibleRowCount(8);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        JScrollPane treescroll = new JScrollPane(this.tree);
        panel.add(treescroll);
        this.info = new PluginInfoPanel(){
            private JLabel updateLabel;

            void addExtraInfo(Object c1, Object c2) {
                this.add((Component)new JLabel("Latest Version:"), c1);
                this.updateLabel = new JLabel();
                this.add((Component)this.updateLabel, c2);
            }

            void setExtraInfo(PluginInfo info) {
                PluginInfo update;
                String label = null;
                if (PluginManagerDialog.this.updateMap != null && (update = (PluginInfo)PluginManagerDialog.this.updateMap.get(info)) != null) {
                    label = update.getVersion();
                }
                this.updateLabel.setText(label);
            }
        };
        this.info.setBorder(BorderFactory.createTitledBorder("Plugin Info"));
        panel.add(this.info);
        JPanel buttons = new JPanel();
        this.remove = new JButton("Remove selected plugins");
        this.remove.addActionListener(this);
        this.remove.setActionCommand("remove");
        buttons.add(this.remove);
        this.update = new JButton("Update installed plugins");
        this.update.addActionListener(this);
        this.update.setActionCommand("update");
        buttons.add(this.update);
        this.install = new JButton("Install a plugin");
        this.install.addActionListener(this);
        this.install.setActionCommand("install");
        buttons.add(this.install);
        this.remove.setEnabled(false);
        this.install.setEnabled(false);
        this.update.setEnabled(false);
        c.add("South", buttons);
        c.add("Center", panel);
        this.setContentPane(c);
        this.updateTree();
        List available = manager.getAvailablePlugins();
        if (available != null) {
            this.processAvailablePlugins(available);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.install) {
            PluginInstallDialog dlg = new PluginInstallDialog(this.app, this);
            dlg.pack();
            dlg.show();
        } else if (source == this.update) {
            HashMap downloads = new HashMap();
            String base = this.app.getUserExtensionsDir();
            Iterator i = this.updatablePlugins.iterator();
            while (i.hasNext()) {
                PluginInfo info = (PluginInfo)i.next();
                Map files = info.getFiles();
                Iterator iter = files.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    File key = new File(base, entry.getKey().toString());
                    downloads.put(key, entry.getValue());
                }
            }
            PluginDownload download = new PluginDownload(downloads);
            Thread t = new Thread(download);
            t.start();
            JOptionPane.showMessageDialog(this, download, "Downloading...", -1);
            Throwable status2 = download.getStatus();
            System.out.println("Done! status=" + status2);
            if (status2 != null) {
                JOptionPane.showMessageDialog(this, "Download failed: " + status2, "Download error", 0);
                download.cleanUp();
            } else {
                download.commit();
                JOptionPane.showMessageDialog(this, "You must restart JAS for these changed to take effect");
            }
        }
    }

    public void onCancel() {
        this.dispose();
    }

    public void onOK() {
        this.dispose();
    }

    protected void updateTree() {
        int i;
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot, true);
        List loadedplugins = this.app.getPlugins();
        this.loadedtree = new DefaultMutableTreeNode("Loaded Plugins", true);
        treeModel.insertNodeInto(this.loadedtree, treeRoot, 0);
        DefaultMutableTreeNode node = null;
        if (loadedplugins != null) {
            for (i = 0; i < loadedplugins.size(); ++i) {
                node = new DefaultMutableTreeNode(loadedplugins.get(i), false);
                treeModel.insertNodeInto(node, this.loadedtree, 0);
            }
        }
        treeRoot.insert(this.loadedtree, 0);
        this.tree.setModel(treeModel);
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.remove.setEnabled(false);
    }

    List getInstallablePlugins() {
        return this.installablePlugins;
    }

    void processAvailablePlugins(List available) {
        PluginInfo info;
        HashMap<String, PluginInfo> loadedMap = new HashMap<String, PluginInfo>();
        List loadedplugins = this.app.getPlugins();
        Iterator i = loadedplugins.iterator();
        while (i.hasNext()) {
            info = (PluginInfo)i.next();
            loadedMap.put(info.getName(), info);
        }
        this.installablePlugins = new ArrayList();
        this.updatablePlugins = new ArrayList();
        this.updateMap = new HashMap();
        i = available.iterator();
        while (i.hasNext()) {
            info = (PluginInfo)i.next();
            PluginInfo old = (PluginInfo)loadedMap.get(info.getName());
            if (old != null) {
                this.updateMap.put(old, info);
                if (Studio.versionNumberCompare(info.getVersion(), old.getVersion()) <= 0) continue;
                this.updatablePlugins.add(info);
                continue;
            }
            this.installablePlugins.add(info);
        }
        this.install.setEnabled(!this.installablePlugins.isEmpty());
        this.update.setEnabled(!this.updatablePlugins.isEmpty());
    }

    private void removePlugins() throws IOException {
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        public void valueChanged(TreeSelectionEvent evt) {
            TreePath selection = evt.getPath();
            DefaultMutableTreeNode node = selection == null ? null : (DefaultMutableTreeNode)selection.getLastPathComponent();
            if (node != null && node.isLeaf() && node.getUserObject() instanceof PluginInfo) {
                PluginInfo plugprops = (PluginInfo)node.getUserObject();
                PluginManagerDialog.this.info.setPlugin(plugprops);
            } else {
                PluginManagerDialog.this.info.setPlugin(null);
            }
            node = null;
            TreePath[] checkselection = PluginManagerDialog.this.tree.getSelectionPaths();
            if (checkselection != null) {
                for (int i = 0; i < checkselection.length; ++i) {
                    node = (DefaultMutableTreeNode)checkselection[i].getLastPathComponent();
                    if (node.getUserObject() instanceof PluginInfo) {
                        PluginManagerDialog.this.remove.setEnabled(true);
                        break;
                    }
                    if (node != PluginManagerDialog.this.loadedtree) continue;
                    PluginManagerDialog.this.remove.setEnabled(false);
                }
            }
        }
    }

    class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object info;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (info = ((DefaultMutableTreeNode)value).getUserObject()) instanceof PluginInfo) {
                PluginInfo update;
                PluginInfo plugleaf = (PluginInfo)info;
                String label = plugleaf.getName();
                if (PluginManagerDialog.this.updateMap != null && (update = (PluginInfo)PluginManagerDialog.this.updateMap.get(info)) != null) {
                    PluginManagerDialog.this.app;
                    if (Studio.versionNumberCompare(update.getVersion(), plugleaf.getVersion()) > 0) {
                        label = label + " (update available)";
                    }
                }
                this.setText(label);
            }
            this.setIcon(null);
            return this;
        }
    }
}

