/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.services.jnlp;

import java.awt.datatransfer.Transferable;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.Application;
import org.freehep.application.services.FileAccess;
import org.freehep.application.services.ServiceManager;
import org.freehep.application.services.jnlp.JNLPFileAccess;
import org.freehep.application.services.jnlp.ProgressDialog;

public class JNLPServiceManager
implements ServiceManager {
    private FileOpenService fileOpenService;
    private FileSaveService fileSaveService;
    private PrintService printService;
    private BasicService basicService;
    private PersistenceService persistenceService;
    private DownloadService downloadService;
    private ClipboardService clipboardService;
    private Application app = Application.getApplication();

    private Object createService(String serviceName) {
        try {
            return javax.jnlp.ServiceManager.lookup(serviceName);
        }
        catch (UnavailableServiceException x) {
            throw new RuntimeException("Could not find " + serviceName);
        }
    }

    private PrintService createPrintService() {
        return (PrintService)this.createService("javax.jnlp.PrintService");
    }

    private BasicService createBasicService() {
        return (BasicService)this.createService("javax.jnlp.BasicService");
    }

    private FileSaveService createFileSaveService() {
        return (FileSaveService)this.createService("javax.jnlp.FileSaveService");
    }

    private FileOpenService createFileOpenService() {
        return (FileOpenService)this.createService("javax.jnlp.FileOpenService");
    }

    private PersistenceService createPersistenceService() {
        return (PersistenceService)this.createService("javax.jnlp.PersistenceService");
    }

    private DownloadService createDownloadService() {
        return (DownloadService)this.createService("javax.jnlp.DownloadService");
    }

    private ClipboardService createClipboardService() {
        return (ClipboardService)this.createService("javax.jnlp.ClipboardService");
    }

    public PageFormat getDefaultPage() {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.getDefaultPage();
    }

    public boolean print(Pageable document) {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.print(document);
    }

    public boolean print(Printable painter) {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.print(painter);
    }

    public PageFormat showPageFormatDialog(PageFormat page) {
        if (this.printService == null) {
            this.printService = this.createPrintService();
        }
        return this.printService.showPageFormatDialog(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserPreferences(Properties props) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.persistenceService == null) {
            this.persistenceService = this.createPersistenceService();
        }
        try {
            URL codebase = this.basicService.getCodeBase();
            URL fileURL = new URL(codebase, this.app.getAppName());
            FileContents file = this.persistenceService.get(fileURL);
            BufferedInputStream in = new BufferedInputStream(file.getInputStream());
            try {
                props.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeUserPreferences(Properties props) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.persistenceService == null) {
            this.persistenceService = this.createPersistenceService();
        }
        try {
            BufferedOutputStream out;
            URL codebase = this.basicService.getCodeBase();
            URL fileURL = new URL(codebase, this.app.getAppName());
            try {
                FileContents file = this.persistenceService.get(fileURL);
                out = new BufferedOutputStream(file.getOutputStream(true));
            }
            catch (FileNotFoundException x) {
                long size = this.persistenceService.create(fileURL, 10000L);
                FileContents file = this.persistenceService.get(fileURL);
                out = new BufferedOutputStream(file.getOutputStream(false));
            }
            try {
                props.store(out, this.app.getAppName() + " User Properties");
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FileAccess openFileDialog(FileFilter[] filters, FileFilter defaultFilter, String key) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.fileOpenService == null) {
            this.fileOpenService = this.createFileOpenService();
        }
        try {
            FileContents fc = this.fileOpenService.openFileDialog(null, null);
            if (fc == null) {
                return null;
            }
            return new JNLPFileAccess(fc);
        }
        catch (IOException x) {
            return null;
        }
    }

    public FileAccess saveFileAsDialog(FileFilter[] filters, FileFilter defaultFilter, String key, InputStream in) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.fileSaveService == null) {
            this.fileSaveService = this.createFileSaveService();
        }
        try {
            FileContents fc = this.fileSaveService.saveFileDialog(null, new String[]{"gif"}, in, "xxx.gif");
            if (fc == null) {
                return null;
            }
            return new JNLPFileAccess(fc);
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public boolean isAvailable(String part) {
        if (this.basicService == null) {
            this.basicService = this.createBasicService();
        }
        if (this.downloadService == null) {
            this.downloadService = this.createDownloadService();
        }
        return this.downloadService.isPartCached(part);
    }

    public boolean makeAvailable(String part) {
        return this.makeAvailable(part, "Loading " + part);
    }

    public boolean makeAvailable(final String part, String message) {
        if (this.isAvailable(part)) {
            return true;
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                final ProgressDialog progress = new ProgressDialog(message);
                final JDialog dlg = progress.createDialog(Application.getApplication(), "Downloading...");
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            JNLPServiceManager.this.downloadService.loadPart(part, (DownloadServiceListener)progress);
                        }
                        catch (IOException x) {
                            progress.setFailed();
                        }
                        finally {
                            dlg.dispose();
                        }
                    }
                };
                t.start();
                dlg.show();
                return progress.isDone();
            }
            this.downloadService.loadPart(part, this.downloadService.getDefaultProgressWindow());
            return true;
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
    }

    public Transferable getClipboardContents() {
        if (this.clipboardService == null) {
            this.clipboardService = this.createClipboardService();
        }
        return this.clipboardService.getContents();
    }

    public void setClipboardContents(Transferable contents) {
        if (this.clipboardService == null) {
            this.clipboardService = this.createClipboardService();
        }
        this.clipboardService.setContents(contents);
    }
}

