/*
 * Decompiled with CFR 0.152.
 */
package luna.test;

import cern.colt.list.IntArrayList;
import giny.model.GraphPerspective;
import giny.model.RootGraph;
import giny.util.IntNodeDistances;
import giny.util.NodeDistances;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import luna.LunaRootGraph;

public class LunaTest
extends TestCase {
    RootGraph rootGraph;
    int NUM_NODES = 500;
    static /* synthetic */ Class class$luna$test$LunaTest;

    public LunaTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.rootGraph = new LunaRootGraph();
    }

    public void tearDown() throws Exception {
    }

    public void testCreateNodes() throws Exception {
        int[] node_indices = this.rootGraph.createNodes(this.NUM_NODES);
        int root_nodes = this.rootGraph.getNodeCount();
        for (int num_nodes = 0; num_nodes < root_nodes; ++num_nodes) {
            LunaTest.assertTrue(this.rootGraph.getDegree(node_indices[num_nodes]) == 0);
        }
        IntArrayList from_nodes = new IntArrayList();
        IntArrayList to_nodes = new IntArrayList();
        int edge_i = 0;
        for (int from_node_i = 0; from_node_i < this.NUM_NODES; ++from_node_i) {
            for (int to_node_i = 0; to_node_i < this.NUM_NODES; ++to_node_i) {
                if (from_node_i == to_node_i || !(Math.random() < 0.2)) continue;
                System.out.println("Creating edge between: " + node_indices[from_node_i] + " and " + node_indices[to_node_i]);
                from_nodes.add(node_indices[from_node_i]);
                to_nodes.add(node_indices[to_node_i]);
                ++edge_i;
            }
        }
        from_nodes.trimToSize();
        to_nodes.trimToSize();
        System.err.println("There are: " + this.NUM_NODES + " nodes, and: " + from_nodes.size() + " edges. ");
        int[] directed_edge_indices = this.rootGraph.createEdges(from_nodes.elements(), to_nodes.elements(), true);
        GraphPerspective graph_perspective = this.rootGraph.createGraphPerspective(this.rootGraph.getNodeIndicesArray(), this.rootGraph.getEdgeIndicesArray());
        NodeDistances nd = new NodeDistances(graph_perspective.nodesList(), null, graph_perspective);
        IntNodeDistances ind = new IntNodeDistances(graph_perspective.getNodeIndicesArray(), null, graph_perspective);
        long time = System.currentTimeMillis();
        int[][] dist = nd.calculate();
        System.out.print("J:");
        for (int j = 0; j < dist[0].length; ++j) {
            System.out.print(" " + j + "\t| ");
        }
        System.out.println("");
        for (int i = 0; i < dist.length; ++i) {
            System.out.print("I: " + i + " ");
            for (int j = 0; j < dist[i].length; ++j) {
                System.out.print(" | " + dist[i][j]);
            }
            System.out.println(" |");
        }
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(class$luna$test$LunaTest == null ? (class$luna$test$LunaTest = LunaTest.class$("luna.test.LunaTest")) : class$luna$test$LunaTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

