/*
 * Decompiled with CFR 0.152.
 */
package luna;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import coltginy.ColtRootGraph;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import luna.LunaEdge;
import luna.LunaNode;

public class LunaRootGraph
extends ColtRootGraph {
    protected OpenIntObjectHashMap nodeIndexObjectMap;
    protected OpenIntObjectHashMap edgeIndexObjectMap;

    public LunaRootGraph() {
        this(25, 25);
    }

    public LunaRootGraph(int node_capacity, int edge_capacity) {
        this.nodeIndexObjectMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(node_capacity));
        this.edgeIndexObjectMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(edge_capacity));
        this.initializeColtRootGraph(node_capacity, edge_capacity);
    }

    protected Node createNode(int node_index) {
        if (this.nodeIndexObjectMap.containsKey(node_index)) {
            return (Node)this.nodeIndexObjectMap.get(node_index);
        }
        LunaNode node = new LunaNode(node_index, this);
        this.nodeIndexObjectMap.put(node_index, node);
        return node;
    }

    protected Edge createEdge(int edge_index) {
        if (this.edgeIndexObjectMap.containsKey(edge_index)) {
            return (Edge)this.edgeIndexObjectMap.get(edge_index);
        }
        LunaEdge edge = new LunaEdge(edge_index, this);
        this.edgeIndexObjectMap.put(edge_index, edge);
        return edge;
    }

    public int createNode(GraphPerspective perspective) {
        int[] node_indices_array = null;
        int[] edge_indices_array = null;
        if (perspective != null) {
            if (perspective.getRootGraph() != this) {
                throw new IllegalArgumentException("The given GraphPerspective is a perspective on a different RootGraph: " + perspective.getRootGraph() + ".");
            }
            node_indices_array = perspective.getNodeIndicesArray();
            edge_indices_array = perspective.getEdgeIndicesArray();
        }
        int new_node = this.createNode(node_indices_array, edge_indices_array);
        Node luna_node = this.createNode(new_node);
        ((LunaNode)luna_node).setGraphPerspective(perspective);
        return new_node;
    }
}

