/*
 * Decompiled with CFR 0.152.
 */
package luna;

import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;

public class LunaNode
implements Node {
    protected int rootGraphIndex;
    protected RootGraph rootGraph;
    protected String identifier;
    protected GraphPerspective perspective;

    public LunaNode(int root_graph_index, RootGraph root_graph) {
        this.rootGraphIndex = root_graph_index;
        this.rootGraph = root_graph;
    }

    public LunaNode(int root_graph_index, RootGraph root_graph, GraphPerspective perspective) {
        this.rootGraphIndex = root_graph_index;
        this.rootGraph = root_graph;
        this.perspective = perspective;
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            return new Integer(this.rootGraphIndex).toString();
        }
        return this.identifier;
    }

    public boolean setIdentifier(String new_id) {
        this.identifier = new_id;
        return true;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public GraphPerspective getGraphPerspective() {
        if (this.perspective != null) {
            this.perspective.restoreNodes(this.rootGraph.getNodeMetaChildIndicesArray(this.rootGraphIndex));
            this.perspective.restoreEdges(this.rootGraph.getEdgeMetaChildIndicesArray(this.rootGraphIndex));
        } else {
            this.perspective = this.rootGraph.createGraphPerspective(this.rootGraph.getNodeMetaChildIndicesArray(this.rootGraphIndex), this.rootGraph.getEdgeMetaChildIndicesArray(this.rootGraphIndex));
        }
        return this.perspective;
    }

    public RootGraph getRootGraph() {
        return this.rootGraph;
    }

    public int getRootGraphIndex() {
        return this.rootGraphIndex;
    }

    public boolean setGraphPerspective(GraphPerspective gp) {
        int i;
        this.perspective = gp;
        int[] nodes = this.perspective.getNodeIndicesArray();
        int[] edges = this.perspective.getEdgeIndicesArray();
        for (i = 0; i < nodes.length; ++i) {
            this.rootGraph.addNodeMetaChild(this.rootGraphIndex, nodes[i]);
        }
        for (i = 0; i < edges.length; ++i) {
            this.rootGraph.addEdgeMetaChild(this.rootGraphIndex, edges[i]);
        }
        return true;
    }
}

