/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class TieredInputReader {
    private GraphView view = null;
    private HashMap fNodeNameMap = null;

    public TieredInputReader(GraphView view) {
        this.view = view;
        this.fNodeNameMap = new HashMap();
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nv = (NodeView)i.next();
            this.fNodeNameMap.put(nv.getNode().getIdentifier(), nv.getNode());
        }
    }

    public ArrayList readGraphFromInteractionsFile(String filename) {
        ArrayList list = new ArrayList();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = null;
            StringTokenizer tokenizer = null;
            String nodeName = null;
            int currentTier = 0;
            ArrayList<Node> insertList = new ArrayList<Node>();
            while (reader.ready()) {
                line = reader.readLine();
                tokenizer = new StringTokenizer(line);
                nodeName = tokenizer.nextToken();
                int tier = Integer.parseInt(tokenizer.nextToken());
                System.err.println("nodeName = " + nodeName + "; tier = " + tier);
                System.err.println("currentTier = " + currentTier);
                if (tier > currentTier) {
                    list.add(insertList);
                    insertList = new ArrayList();
                    insertList.add(this.getNode(nodeName));
                    ++currentTier;
                    continue;
                }
                if (tier != currentTier) continue;
                insertList.add(this.getNode(nodeName));
            }
            list.add(insertList);
        }
        catch (IOException e) {
            System.err.println("Problem reading tier file");
            e.printStackTrace();
        }
        return list;
    }

    private Node getNode(String nodeName) {
        Node retVal = (Node)this.fNodeNameMap.get(nodeName);
        if (retVal == null) {
            System.err.println("looked up a bad node in TieredInputReader");
        }
        return retVal;
    }
}

