/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import giny.model.Node;
import giny.view.Bend;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;

public class Sugiyama {
    GraphView graphView;
    List nodeLevels;
    boolean vertical;

    public Sugiyama(GraphView view) {
        this.graphView = view;
        this.vertical = false;
    }

    public void setNodeLevels(List levels) {
        this.nodeLevels = levels;
    }

    public void layout(List levels, boolean vertical) {
        if (levels != null) {
            Iterator outer = levels.iterator();
            int i = 0;
            int j = 0;
            while (outer.hasNext()) {
                List list = (List)outer.next();
                Iterator inner = list.iterator();
                j = 0;
                while (inner.hasNext()) {
                    Node node = (Node)inner.next();
                    System.err.println("In list #" + i + ", inner Node #" + j + " is named: " + node.getIdentifier());
                    ++j;
                }
                ++i;
            }
            this.nodeLevels = levels;
            this.vertical = vertical;
            this.layout();
        } else {
            System.err.println("In Sugiyama, list of list of nodes == null");
        }
    }

    public void layout() {
        Iterator level_iterator = this.nodeLevels.iterator();
        double major = 0.0;
        int numLevels = this.nodeLevels.size();
        for (int i = 0; i < numLevels; ++i) {
            List nextTier;
            List thisTier;
            if (i == numLevels - 1) {
                thisTier = (List)this.nodeLevels.get(i);
                nextTier = null;
            } else {
                thisTier = (List)this.nodeLevels.get(i);
                nextTier = (List)this.nodeLevels.get(i + 1);
            }
            System.err.println("tier = " + i);
            this.layoutLevel(thisTier, nextTier, major);
            major += 200.0;
        }
        level_iterator = this.nodeLevels.iterator();
        while (level_iterator.hasNext()) {
            this.layoutBends((List)level_iterator.next());
        }
    }

    public void layoutBends(List nodes) {
        Iterator member_iterator = nodes.iterator();
        while (member_iterator.hasNext()) {
            Node from = (Node)member_iterator.next();
            Iterator neighbors = this.graphView.getGraphPerspective().neighborsList(from).iterator();
            while (neighbors.hasNext()) {
                Node to = (Node)neighbors.next();
                if (nodes.contains(to)) continue;
                NodeView from_view = this.graphView.getNodeView(from.getRootGraphIndex());
                NodeView to_view = this.graphView.getNodeView(to.getRootGraphIndex());
                double from_x = from_view.getXPosition();
                double from_y = from_view.getYPosition();
                double to_x = to_view.getXPosition();
                double to_y = to_view.getYPosition();
                double from_width = from_view.getWidth();
                double from_height = from_view.getHeight();
                double to_width = to_view.getWidth();
                double to_height = to_view.getHeight();
                double mid_x = Math.abs(from_x + to_x) / 2.0;
                double mid_y = Math.abs(from_y + to_y) / 2.0;
                int[] edges_array = this.graphView.getGraphPerspective().getEdgeIndicesArray(from.getRootGraphIndex(), to.getRootGraphIndex(), false);
                if (edges_array == null) continue;
                for (int i = 0; i < edges_array.length; ++i) {
                    Point2D.Double to_point;
                    Point2D.Double from_point;
                    EdgeView edge_view = this.graphView.getEdgeView(edges_array[i]);
                    Bend bend = edge_view.getBend();
                    edge_view.setLineType(2);
                    if (!this.vertical) {
                        if (to_y > from_y) {
                            from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                            to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                        } else {
                            from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                            to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                        }
                    } else if (to_x > from_x) {
                        from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                        to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                    } else {
                        from_point = new Point2D.Double(mid_x + from_x + from_width / 2.0, mid_y + from_height / 2.0);
                        to_point = new Point2D.Double(mid_x + to_width / 2.0, mid_y + to_height / 2.0);
                    }
                    if (bend == null) continue;
                    bend.addHandle(0, to_point);
                }
            }
        }
    }

    public void layoutLevel(List nodes, List children, double major) {
        Iterator member_iterator = nodes.iterator();
        double minor = 0.0;
        double loop = 1.0;
        List edgeList = null;
        double prevWidth = 0.0;
        int compWidth = this.graphView.getComponent().getWidth();
        System.err.println("compWidth = " + compWidth);
        if (children != null) {
            System.err.println("children != null");
            boolean allHaveChildren = true;
            int numChildlessNodes = 0;
            while (member_iterator.hasNext()) {
                Node thisNode = (Node)member_iterator.next();
                System.err.println("currently checking Node " + thisNode.getIdentifier() + " for children");
                Iterator childIterator = children.iterator();
                boolean hasChild = false;
                while (childIterator.hasNext()) {
                    Node child = (Node)childIterator.next();
                    System.err.println("\tchecking node " + child.getIdentifier());
                    if (!this.graphView.getGraphPerspective().getRootGraph().isNeighbor(thisNode, child)) continue;
                    System.err.println("\t" + thisNode.getIdentifier() + " is " + child.getIdentifier() + "'s parent");
                    hasChild = true;
                }
                if (hasChild) continue;
                allHaveChildren = false;
                ++numChildlessNodes;
            }
            if (allHaveChildren) {
                System.err.println("allHaveChildren == true");
                int numChildren = children.size();
                member_iterator = nodes.iterator();
                while (member_iterator.hasNext()) {
                    Iterator childrenIterator = children.iterator();
                    Node parent = (Node)member_iterator.next();
                    int childCount = 0;
                    while (childrenIterator.hasNext()) {
                        Node child = (Node)childrenIterator.next();
                        edgeList = this.graphView.getEdgeViewsList(parent, child);
                        if (edgeList == null) continue;
                        ++childCount;
                    }
                    System.err.println("Node " + parent.getIdentifier() + " has " + childCount + " children");
                    double widthFactor = (double)childCount / (double)numChildren;
                    double nodeSpaceWidth = widthFactor * (double)compWidth;
                    double midpoint = nodeSpaceWidth / 2.0;
                    minor = prevWidth + midpoint;
                    System.err.println("widthFactor = " + widthFactor + "\tnodeSpaceWidth = " + nodeSpaceWidth);
                    System.err.println("midpoint = " + midpoint + "\tminor = " + minor);
                    NodeView node_view = this.graphView.getNodeView(parent.getRootGraphIndex());
                    if (!this.vertical) {
                        node_view.setOffset(major, minor);
                    } else {
                        double nodeWidth = node_view.getWidth();
                        node_view.setOffset(minor - nodeWidth / 2.0, major);
                    }
                    System.err.println("new prevWidth = " + (prevWidth += nodeSpaceWidth));
                    System.err.println("--------------------------------");
                }
            } else {
                System.err.println("allHaveChildren == false");
                Iterator iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    Node parent = (Node)iterator.next();
                    int numChildren = children.size();
                    double numNodes = (double)numChildlessNodes + (double)numChildren;
                    double widthFactor = 1.0 / numNodes;
                    System.err.println("***there are " + children.size() + " children, and " + numChildlessNodes + " childless nodes");
                    System.err.println("***numNodes = " + numNodes);
                    double nodeSpaceWidth = widthFactor * (double)compWidth;
                    double midpoint = nodeSpaceWidth / 2.0;
                    minor = prevWidth + midpoint;
                    System.err.println("widthFactor = " + widthFactor + "\tnodeSpaceWidth = " + nodeSpaceWidth);
                    System.err.println("midpoint = " + midpoint + "\tminor = " + minor);
                    NodeView node_view = this.graphView.getNodeView(parent.getRootGraphIndex());
                    if (!this.vertical) {
                        node_view.setOffset(major, minor);
                    } else {
                        double nodeWidth = node_view.getWidth();
                        node_view.setOffset(minor - nodeWidth / 2.0, major);
                    }
                    System.err.println("new prevWidth = " + (prevWidth += nodeSpaceWidth));
                    System.err.println("--------------------------------");
                }
            }
        } else {
            System.err.println("Children == null");
            int numNodes = nodes.size();
            while (member_iterator.hasNext()) {
                Node n = (Node)member_iterator.next();
                System.out.println("TEST: " + n.getRootGraphIndex());
                NodeView node_view = this.graphView.getNodeView(n.getRootGraphIndex());
                minor = loop / (double)(numNodes + 1) * (double)compWidth;
                System.err.println("numNodes = " + numNodes + "\twidth = " + compWidth + "\tminor = " + minor);
                if (!this.vertical) {
                    node_view.setOffset(major, minor);
                } else {
                    node_view.setOffset(minor, major);
                }
                loop += 1.0;
            }
        }
    }
}

