/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import giny.util.AbstractLayout;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Iterator;

public class JUNGSpringLayout
extends AbstractLayout {
    private LengthFunction lengthFunction;
    public static int RANGE = 100;
    private double FORCE_CONSTANT = 0.3333333333333333;
    private OpenIntObjectHashMap nodeIndexToDataMap;
    private OpenIntObjectHashMap edgeIndexToDataMap;
    double increment;
    double NUM_INCRMENTS = 100.0;
    long relaxTime = 0L;
    public static int STRETCH = 70;
    public static final LengthFunction UNITLENGTHFUNCTION = new UnitLengthFunction(30);

    public JUNGSpringLayout(GraphView g) {
        this(g, UNITLENGTHFUNCTION);
    }

    public JUNGSpringLayout(GraphView g, LengthFunction f) {
        super(g);
        this.lengthFunction = f;
        this.nodeIndexToDataMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(this.graphView.getNodeViewCount()));
        this.edgeIndexToDataMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(this.graphView.getEdgeViewCount()));
    }

    public void doLayout() {
        this.initialize(null);
        while (!this.incrementsAreDone()) {
            this.advancePositions();
            System.out.println(this.increment + " " + this.getStatus());
        }
        Iterator nodes = this.graphView.getNodeViewsIterator();
        while (nodes.hasNext()) {
            ((NodeView)nodes.next()).setNodePosition(true);
        }
    }

    protected void initialize_local() {
        this.increment = 0.0;
        Iterator iter = this.graphView.getEdgeViewsIterator();
        while (iter.hasNext()) {
            EdgeView e = (EdgeView)iter.next();
            SpringEdgeData sed = this.getSpringData(e);
            if (sed == null) {
                sed = new SpringEdgeData(e);
                this.edgeIndexToDataMap.put(e.getGraphPerspectiveIndex(), sed);
            }
            this.calcEdgeLength(sed, this.lengthFunction);
        }
    }

    protected void initialize_local_node_view(NodeView v) {
        SpringVertexData vud = this.getSpringData(v);
        if (vud == null) {
            vud = new SpringVertexData();
            this.nodeIndexToDataMap.put(v.getGraphPerspectiveIndex(), vud);
        }
    }

    protected void calcEdgeLength(SpringEdgeData sed, LengthFunction f) {
        sed.length = f.getLength(sed.e);
    }

    public void advancePositions() {
        this.increment += 1.0;
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            NodeView v = (NodeView)iter.next();
            SpringVertexData svd = this.getSpringData(v);
            if (svd == null) {
                System.out.println("How confusing!");
                continue;
            }
            svd.dx /= 4.0;
            svd.dy /= 4.0;
            svd.edgedy = 0.0;
            svd.edgedx = 0.0;
            svd.repulsiondy = 0.0;
            svd.repulsiondx = 0.0;
        }
        this.relaxEdges();
        this.calculateRepulsion();
        this.moveNodes();
    }

    private void relaxEdges() {
        Iterator i = this.graphView.getEdgeViewsIterator();
        while (i.hasNext()) {
            EdgeView e = (EdgeView)i.next();
            int source_index = this.graphView.getGraphPerspective().getEdgeSourceIndex(e.getGraphPerspectiveIndex());
            int target_index = this.graphView.getGraphPerspective().getEdgeTargetIndex(e.getGraphPerspectiveIndex());
            double source_x = this.graphView.getNodeDoubleProperty(source_index, 0);
            double source_y = this.graphView.getNodeDoubleProperty(source_index, 1);
            double target_x = this.graphView.getNodeDoubleProperty(target_index, 0);
            double target_y = this.graphView.getNodeDoubleProperty(target_index, 1);
            double vx = source_x - target_x;
            double vy = source_y - target_y;
            double len = Math.sqrt(vx * vx + vy * vy);
            double desiredLen = this.getLength(e);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = this.FORCE_CONSTANT * (desiredLen - len) / len;
            double dx = (f *= Math.pow((double)STRETCH / 100.0, this.graphView.getGraphPerspective().getDegree(source_index) + this.graphView.getGraphPerspective().getDegree(target_index) - 2)) * vx;
            double dy = f * vy;
            SpringVertexData v1D = this.getSpringData(source_index);
            SpringVertexData v2D = this.getSpringData(target_index);
            SpringEdgeData sed = this.getSpringData(e);
            sed.f = f;
            v1D.edgedx += dx;
            v1D.edgedy += dy;
            v2D.edgedx += -dx;
            v2D.edgedy += -dy;
        }
    }

    private void calculateRepulsion() {
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            NodeView v = (NodeView)iter.next();
            if (this.dontMove(v)) continue;
            SpringVertexData svd = this.getSpringData(v);
            double dx = 0.0;
            double dy = 0.0;
            Iterator iter2 = this.graphView.getNodeViewsIterator();
            while (iter2.hasNext()) {
                double v2_y;
                double vy;
                NodeView v2 = (NodeView)iter2.next();
                if (v == v2) continue;
                double v_x = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0);
                double v_y = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1);
                double v2_x = this.graphView.getNodeDoubleProperty(v2.getGraphPerspectiveIndex(), 0);
                double vx = v_x - v2_x;
                double distance = vx * vx + (vy = v_y - (v2_y = this.graphView.getNodeDoubleProperty(v2.getGraphPerspectiveIndex(), 1))) * vy;
                if (distance == 0.0) {
                    dx += Math.random();
                    dy += Math.random();
                    continue;
                }
                if (!(distance < (double)(RANGE * RANGE))) continue;
                double factor = 1.0;
                dx += factor * vx / Math.pow(distance, 2.0);
                dy += factor * vy / Math.pow(distance, 2.0);
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            dlen = Math.sqrt(dlen) / 2.0;
            svd.repulsiondx += dx / dlen;
            svd.repulsiondy += dy / dlen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        Dimension dimension = this.getCurrentSize();
        synchronized (dimension) {
            Iterator i = this.graphView.getNodeViewsIterator();
            while (i.hasNext()) {
                NodeView v = (NodeView)i.next();
                if (this.dontMove(v)) continue;
                SpringVertexData vd = this.getSpringData(v);
                double v_x = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0);
                double v_y = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1);
                vd.dx += vd.repulsiondx + vd.edgedx;
                vd.dy += vd.repulsiondy + vd.edgedy;
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0, v_x + Math.max(-5.0, Math.min(5.0, vd.dx)));
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1, v_y + Math.max(-5.0, Math.min(5.0, vd.dy)));
                int width = this.getCurrentSize().width;
                int height = this.getCurrentSize().height;
                if (v_x < 0.0) {
                    this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0, 0.0);
                } else if (v_x > (double)width) {
                    this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0, width);
                }
                if (v_y < 0.0) {
                    this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1, 0.0);
                    continue;
                }
                if (!(v_y > (double)height)) continue;
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1, height);
            }
        }
    }

    public SpringVertexData getSpringData(NodeView v) {
        return (SpringVertexData)this.nodeIndexToDataMap.get(v.getGraphPerspectiveIndex());
    }

    public SpringVertexData getSpringData(int v) {
        return (SpringVertexData)this.nodeIndexToDataMap.get(v);
    }

    public SpringEdgeData getSpringData(EdgeView e) {
        return (SpringEdgeData)this.edgeIndexToDataMap.get(e.getGraphPerspectiveIndex());
    }

    public double getLength(EdgeView e) {
        return ((SpringEdgeData)this.edgeIndexToDataMap.get((int)e.getGraphPerspectiveIndex())).length;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return !(this.increment < this.NUM_INCRMENTS);
    }

    public class SpringDimensionChecker
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            JUNGSpringLayout.this.resize(e.getComponent().getSize());
        }
    }

    static class SpringEdgeData {
        public double f;
        EdgeView e;
        double length;

        public SpringEdgeData(EdgeView e) {
            this.e = e;
        }
    }

    static class SpringVertexData {
        public double edgedx;
        public double edgedy;
        public double repulsiondx;
        public double repulsiondy;
        public double dx;
        public double dy;
    }

    private static final class UnitLengthFunction
    implements LengthFunction {
        int length;

        public UnitLengthFunction(int length) {
            this.length = length;
        }

        public double getLength(EdgeView e) {
            return this.length;
        }
    }

    public static interface LengthFunction {
        public double getLength(EdgeView var1);
    }
}

