/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import giny.model.GraphPerspective;
import giny.util.MonitorableTask;
import giny.util.SwingWorker;
import java.util.Arrays;
import java.util.LinkedList;

public class IntNodeDistances
implements MonitorableTask {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected int[] nodesArray;
    protected GraphPerspective perspective;
    protected int[][] distances;
    protected boolean directed;
    protected int currentProgress;
    protected int lengthOfTask;
    protected boolean done;
    protected boolean canceled;
    protected String statusMessage;

    public IntNodeDistances(int[] nodes_array, int[][] distances, GraphPerspective perspective) {
        this(nodes_array, distances, perspective, false);
    }

    public IntNodeDistances(int[] nodes_array, int[][] distances, GraphPerspective perspective, boolean directed) {
        this.directed = directed;
        this.perspective = perspective;
        this.nodesArray = nodes_array;
        this.distances = distances == null ? (Object)new int[this.nodesArray.length - 1][] : distances;
    }

    public boolean isDone() {
        return this.done;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Calculating Node Distances";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public int[][] calculate() {
        int index;
        int from_node;
        this.currentProgress = 0;
        this.lengthOfTask = this.distances.length;
        this.done = false;
        this.canceled = false;
        int[] nodes = new int[this.nodesArray.length - 1];
        Integer[] integers = new Integer[nodes.length];
        for (int i = 0; i <= nodes.length; ++i) {
            from_node = this.nodesArray[i];
            if (from_node == 0) continue;
            index = this.perspective.getNodeIndex(from_node) - 1;
            if (index < 0 || index >= nodes.length) {
                System.err.println("WARNING: GraphNode \"" + from_node + "\" has an index value that is out of range: " + index + ".  Graph indices should be maintained such " + "that no index is unused.");
                return null;
            }
            if (nodes[index] != 0) {
                System.err.println("WARNING: GraphNode \"" + from_node + "\" has an index value ( " + index + " ) that is the same as " + "that of another GraphNode ( \"" + nodes[index] + "\" ).  Graph indices should be maintained such " + "that indices are unique.");
                return null;
            }
            nodes[index] = from_node;
            integers[index] = new Integer(index);
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        boolean[] completed_nodes = new boolean[nodes.length];
        for (int from_node_index = 0; from_node_index < nodes.length; ++from_node_index) {
            if (this.canceled) {
                return null;
            }
            from_node = nodes[from_node_index];
            if (from_node == 0) {
                if (this.distances[from_node_index] == null) {
                    this.distances[from_node_index] = new int[nodes.length];
                }
                Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
                continue;
            }
            if (this.distances[from_node_index] == null) {
                this.distances[from_node_index] = new int[nodes.length];
            }
            Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
            this.distances[from_node_index][from_node_index] = 0;
            Arrays.fill(completed_nodes, false);
            queue.add(integers[from_node_index]);
            while (!queue.isEmpty()) {
                if (this.canceled) {
                    return null;
                }
                index = (Integer)queue.removeFirst();
                if (completed_nodes[index]) continue;
                completed_nodes[index] = true;
                int to_node = nodes[index];
                int to_node_distance = this.distances[from_node_index][index];
                if (index < from_node_index) {
                    for (int i = 0; i < nodes.length; ++i) {
                        int distance_through_to_node;
                        if (this.distances[index][i] == Integer.MAX_VALUE || (distance_through_to_node = to_node_distance + this.distances[index][i]) > this.distances[from_node_index][i]) continue;
                        if (this.distances[index][i] == 1) {
                            completed_nodes[i] = true;
                        }
                        this.distances[from_node_index][i] = distance_through_to_node;
                    }
                    continue;
                }
                int[] neighbors = this.perspective.neighborsArray(to_node);
                for (int i = 0; i < neighbors.length; ++i) {
                    if (this.canceled) {
                        return null;
                    }
                    int neighbor = neighbors[i];
                    int neighbor_index = neighbor - 1;
                    if (nodes[neighbor_index] == 0) {
                        this.distances[from_node_index][neighbor_index] = Integer.MAX_VALUE;
                        continue;
                    }
                    if (completed_nodes[neighbor_index]) continue;
                    int neighbor_distance = this.distances[from_node_index][neighbor_index];
                    if (to_node_distance == Integer.MAX_VALUE || neighbor_distance <= to_node_distance + 1) continue;
                    this.distances[from_node_index][neighbor_index] = to_node_distance + 1;
                    queue.addLast(integers[neighbor_index]);
                }
            }
            ++this.currentProgress;
            double percentDone = this.currentProgress * 100 / this.lengthOfTask;
            this.statusMessage = "Completed " + percentDone + "%.";
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
        return this.distances;
    }

    public int[][] getDistances() {
        return this.distances;
    }

    public void start(boolean return_when_done) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new IntNodeDistancesTask();
            }
        };
        worker.start();
        if (return_when_done) {
            worker.get();
        }
    }

    class IntNodeDistancesTask {
        IntNodeDistancesTask() {
            IntNodeDistances.this.calculate();
        }
    }
}

