/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import giny.util.Abstract3DLayout;
import giny.view.GraphView;
import giny.view.NodeView;
import java.util.Iterator;
import java.util.Vector;

public class ISOM3DLayout
extends Abstract3DLayout {
    private int maxEpoch;
    private int epoch;
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    private double factor;
    private double coolingFactor;
    private boolean trace;
    private boolean done;
    private Vector queue;
    private String status = null;
    private OpenIntObjectHashMap nodeIndexToDataMap;
    private double globalX;
    private double globalY;
    private double globalZ;

    public ISOM3DLayout(GraphView view) {
        super(view);
        this.nodeIndexToDataMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(view.getNodeViewCount()));
        this.queue = new Vector();
        this.trace = false;
    }

    public void doLayout() {
        this.initialize(null);
        while (this.epoch < this.maxEpoch) {
            this.advancePositions();
            System.out.println(this.getStatus());
        }
        Iterator nodes = this.graphView.getNodeViewsIterator();
        while (nodes.hasNext()) {
            ((NodeView)nodes.next()).setNodePosition(true);
        }
    }

    public String getStatus() {
        return this.status;
    }

    protected void initialize_local() {
        this.done = false;
        this.maxEpoch = 2000;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    protected void initialize_local_node_view(NodeView v) {
        ISOMVertexData vd = this.getISOMVertexData(v);
        if (vd == null) {
            vd = new ISOMVertexData();
            this.nodeIndexToDataMap.put(v.getGraphPerspectiveIndex(), vd);
        }
        vd.visited = false;
    }

    public void advancePositions() {
        this.status = "epoch: " + this.epoch + "; ";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
            this.done = true;
        }
    }

    private synchronized void adjust() {
        ISOMVertexData tempISOM = new ISOMVertexData();
        this.globalX = 10.0 + Math.random() * this.getCurrentSize().getWidth();
        this.globalY = 10.0 + Math.random() * this.getCurrentSize().getHeight();
        this.globalZ = 10.0 + Math.random() * 50.0;
        NodeView winner = this.getNodeView(this.globalX, this.globalY, this.globalZ);
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            NodeView v = (NodeView)iter.next();
            ISOMVertexData ivd = this.getISOMVertexData(v);
            ivd.distance = 0;
            ivd.visited = false;
        }
        this.adjustVertex(winner);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(NodeView v) {
        this.queue.removeAllElements();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(v);
        while (!this.queue.isEmpty()) {
            NodeView current = (NodeView)this.queue.remove(0);
            ISOMVertexData currData = this.getISOMVertexData(current);
            int current_index = current.getGraphPerspectiveIndex();
            double current_x = this.graphView.getNodeDoubleProperty(current_index, 0);
            double current_y = this.graphView.getNodeDoubleProperty(current_index, 1);
            double current_z = this.graphView.getNodeDoubleProperty(current_index, 1);
            double dx = this.globalX - current_x;
            double dy = this.globalY - current_y;
            double dz = this.globalZ - current_z;
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            this.graphView.setNodeDoubleProperty(current_index, 0, current_x + factor * dx);
            this.graphView.setNodeDoubleProperty(current_index, 1, current_y + factor * dy);
            this.graphView.setNodeDoubleProperty(current_index, 10, current_z + factor * dz);
            if (currData.distance >= this.radius) continue;
            int[] neighbors = this.graphView.getGraphPerspective().neighborsArray(current_index);
            for (int neighbor_index = 0; neighbor_index < neighbors.length; ++neighbor_index) {
                NodeView child = this.graphView.getNodeView(neighbors[neighbor_index]);
                ISOMVertexData childData = this.getISOMVertexData(child);
                if (childData.visited) continue;
                childData.visited = true;
                childData.distance = currData.distance + 1;
                this.queue.addElement(child);
            }
        }
    }

    public ISOMVertexData getISOMVertexData(NodeView v) {
        return (ISOMVertexData)this.nodeIndexToDataMap.get(v.getGraphPerspectiveIndex());
    }

    public ISOMVertexData getISOMVertexData(int v) {
        return (ISOMVertexData)this.nodeIndexToDataMap.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return false;
    }

    public static class ISOMVertexData {
        public DoubleMatrix1D disp;
        int distance;
        boolean visited;

        public ISOMVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(3);
            this.distance = 0;
            this.visited = false;
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public double getZDisp() {
            return this.disp.get(2);
        }

        public void setDisp(double x, double y, double z) {
            this.disp.set(0, x);
            this.disp.set(1, y);
            this.disp.set(2, z);
        }

        public void incrementDisp(double x, double y, double z) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
            this.disp.set(2, this.disp.get(2) + z);
        }

        public void decrementDisp(double x, double y, double z) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
            this.disp.set(2, this.disp.get(2) - z);
        }
    }
}

