/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import giny.model.GraphPerspective;
import giny.model.RootGraph;
import java.util.Arrays;

public abstract class GraphPerspectiveUtil {
    public static int[] hideNode(GraphPerspective gp, int node, boolean hide_adjacent_edges) {
        if (hide_adjacent_edges) {
            int[] edges = gp.hideEdges(gp.getAdjacentEdgeIndicesArray(node, true, true, true));
            gp.hideNode(node);
            return edges;
        }
        gp.hideNode(node);
        return new int[0];
    }

    public void unhideNode(GraphPerspective gp, int node, boolean unhide_all_edges) {
        gp.restoreNode(node);
        if (unhide_all_edges) {
            RootGraph rg = gp.getRootGraph();
            int[] neighbors = gp.neighborsArray(node);
            for (int i = 0; i < neighbors.length; ++i) {
                int j;
                int[] s_t = rg.getEdgeIndicesArray(node, neighbors[i], true);
                int[] t_s = rg.getEdgeIndicesArray(neighbors[i], node, false);
                for (j = 0; j < s_t.length; ++j) {
                    gp.restoreEdge(s_t[j]);
                }
                for (j = 0; j < t_s.length; ++j) {
                    gp.restoreEdge(t_s[j]);
                }
            }
        }
    }

    public void unhideNode(GraphPerspective gp, int node, boolean unhide_all_edges, int[] excluded_edges) {
        gp.restoreNode(node);
        Arrays.sort(excluded_edges);
        if (unhide_all_edges) {
            RootGraph rg = gp.getRootGraph();
            int[] neighbors = gp.neighborsArray(node);
            for (int i = 0; i < neighbors.length; ++i) {
                int j;
                int[] s_t = rg.getEdgeIndicesArray(node, neighbors[i], true);
                int[] t_s = rg.getEdgeIndicesArray(neighbors[i], node, false);
                for (j = 0; j < s_t.length; ++j) {
                    if (Arrays.binarySearch(excluded_edges, s_t[j]) < 0) continue;
                    gp.restoreEdge(s_t[j]);
                }
                for (j = 0; j < t_s.length; ++j) {
                    if (Arrays.binarySearch(excluded_edges, t_s[j]) < 0) continue;
                    gp.restoreEdge(t_s[j]);
                }
            }
        }
    }
}

