/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import giny.model.GraphPerspective;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class GraphPartition {
    public static List partition(GraphPerspective perspective) {
        int[] nodes_arrays = perspective.getNodeIndicesArray();
        IntArrayList un_connected = new IntArrayList();
        IntArrayList connected = new IntArrayList();
        for (int i = 0; i < nodes_arrays.length; ++i) {
            if (perspective.getDegree(nodes_arrays[i]) == 0) {
                un_connected.add(perspective.getRootGraphNodeIndex(nodes_arrays[i]));
                continue;
            }
            connected.add(perspective.getRootGraphNodeIndex(nodes_arrays[i]));
        }
        connected.trimToSize();
        un_connected.trimToSize();
        List partitions = GraphPartition.single_partition(perspective.createGraphPerspective(connected.elements(), perspective.getConnectingEdgeIndicesArray(connected.elements())));
        for (int i = 0; i < un_connected.size(); ++i) {
            partitions.add(new int[]{un_connected.get(i)});
        }
        Object[] parts = partitions.toArray();
        Arrays.sort(parts, new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] one = (int[])o1;
                int[] two = (int[])o2;
                if (one.length == two.length) {
                    return 0;
                }
                if (one.length < two.length) {
                    return 1;
                }
                if (one.length > two.length) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        return Arrays.asList(parts);
    }

    public static List single_partition(GraphPerspective perspective) {
        int i;
        int nodes_left;
        ArrayList<int[]> partitions = new ArrayList<int[]>();
        OpenIntIntHashMap edges = new OpenIntIntHashMap(perspective.getEdgeCount());
        OpenIntIntHashMap nodes = new OpenIntIntHashMap(perspective.getNodeCount());
        int[] edge_indices = perspective.getEdgeIndicesArray();
        boolean inititalized = false;
        int last_nodes_left = nodes_left = perspective.getNodeCount();
        while (nodes_left > 0) {
            if (nodes_left == last_nodes_left && inititalized) {
                IntArrayList forest = new IntArrayList(perspective.getEdgeCount());
                for (i = 0; i < edge_indices.length; ++i) {
                    if (edges.get(edge_indices[i]) != 1) continue;
                    edges.put(edge_indices[i], 2);
                    forest.add(edge_indices[i]);
                    inititalized = false;
                }
                forest.trimToSize();
                partitions.add(forest.elements());
            }
            last_nodes_left = nodes_left;
            for (int i2 = 0; i2 < edge_indices.length; ++i2) {
                int target = perspective.getEdgeTargetIndex(edge_indices[i2]);
                int source = perspective.getEdgeSourceIndex(edge_indices[i2]);
                if (!(inititalized || edges.get(edge_indices[i2]) != 0 || nodes.get(source) != 0 && nodes.get(target) != 0)) {
                    if (nodes.get(source) == 0) {
                        nodes.put(source, 1);
                        --nodes_left;
                    }
                    if (nodes.get(target) == 0) {
                        nodes.put(target, 1);
                        --nodes_left;
                    }
                    inititalized = true;
                    edges.put(edge_indices[i2], 1);
                    continue;
                }
                if (edges.get(edge_indices[i2]) != 0 || nodes.get(source) == 1 && nodes.get(target) == 1) continue;
                if (nodes.get(source) == 1 && nodes.get(target) == 0) {
                    nodes.put(target, 1);
                    --nodes_left;
                    edges.put(edge_indices[i2], 1);
                    continue;
                }
                if (nodes.get(source) != 0 || nodes.get(target) != 1) continue;
                nodes.put(source, 1);
                --nodes_left;
                edges.put(edge_indices[i2], 1);
            }
        }
        IntArrayList forest = new IntArrayList(perspective.getEdgeCount());
        for (i = 0; i < edge_indices.length; ++i) {
            if (edges.get(edge_indices[i]) != 1) continue;
            edges.put(edge_indices[i], 2);
            forest.add(edge_indices[i]);
        }
        forest.trimToSize();
        partitions.add(forest.elements());
        for (i = 0; i < partitions.size(); ++i) {
            partitions.set(i, perspective.getConnectingNodeIndicesArray((int[])partitions.get(i)));
        }
        return partitions;
    }
}

