/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import giny.util.AbstractLayout;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class ForceDirectedLayout
extends AbstractLayout {
    private double springLength = 30.0;
    private double stiffness = 30.0;
    private double electricalRepulsion = 200.0;
    private double increments;
    private boolean initialized = false;
    double NUM_INCRMENTS = 100.0;
    double increment = 0.5;

    public ForceDirectedLayout(GraphView g) {
        super(g);
    }

    protected void initialize_local() {
    }

    protected void initialize_local_node_view(NodeView v) {
    }

    public void doLayout() {
        this.initialize(null);
        while (!this.incrementsAreDone()) {
            this.advancePositions();
            System.out.println(this.increments + " " + this.getStatus());
        }
        Iterator nodes = this.graphView.getNodeViewsIterator();
        while (nodes.hasNext()) {
            ((NodeView)nodes.next()).setNodePosition(true);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return !(this.increments < this.NUM_INCRMENTS);
    }

    public void advancePositions() {
        this.increments += 1.0;
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            double distance;
            NodeView v = (NodeView)iter.next();
            if (this.dontMove(v)) continue;
            double xForce = 0.0;
            double yForce = 0.0;
            double xSpring = 0.0;
            double ySpring = 0.0;
            double xRepulsion = 0.0;
            double yRepulsion = 0.0;
            double adjacentDistance = 0.0;
            double thisX = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0);
            double thisY = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1);
            double adjX = thisX;
            double adjY = thisY;
            int[] adjacent_nodes = this.graphView.getGraphPerspective().neighborsArray(v.getGraphPerspectiveIndex());
            for (int i = 0; i < adjacent_nodes.length; ++i) {
                NodeView adjacent_node_view = this.graphView.getNodeView(adjacent_nodes[i]);
                adjX = this.graphView.getNodeDoubleProperty(adjacent_node_view.getGraphPerspectiveIndex(), 0);
                distance = Point2D.distance(adjX, adjY = this.graphView.getNodeDoubleProperty(adjacent_node_view.getGraphPerspectiveIndex(), 1), thisX, thisY);
                if (distance == 0.0) {
                    distance = 1.0E-4;
                }
                double spring = this.stiffness * Math.log(distance / this.springLength) * ((thisX - adjX) / distance);
                xSpring += spring;
                spring = this.stiffness * Math.log(distance / this.springLength) * ((thisY - adjY) / distance);
                ySpring += spring;
            }
            Iterator ite = this.graphView.getNodeViewsIterator();
            while (ite.hasNext()) {
                NodeView other_v = (NodeView)ite.next();
                if (v == other_v) continue;
                adjX = this.graphView.getNodeDoubleProperty(other_v.getGraphPerspectiveIndex(), 0);
                distance = Point2D.distance(adjX, adjY = this.graphView.getNodeDoubleProperty(other_v.getGraphPerspectiveIndex(), 1), thisX, thisY);
                if (distance == 0.0) {
                    distance = 1.0E-4;
                }
                double repulsion = this.electricalRepulsion / distance * ((thisX - adjX) / distance);
                xRepulsion += repulsion;
                repulsion = this.electricalRepulsion / distance * ((thisY - adjY) / distance);
                yRepulsion += repulsion;
            }
            xForce = xSpring - xRepulsion;
            yForce = ySpring - yRepulsion;
            double xadj = 0.0 - xForce * this.increment;
            double yadj = 0.0 - yForce * this.increment;
            double newX = thisX + adjX;
            double newY = thisY + adjY;
            if (newX >= 0.0 && newY >= 0.0) {
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0, xadj);
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1, yadj);
                continue;
            }
            if (newX < 0.0 && newY >= 0.0) {
                if (thisX > 0.0) {
                    xadj = 0.0 - thisX;
                    continue;
                }
                xadj = 0.0;
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0, xadj);
                this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1, yadj);
                continue;
            }
            if (!(newY < 0.0) || !(newX >= 0.0)) continue;
            yadj = thisY > 0.0 ? 0.0 - thisY : 0.0;
            this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0, xadj);
            this.graphView.setNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1, yadj);
        }
    }
}

