/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import giny.util.AbstractLayout;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.util.Iterator;

public class FRLayout
extends AbstractLayout {
    private double forceConstant;
    private double temperature;
    private int currentIteration;
    private String status = null;
    private int mMaxIterations = 50;
    private double EPSILON = 1.0E-6;
    protected OpenIntObjectHashMap nodeIndexToFRDataMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime(this.graphView.getNodeViewCount()));

    public FRLayout(GraphView view) {
        super(view);
    }

    public void doLayout() {
        this.initialize(null);
        while (!this.incrementsAreDone()) {
            this.advancePositions();
        }
        Iterator nodes = this.graphView.getNodeViewsIterator();
        while (nodes.hasNext()) {
            ((NodeView)nodes.next()).setNodePosition(true);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void forceMove(NodeView picked, int x, int y) {
    }

    protected void initialize_local() {
        this.currentIteration = 0;
        this.temperature = this.getCurrentSize().getWidth() / 10.0;
        this.forceConstant = 0.75 * Math.sqrt(this.getCurrentSize().getHeight() * this.getCurrentSize().getWidth() / (double)this.graphView.getNodeViewCount());
        System.out.println("Forceconstant set to: " + this.forceConstant);
    }

    protected void initialize_local_node_view(NodeView v) {
        this.nodeIndexToFRDataMap.put(v.getGraphPerspectiveIndex(), new FRVertexData());
    }

    public void advancePositions() {
        ++this.currentIteration;
        this.status = "Num Nodes: " + this.graphView.getNodeViewCount() + " Iteration: " + this.currentIteration + " temp: " + this.temperature;
        Iterator node_views_iterator = this.graphView.getNodeViewsIterator();
        while (node_views_iterator.hasNext()) {
            NodeView nv1 = (NodeView)node_views_iterator.next();
            if (this.dontMove(nv1)) continue;
            this.calcRepulsion(nv1);
        }
        Iterator edge_views_iterator = this.graphView.getEdgeViewsIterator();
        while (edge_views_iterator.hasNext()) {
            EdgeView e = (EdgeView)edge_views_iterator.next();
            this.calcAttraction(e);
        }
        double cumulativeChange = 0.0;
        Iterator node_views_iterator2 = this.graphView.getNodeViewsIterator();
        while (node_views_iterator2.hasNext()) {
            NodeView nv1 = (NodeView)node_views_iterator2.next();
            if (this.dontMove(nv1)) continue;
            this.calcPositions(nv1);
        }
        this.cool();
    }

    public void calcPositions(NodeView node_view) {
        FRVertexData fvd = this.getFRData(node_view);
        double node_view_x = this.graphView.getNodeDoubleProperty(node_view.getGraphPerspectiveIndex(), 0);
        double node_view_y = this.graphView.getNodeDoubleProperty(node_view.getGraphPerspectiveIndex(), 1);
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(fvd.disp.zDotProduct(fvd.disp)));
        double newXDisp = fvd.getXDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        if (Double.isNaN(newXDisp)) {
            newXDisp = 1.0;
            System.out.println("Unexpected mathematical result -- newXDisp");
            System.out.println("fvd.getXDisp(): " + fvd.getXDisp() + " deltaLength: " + deltaLength + " temperature: " + this.temperature);
        }
        double newYDisp = fvd.getYDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        this.graphView.setNodeDoubleProperty(node_view.getGraphPerspectiveIndex(), 0, node_view_x + newXDisp);
        this.graphView.setNodeDoubleProperty(node_view.getGraphPerspectiveIndex(), 1, node_view_y + newYDisp);
        if (Double.isNaN(newYDisp)) {
            newXDisp = 1.0;
            System.out.println("Unexpected mathematical result -- newYDisp");
            System.out.println("fvd.getYDisp(): " + fvd.getYDisp() + " deltaLength: " + deltaLength + " temperature: " + this.temperature);
        }
    }

    public void calcAttraction(EdgeView e) {
        double target_y;
        double yDelta;
        int source_index = this.graphView.getGraphPerspective().getEdgeSourceIndex(e.getGraphPerspectiveIndex());
        int target_index = this.graphView.getGraphPerspective().getEdgeTargetIndex(e.getGraphPerspectiveIndex());
        double source_x = this.graphView.getNodeDoubleProperty(source_index, 0);
        double source_y = this.graphView.getNodeDoubleProperty(source_index, 1);
        double target_x = this.graphView.getNodeDoubleProperty(target_index, 0);
        double xDelta = source_x - target_x;
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = source_y - (target_y = this.graphView.getNodeDoubleProperty(target_index, 1))) * yDelta));
        double force = deltaLength * deltaLength / this.forceConstant;
        if (Double.isNaN(force)) {
            force = 1.0;
            System.out.println("Unexpected mathematical result -- force in Attraction");
            System.out.println("deltaLength: " + deltaLength + " forceConstant: " + this.forceConstant);
        }
        FRVertexData fvd1 = this.getFRData(source_index);
        FRVertexData fvd2 = this.getFRData(target_index);
        fvd1.decrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force);
        fvd2.incrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force);
    }

    public void calcRepulsion(NodeView nv1) {
        FRVertexData fvd1 = this.getFRData(nv1);
        fvd1.setDisp(0.0, 0.0);
        Iterator node_views_iterator = this.graphView.getNodeViewsIterator();
        while (node_views_iterator.hasNext()) {
            double nv2_y;
            double yDelta;
            NodeView nv2 = (NodeView)node_views_iterator.next();
            if (this.dontMove(nv2) || nv1 == nv2) continue;
            double nv1_x = this.graphView.getNodeDoubleProperty(nv1.getGraphPerspectiveIndex(), 0);
            double nv1_y = this.graphView.getNodeDoubleProperty(nv1.getGraphPerspectiveIndex(), 1);
            double nv2_x = this.graphView.getNodeDoubleProperty(nv2.getGraphPerspectiveIndex(), 0);
            double xDelta = nv1_x - nv2_x;
            double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = (nv1_y = (nv2_y = this.graphView.getNodeDoubleProperty(nv2.getGraphPerspectiveIndex(), 1)))) * yDelta));
            double force = this.forceConstant * this.forceConstant / deltaLength;
            if (Double.isNaN(force)) {
                force = 1.0;
                System.out.println("Unexpected mathematical result -- force in Repulsion");
                System.out.println("deltaLength: " + deltaLength + " forceConstant: " + this.forceConstant);
            }
            fvd1.incrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.mMaxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.mMaxIterations = maxIterations;
    }

    public FRVertexData getFRData(NodeView v) {
        return (FRVertexData)this.nodeIndexToFRDataMap.get(v.getGraphPerspectiveIndex());
    }

    public FRVertexData getFRData(int v) {
        return (FRVertexData)this.nodeIndexToFRDataMap.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return this.currentIteration > this.mMaxIterations;
    }

    public static class FRVertexData {
        private DoubleMatrix1D disp;

        public FRVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(2);
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public void setDisp(double x, double y) {
            this.disp.set(0, x);
            this.disp.set(1, y);
        }

        public void incrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
        }

        public void decrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
        }
    }
}

