/*
 * Decompiled with CFR 0.152.
 */
package giny.util;

import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractLayout {
    protected Set staticNodes;
    protected GraphView graphView;
    protected Dimension currentSize;

    public AbstractLayout(GraphView view) {
        this.graphView = view;
        this.staticNodes = new HashSet();
    }

    public abstract void doLayout();

    public boolean dontMove(NodeView nv) {
        return this.staticNodes.contains(nv);
    }

    public void initialize(Dimension size) {
        this.currentSize = this.currentSize != null ? size : new Dimension(1000, 1000);
        this.initialize_local();
        this.initializeLocations();
    }

    protected abstract void initialize_local();

    protected abstract void initialize_local_node_view(NodeView var1);

    protected void initializeLocations() {
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            NodeView v = (NodeView)iter.next();
            if (!this.staticNodes.contains(v)) {
                this.initializeLocation(v, this.currentSize);
            }
            this.initialize_local_node_view(v);
        }
    }

    protected void initializeLocation(NodeView v, Dimension d) {
        double x = Math.random() * d.getWidth();
        double y = Math.random() * d.getHeight();
        v.setXPosition(x, false);
        v.setYPosition(y, false);
    }

    public String getStatus() {
        return null;
    }

    public abstract void advancePositions();

    public Dimension getCurrentSize() {
        return this.currentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Dimension size) {
        Dimension oldSize;
        Dimension dimension = this.currentSize;
        synchronized (dimension) {
            if (this.currentSize.equals(size)) {
                return;
            }
            oldSize = this.currentSize;
            this.currentSize = size;
        }
        int xOffset = (size.width - oldSize.width) / 2;
        int yOffset = (size.height - oldSize.height) / 2;
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            NodeView e = (NodeView)iter.next();
            e.setOffset(e.getXPosition() + (double)xOffset, e.getYPosition() + (double)yOffset);
        }
    }

    public void restart() {
        this.initializeLocations();
        this.initialize_local();
    }

    public NodeView getNodeView(double x, double y) {
        double minDistance = Double.MAX_VALUE;
        NodeView closest = null;
        Iterator iter = this.graphView.getNodeViewsIterator();
        while (iter.hasNext()) {
            double dy;
            NodeView v = (NodeView)iter.next();
            double dx = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 0) - x;
            double dist = dx * dx + (dy = this.graphView.getNodeDoubleProperty(v.getGraphPerspectiveIndex(), 1) - y) * dy;
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = v;
        }
        return closest;
    }

    public void forceMove(NodeView picked, double x, double y) {
        picked.setOffset(x, y);
    }

    public void lockNodes(NodeView[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.staticNodes.add(nodes[i]);
        }
    }

    public void lockVertex(NodeView v) {
        this.staticNodes.add(v);
    }

    public void unlockVertex(NodeView v) {
        this.staticNodes.remove(v);
    }
}

