/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class XYArray
implements MutablePoints {
    private double[] points = null;
    private int numPoints = 0;

    public int getPointCount() {
        return this.numPoints;
    }

    private int i(int i) {
        if (i < 0) {
            i = this.numPoints + i;
        }
        if (i >= this.numPoints) {
            throw new IllegalArgumentException("The point index " + i + " is not below " + this.numPoints);
        }
        return i;
    }

    public double getX(int i) {
        i = this.i(i);
        return this.points[i * 2];
    }

    public double getY(int i) {
        i = this.i(i);
        return this.points[i * 2 + 1];
    }

    public Point2D getPoint(int i, Point2D dst) {
        i = this.i(i);
        dst.setLocation(this.points[i * 2], this.points[i * 2 + 1]);
        return dst;
    }

    public void setX(int i, double x) {
        i = this.i(i);
        this.points[i * 2] = x;
    }

    public void setY(int i, double y) {
        i = this.i(i);
        this.points[i * 2 + 1] = y;
    }

    public void setPoint(int i, double x, double y) {
        i = this.i(i);
        this.points[i * 2] = x;
        this.points[i * 2 + 1] = y;
    }

    public void setPoint(int i, Point2D pt) {
        this.setPoint(i, pt.getX(), pt.getY());
    }

    public void transformPoints(AffineTransform t) {
        t.transform(this.points, 0, this.points, 0, this.numPoints);
    }

    public Rectangle2D getBounds(Rectangle2D dst) {
        int i = 0;
        if (dst.isEmpty() && this.getPointCount() > 0) {
            dst.setRect(this.getX(i), this.getY(i), 1.0, 1.0);
            ++i;
        }
        while (i < this.getPointCount()) {
            dst.add(this.getX(i), this.getY(i));
            ++i;
        }
        return dst;
    }

    public static double[] initPoints(double[] points, int n, double[] old) {
        if (points == null || n * 2 > points.length) {
            points = new double[n * 2];
        }
        if (old != null && points != old) {
            System.arraycopy(old, 0, points, 0, Math.min(old.length, n * 2));
        }
        return points;
    }

    private void initPoints(double[] points, int n) {
        this.points = XYArray.initPoints(points, n, this.points);
        this.numPoints = points != null ? points.length / 2 : 0;
    }

    public XYArray(double[] points) {
        this.initPoints(points, points.length / 2);
    }

    public XYArray(int n) {
        this.initPoints(null, n);
    }

    public XYArray() {
        this(0);
    }

    public void addPoints(int pos, Points pts, int start, int end) {
        if (end < 0) {
            end = pts.getPointCount() + end + 1;
        }
        int n = this.numPoints + end - start;
        this.points = XYArray.initPoints(this.points, n, this.points);
        int pos1 = pos * 2;
        int pos2 = (pos + end - start) * 2;
        int len = (this.numPoints - pos) * 2;
        System.arraycopy(this.points, pos1, this.points, pos2, len);
        this.numPoints = n;
        if (pts == null) {
            return;
        }
        int count = 0;
        while (start < end) {
            this.setPoint(this.numPoints + count, pts.getX(start), pts.getY(start));
            ++count;
            ++start;
        }
    }

    public void addPoints(int pos, Points pts) {
        this.addPoints(pos, pts, 0, pts.getPointCount());
    }

    public void appendPoints(Points pts) {
        this.addPoints(this.numPoints, pts);
    }

    public static XYArray copyPoints(Points pts) {
        XYArray newList = new XYArray(pts.getPointCount());
        newList.appendPoints(pts);
        return newList;
    }

    public void addPoint(int pos, double x, double y) {
        this.addPoints(pos, null, 0, 1);
        this.setPoint(pos, x, y);
    }

    public void addPoint(int pos, Point2D pt) {
        this.addPoint(pos, pt.getX(), pt.getY());
    }

    public void removePoints(int pos, int num) {
        if ((num = Math.min(num, this.numPoints - pos)) <= 0) {
            return;
        }
        System.arraycopy(this.points, (pos + num) * 2, this.points, pos * 2, (this.numPoints - (pos + num)) * 2);
        this.numPoints -= num;
    }

    public void removeAllPoints() {
        this.removePoints(0, this.numPoints);
    }

    public Object clone() {
        XYArray ps = null;
        try {
            ps = (XYArray)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (ps != null) {
            ps.points = XYArray.initPoints(ps.points, this.numPoints, this.points);
            ps.numPoints = this.numPoints;
        }
        return ps;
    }
}

