/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;

public class POcclusionDetection {
    public void detectOccusions(PNode n, PBounds parentBounds) {
        this.detectOcclusions(n, new PPickPath(null, parentBounds));
    }

    public void detectOcclusions(PNode n, PPickPath pickPath) {
        if (n.fullIntersects(pickPath.getPickBounds())) {
            pickPath.pushTransform(n.getTransformReference(false));
            int count = n.getChildrenCount();
            for (int i = count - 1; i >= 0; --i) {
                PNode each = n.getChild(i);
                if (n.getOccluded()) {
                    each.setOccluded(true);
                    continue;
                }
                this.detectOcclusions(each, pickPath);
            }
            if (!n.getOccluded() && n.intersects(pickPath.getPickBounds()) && n.isOpaque(pickPath.getPickBounds())) {
                PNode p = n.getParent();
                while (p != null && !p.getOccluded()) {
                    p.setOccluded(true);
                }
            }
            pickPath.popTransform(n.getTransformReference(false));
        }
    }
}

