/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.PSWTCanvas;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class PSWTImage
extends PNode {
    public static final String PROPERTY_IMAGE = "image";
    private transient PSWTCanvas canvas;
    private transient Image image;

    public PSWTImage(PSWTCanvas canvas) {
        this.canvas = canvas;
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                if (PSWTImage.this.image != null) {
                    PSWTImage.this.image.dispose();
                }
            }
        });
    }

    public PSWTImage(PSWTCanvas canvas, Image newImage) {
        this(canvas);
        this.setImage(newImage);
    }

    public PSWTImage(PSWTCanvas canvas, String fileName) {
        this(canvas);
        this.setImage(fileName);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String fileName) {
        this.setImage(new Image((Device)this.canvas.getDisplay(), fileName));
    }

    public void setImage(Image newImage) {
        Image old = this.image;
        this.image = newImage;
        if (this.image != null) {
            Rectangle bounds = this.getImage().getBounds();
            this.setBounds(0.0, 0.0, bounds.width, bounds.height);
            this.invalidatePaint();
        } else {
            this.image = null;
        }
        this.firePropertyChange(PROPERTY_IMAGE, old, this.image);
    }

    protected void paint(PPaintContext paintContext) {
        if (this.getImage() != null) {
            Rectangle r = this.image.getBounds();
            double iw = r.width;
            double ih = r.height;
            PBounds b = this.getBoundsReference();
            SWTGraphics2D g2 = (SWTGraphics2D)paintContext.getGraphics();
            if (b.x != 0.0 || b.y != 0.0 || b.width != iw || b.height != ih) {
                g2.translate(b.x, b.y);
                g2.scale(b.width / iw, b.height / ih);
                g2.drawImage(this.image, 0.0, 0.0);
                g2.scale(iw / b.width, ih / b.height);
                g2.translate(-b.x, -b.y);
            } else {
                g2.drawImage(this.image, 0.0, 0.0);
            }
        }
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("image=" + (this.image == null ? "null" : this.image.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

