/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import edu.umd.cs.piccolox.util.LineShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PLine
extends PNode {
    public static final String PROPERTY_STROKE_PAINT = "strokePaint";
    public static final String PROPERTY_STROKE = "stroke";
    public static final String PROPERTY_LINE = "line";
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private transient LineShape line;
    private transient Stroke stroke;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public PLine(LineShape line) {
        this.stroke = DEFAULT_STROKE;
        if (line == null) {
            line = new LineShape(null);
        }
        this.line = line;
    }

    public PLine() {
        this(null);
    }

    public PLine(LineShape line, Stroke aStroke) {
        this(line);
        this.stroke = aStroke;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint aPaint) {
        Paint old = this.strokePaint;
        this.strokePaint = aPaint;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE_PAINT, old, this.strokePaint);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke aStroke) {
        Stroke old = this.stroke;
        this.stroke = aStroke;
        this.updateBoundsFromLine();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE, old, this.stroke);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.line == null || !super.setBounds(x, y, width, height)) {
            return false;
        }
        Rectangle2D lineBounds = this.line.getBounds2D();
        Rectangle2D lineStrokeBounds = this.getLineBoundsWithStroke();
        double strokeOutset = Math.max(lineStrokeBounds.getWidth() - lineBounds.getWidth(), lineStrokeBounds.getHeight() - lineBounds.getHeight());
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(x += strokeOutset / 2.0, y += strokeOutset / 2.0);
        TEMP_TRANSFORM.scale((width -= strokeOutset) / lineBounds.getWidth(), (height -= strokeOutset) / lineBounds.getHeight());
        TEMP_TRANSFORM.translate(-lineBounds.getX(), -lineBounds.getY());
        this.line.transformPoints(TEMP_TRANSFORM);
        return true;
    }

    public boolean intersects(Rectangle2D aBounds) {
        if (super.intersects(aBounds)) {
            if (this.line.intersects(aBounds)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.line).intersects(aBounds);
            }
        }
        return false;
    }

    public Rectangle2D getLineBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.line).getBounds2D();
        }
        return this.line.getBounds2D();
    }

    public void updateBoundsFromLine() {
        if (this.line.getPointCount() == 0) {
            this.resetBounds();
        } else {
            Rectangle2D b = this.getLineBoundsWithStroke();
            super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
    }

    protected void paint(PPaintContext paintContext) {
        Graphics2D g2 = paintContext.getGraphics();
        if (this.stroke != null && this.strokePaint != null) {
            g2.setPaint(this.strokePaint);
            g2.setStroke(this.stroke);
            g2.draw(this.line);
        }
    }

    public LineShape getLineReference() {
        return this.line;
    }

    public int getPointCount() {
        return this.line.getPointCount();
    }

    public Point2D getPoint(int i, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        return this.line.getPoint(i, dst);
    }

    protected void lineChanged() {
        this.firePropertyChange(PROPERTY_LINE, null, this.line);
        this.updateBoundsFromLine();
        this.invalidatePaint();
    }

    public void setPoint(int i, double x, double y) {
        this.line.setPoint(i, x, y);
        this.lineChanged();
    }

    public void addPoint(int i, double x, double y) {
        this.line.addPoint(i, x, y);
        this.lineChanged();
    }

    public void removePoints(int i, int n) {
        this.line.removePoints(i, n);
        this.lineChanged();
    }

    public void removeAllPoints() {
        this.line.removePoints(0, this.line.getPointCount());
        this.lineChanged();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PUtil.writeStroke(this.stroke, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = PUtil.readStroke(in);
    }
}

