/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.unitTests;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import giny.model.Node;
import java.awt.Color;
import java.awt.Font;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NodeAppearanceCalculatorTest
extends TestCase {
    public NodeAppearanceCalculatorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testBypass() throws Exception {
        Color fillColor = new Color(63, 128, 255);
        Color borderColor = new Color(100, 100, 50);
        LineType lineType = LineType.DASHED_3;
        byte shape = 7;
        double width = 49.0;
        double height = 79.0;
        String label = "testLabel";
        String toolTip = "testToolTip";
        Font font = new Font("SansSerif", 2, 10);
        CytoscapeRootGraph graph = Cytoscape.getRootGraph();
        int index1 = graph.createNode();
        Node first = graph.getNode(index1);
        int index2 = graph.createNode();
        Node second = graph.getNode(index2);
        GraphObjAttributes firstNodeAttr = Cytoscape.getNodeNetworkData();
        String firstName = "first node";
        firstNodeAttr.addNameMapping(firstName, first);
        firstNodeAttr.set("node.fillColor", firstName, fillColor);
        firstNodeAttr.set("node.borderColor", firstName, borderColor);
        firstNodeAttr.set("node.lineType", firstName, lineType);
        firstNodeAttr.set("node.shape", firstName, new Byte(shape));
        firstNodeAttr.set("node.width", firstName, width);
        firstNodeAttr.set("node.height", firstName, height);
        firstNodeAttr.set("node.label", firstName, label);
        firstNodeAttr.set("node.toolTip", firstName, toolTip);
        firstNodeAttr.set("node.font", firstName, font);
        CyNetwork network1 = Cytoscape.createNetwork(Cytoscape.getRootGraph().getNodeIndicesArray(), Cytoscape.getRootGraph().getEdgeIndicesArray(), null);
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator();
        nac.setNodeSizeLocked(false);
        NodeAppearance firstApp = nac.calculateNodeAppearance(first, network1);
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getFillColor().equals(fillColor));
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getBorderColor().equals(borderColor));
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getShape() == shape);
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getWidth() == width);
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getHeight() == height);
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getLabel().equals(label));
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getToolTip().equals(toolTip));
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getFont().equals(font));
        CyNetwork network2 = Cytoscape.createNetwork(Cytoscape.getRootGraph().getNodeIndicesArray(), Cytoscape.getRootGraph().getEdgeIndicesArray(), null);
        GraphObjAttributes secondNodeAttr = Cytoscape.getNodeNetworkData();
        String secondName = "second node";
        secondNodeAttr.addNameMapping(secondName, second);
        secondNodeAttr.set("node.fillColor", secondName, "63,128,255");
        secondNodeAttr.set("node.borderColor", secondName, "100,100,50");
        secondNodeAttr.set("node.lineType", secondName, "dashed3");
        secondNodeAttr.set("node.shape", secondName, "diamond");
        secondNodeAttr.set("node.width", secondName, "49.0");
        secondNodeAttr.set("node.height", secondName, "79.0");
        secondNodeAttr.set("node.label", secondName, "testLabel");
        secondNodeAttr.set("node.toolTip", secondName, "testToolTip");
        secondNodeAttr.set("node.font", secondName, "SansSerif,italic,10");
        NodeAppearance secondApp = nac.calculateNodeAppearance(second, network2);
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getFillColor().equals(fillColor));
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getBorderColor().equals(borderColor));
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getBorderLineType().equals(lineType));
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getShape() == shape);
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getWidth() == width);
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getHeight() == height);
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getLabel().equals(label));
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getToolTip().equals(toolTip));
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getFont().equals(font));
        nac.setNodeSizeLocked(true);
        nac.calculateNodeAppearance(firstApp, first, network1);
        NodeAppearanceCalculatorTest.assertTrue(firstApp.getWidth() == height);
        nac.calculateNodeAppearance(secondApp, second, network2);
        NodeAppearanceCalculatorTest.assertTrue(secondApp.getWidth() == height);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(NodeAppearanceCalculatorTest.class));
    }
}

