/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.Arrow;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import java.awt.Color;
import java.awt.Font;

public class VizUIUtilities {
    static Object getDefault(VisualStyle style, byte type) {
        if (style == null) {
            return null;
        }
        Object defaultObj = null;
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        switch (type) {
            case 0: {
                defaultObj = nodeCalc.getDefaultNodeFillColor();
                break;
            }
            case 1: {
                defaultObj = nodeCalc.getDefaultNodeBorderColor();
                break;
            }
            case 2: {
                defaultObj = nodeCalc.getDefaultNodeLineType();
                break;
            }
            case 3: {
                defaultObj = new Byte(nodeCalc.getDefaultNodeShape());
                break;
            }
            case 126: {
                defaultObj = new Double(nodeCalc.getDefaultNodeHeight());
                break;
            }
            case 127: {
                defaultObj = new Double(nodeCalc.getDefaultNodeWidth());
                break;
            }
            case 4: {
                defaultObj = new Double(nodeCalc.getDefaultNodeHeight());
                break;
            }
            case 5: {
                defaultObj = nodeCalc.getDefaultNodeLabel();
                break;
            }
            case 13: {
                defaultObj = nodeCalc.getDefaultNodeToolTip();
                break;
            }
            case 7: {
                defaultObj = edgeCalc.getDefaultEdgeColor();
                break;
            }
            case 8: {
                defaultObj = edgeCalc.getDefaultEdgeLineType();
                break;
            }
            case 9: {
                defaultObj = edgeCalc.getDefaultEdgeSourceArrow();
                break;
            }
            case 10: {
                defaultObj = edgeCalc.getDefaultEdgeTargetArrow();
                break;
            }
            case 11: {
                defaultObj = edgeCalc.getDefaultEdgeLabel();
                break;
            }
            case 14: {
                defaultObj = edgeCalc.getDefaultEdgeToolTip();
                break;
            }
            case 122: {
                defaultObj = nodeCalc.getDefaultNodeFont();
                break;
            }
            case 124: {
                defaultObj = edgeCalc.getDefaultEdgeFont();
                break;
            }
            case 123: {
                defaultObj = new Double(nodeCalc.getDefaultNodeFont().getSize2D());
                break;
            }
            case 125: {
                defaultObj = new Double(edgeCalc.getDefaultEdgeFont().getSize2D());
            }
        }
        return defaultObj;
    }

    static void setDefault(VisualStyle style, byte type, Object c) {
        if (style == null || c == null) {
            return;
        }
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        switch (type) {
            case 0: {
                nodeCalc.setDefaultNodeFillColor((Color)c);
                break;
            }
            case 1: {
                nodeCalc.setDefaultNodeBorderColor((Color)c);
                break;
            }
            case 2: {
                nodeCalc.setDefaultNodeLineType((LineType)c);
                break;
            }
            case 3: {
                nodeCalc.setDefaultNodeShape((Byte)c);
                break;
            }
            case 126: {
                nodeCalc.setDefaultNodeHeight((Double)c);
                break;
            }
            case 127: {
                nodeCalc.setDefaultNodeWidth((Double)c);
                break;
            }
            case 4: {
                nodeCalc.setDefaultNodeHeight((Double)c);
                nodeCalc.setDefaultNodeWidth((Double)c);
                break;
            }
            case 5: {
                nodeCalc.setDefaultNodeLabel((String)c);
                break;
            }
            case 13: {
                nodeCalc.setDefaultNodeToolTip((String)c);
                break;
            }
            case 7: {
                edgeCalc.setDefaultEdgeColor((Color)c);
                break;
            }
            case 8: {
                edgeCalc.setDefaultEdgeLineType((LineType)c);
                break;
            }
            case 9: {
                edgeCalc.setDefaultEdgeSourceArrow((Arrow)c);
                break;
            }
            case 10: {
                edgeCalc.setDefaultEdgeTargetArrow((Arrow)c);
                break;
            }
            case 11: {
                edgeCalc.setDefaultEdgeLabel((String)c);
                break;
            }
            case 14: {
                edgeCalc.setDefaultEdgeToolTip((String)c);
                break;
            }
            case 124: {
                edgeCalc.setDefaultEdgeFontFace((Font)c);
                break;
            }
            case 125: {
                edgeCalc.setDefaultEdgeFontSize(((Double)c).floatValue());
                break;
            }
            case 122: {
                nodeCalc.setDefaultNodeFontFace((Font)c);
                break;
            }
            case 123: {
                nodeCalc.setDefaultNodeFontSize(((Double)c).floatValue());
            }
        }
    }

    static Calculator getCurrentCalculator(VisualStyle style, byte type) {
        if (style == null) {
            return null;
        }
        Calculator currentCalculator = null;
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        switch (type) {
            case 0: {
                currentCalculator = nodeCalc.getNodeFillColorCalculator();
                break;
            }
            case 1: {
                currentCalculator = nodeCalc.getNodeBorderColorCalculator();
                break;
            }
            case 2: {
                currentCalculator = nodeCalc.getNodeLineTypeCalculator();
                break;
            }
            case 3: {
                currentCalculator = nodeCalc.getNodeShapeCalculator();
                break;
            }
            case 126: {
                currentCalculator = nodeCalc.getNodeHeightCalculator();
                break;
            }
            case 127: {
                currentCalculator = nodeCalc.getNodeWidthCalculator();
                break;
            }
            case 4: {
                currentCalculator = nodeCalc.getNodeHeightCalculator();
                break;
            }
            case 5: {
                currentCalculator = nodeCalc.getNodeLabelCalculator();
                break;
            }
            case 13: {
                currentCalculator = nodeCalc.getNodeToolTipCalculator();
                break;
            }
            case 7: {
                currentCalculator = edgeCalc.getEdgeColorCalculator();
                break;
            }
            case 8: {
                currentCalculator = edgeCalc.getEdgeLineTypeCalculator();
                break;
            }
            case 9: {
                currentCalculator = edgeCalc.getEdgeSourceArrowCalculator();
                break;
            }
            case 10: {
                currentCalculator = edgeCalc.getEdgeTargetArrowCalculator();
                break;
            }
            case 11: {
                currentCalculator = edgeCalc.getEdgeLabelCalculator();
                break;
            }
            case 14: {
                currentCalculator = edgeCalc.getEdgeToolTipCalculator();
                break;
            }
            case 122: {
                currentCalculator = nodeCalc.getNodeFontFaceCalculator();
                break;
            }
            case 124: {
                currentCalculator = edgeCalc.getEdgeFontFaceCalculator();
                break;
            }
            case 123: {
                currentCalculator = nodeCalc.getNodeFontSizeCalculator();
                break;
            }
            case 125: {
                currentCalculator = edgeCalc.getEdgeFontSizeCalculator();
            }
        }
        return currentCalculator;
    }

    static void setCurrentCalculator(VisualStyle style, byte type, Calculator c) {
        if (style == null) {
            return;
        }
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        switch (type) {
            case 0: {
                nodeCalc.setNodeFillColorCalculator((NodeColorCalculator)c);
                break;
            }
            case 1: {
                nodeCalc.setNodeBorderColorCalculator((NodeColorCalculator)c);
                break;
            }
            case 2: {
                nodeCalc.setNodeLineTypeCalculator((NodeLineTypeCalculator)c);
                break;
            }
            case 3: {
                nodeCalc.setNodeShapeCalculator((NodeShapeCalculator)c);
                break;
            }
            case 5: {
                nodeCalc.setNodeLabelCalculator((NodeLabelCalculator)c);
                break;
            }
            case 126: {
                nodeCalc.setNodeHeightCalculator((NodeSizeCalculator)c);
                break;
            }
            case 127: {
                nodeCalc.setNodeWidthCalculator((NodeSizeCalculator)c);
                break;
            }
            case 4: {
                nodeCalc.setNodeWidthCalculator((NodeSizeCalculator)c);
                nodeCalc.setNodeHeightCalculator((NodeSizeCalculator)c);
                break;
            }
            case 13: {
                nodeCalc.setNodeToolTipCalculator((NodeToolTipCalculator)c);
                break;
            }
            case 7: {
                edgeCalc.setEdgeColorCalculator((EdgeColorCalculator)c);
                break;
            }
            case 8: {
                edgeCalc.setEdgeLineTypeCalculator((EdgeLineTypeCalculator)c);
                break;
            }
            case 9: {
                edgeCalc.setEdgeSourceArrowCalculator((EdgeArrowCalculator)c);
                break;
            }
            case 10: {
                edgeCalc.setEdgeTargetArrowCalculator((EdgeArrowCalculator)c);
                break;
            }
            case 11: {
                edgeCalc.setEdgeLabelCalculator((EdgeLabelCalculator)c);
                break;
            }
            case 14: {
                edgeCalc.setEdgeToolTipCalculator((EdgeToolTipCalculator)c);
                break;
            }
            case 124: {
                edgeCalc.setEdgeFontFaceCalculator((EdgeFontFaceCalculator)c);
                break;
            }
            case 125: {
                edgeCalc.setEdgeFontSizeCalculator((EdgeFontSizeCalculator)c);
                break;
            }
            case 122: {
                nodeCalc.setNodeFontFaceCalculator((NodeFontFaceCalculator)c);
                break;
            }
            case 123: {
                nodeCalc.setNodeFontSizeCalculator((NodeFontSizeCalculator)c);
            }
        }
    }
}

