/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.CyNetwork;
import cytoscape.CyNetworkEvent;
import cytoscape.CyNetworkListener;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.ui.DefaultPanel;
import cytoscape.visual.ui.VizMapAttrTab;
import cytoscape.visual.ui.VizMapFontTab;
import cytoscape.visual.ui.VizMapSizeTab;
import cytoscape.visual.ui.VizMapTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VizMapUI
extends JDialog
implements CyNetworkListener {
    public static final byte NODE_COLOR = 0;
    public static final byte NODE_BORDER_COLOR = 1;
    public static final byte NODE_LINETYPE = 2;
    public static final byte NODE_SHAPE = 3;
    public static final byte NODE_SIZE = 4;
    public static final byte NODE_LABEL = 5;
    public static final byte NODE_LABEL_FONT = 6;
    public static final byte EDGE_COLOR = 7;
    public static final byte EDGE_LINETYPE = 8;
    public static final byte EDGE_SRCARROW = 9;
    public static final byte EDGE_TGTARROW = 10;
    public static final byte EDGE_LABEL = 11;
    public static final byte EDGE_LABEL_FONT = 12;
    public static final byte NODE_TOOLTIP = 13;
    public static final byte EDGE_TOOLTIP = 14;
    public static final byte NODE_FONT_FACE = 122;
    public static final byte NODE_FONT_SIZE = 123;
    public static final byte EDGE_FONT_FACE = 124;
    public static final byte EDGE_FONT_SIZE = 125;
    public static final byte NODE_HEIGHT = 126;
    public static final byte NODE_WIDTH = 127;
    protected VisualMappingManager VMM;
    private JPanel mainPane;
    private GridBagGroup mainGBG;
    private JPanel actionButtonsPanel;
    private JPanel attrSelectorPanel;
    private JPanel tabPaneContainer;
    private VizMapTab[] tabs;
    protected Collection styles;
    protected StyleSelector styleSelector;
    private boolean initialized = false;

    public VizMapUI(VisualMappingManager VMM, JFrame mainFrame) {
        super((Frame)mainFrame, "Set Visual Properties");
        VizMapTab tab;
        byte i;
        this.VMM = VMM;
        CyNetwork cyNetwork = VMM.getNetwork();
        cyNetwork.addCyNetworkListener(this);
        this.mainGBG = new GridBagGroup();
        this.mainPane = this.mainGBG.panel;
        this.tabs = new VizMapTab[13];
        this.tabPaneContainer = new JPanel(false);
        JTabbedPane nodePane = new JTabbedPane();
        JTabbedPane edgePane = new JTabbedPane();
        for (i = 0; i <= 6; i = (byte)(i + 1)) {
            tab = i == 4 ? new VizMapSizeTab(this, nodePane, i, VMM, i) : (i == 6 ? new VizMapFontTab(this, nodePane, i, VMM, i) : new VizMapAttrTab(this, nodePane, i, VMM, i));
            nodePane.add((Component)tab, i);
            this.tabs[i] = tab;
        }
        for (i = 7; i <= 12; i = (byte)(i + 1)) {
            tab = i == 12 ? new VizMapFontTab(this, edgePane, i - 7, VMM, i) : new VizMapAttrTab(this, edgePane, i - 7, VMM, i);
            edgePane.add((Component)tab, i - 7);
            this.tabs[i] = tab;
        }
        DefaultPanel defaultPane = new DefaultPanel(this, VMM);
        ButtonGroup grp = new ButtonGroup();
        JToggleButton nodeSelect = new JToggleButton("Node Attributes", true);
        JToggleButton edgeSelect = new JToggleButton("Edge Attributes", false);
        JToggleButton defSelect = new JToggleButton("Global Defaults", false);
        grp.add(defSelect);
        grp.add(nodeSelect);
        grp.add(edgeSelect);
        nodeSelect.addActionListener(new AttrSelector(nodePane));
        edgeSelect.addActionListener(new AttrSelector(edgePane));
        defSelect.addActionListener(new AttrSelector(defaultPane));
        this.attrSelectorPanel = new JPanel(new FlowLayout(), false);
        this.attrSelectorPanel.add(nodeSelect);
        this.attrSelectorPanel.add(edgeSelect);
        this.attrSelectorPanel.add(defSelect);
        this.styleSelector = new StyleSelector(this, mainFrame);
        MiscGB.insert(this.mainGBG, this.attrSelectorPanel, 0, 0, 1, 1, 1, 0, 2);
        MiscGB.insert(this.mainGBG, this.tabPaneContainer, 0, 1, 1, 1, 1, 1, 1);
        this.actionButtonsPanel = new JPanel();
        JButton applyButton = new JButton("Apply to Graph");
        applyButton.addActionListener(new ApplyAction());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new CloseAction());
        this.actionButtonsPanel.add(applyButton);
        this.actionButtonsPanel.add(closeButton);
        MiscGB.insert(this.mainGBG, this.actionButtonsPanel, 0, 3, 1, 1, 1, 0, 2);
        this.setContentPane(this.mainPane);
        this.pack();
        nodeSelect.doClick();
        this.initialized = true;
    }

    public StyleSelector getStyleSelector() {
        return this.styleSelector;
    }

    public void refreshUI() {
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].refreshUI();
        }
        this.validate();
        this.repaint();
    }

    public void visualStyleChanged() {
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].visualStyleChanged();
        }
        this.validate();
        this.pack();
        this.repaint();
    }

    VizMapTab checkCalcSelected(Calculator selectedCalc) {
        if (!this.initialized) {
            return null;
        }
        VizMapTab selected = null;
        for (int i = 0; i < this.tabs.length && selected == null; ++i) {
            VizMapTab t = this.tabs[i];
            selected = t.checkCalcSelected(selectedCalc);
        }
        return selected;
    }

    public Vector checkCalculatorUsage(Calculator c) {
        Vector<Vector> conflicts = new Vector<Vector>();
        Iterator iter = this.styles.iterator();
        while (iter.hasNext()) {
            VisualStyle vs = (VisualStyle)iter.next();
            Vector styleName = vs.checkConflictingCalculator(c);
            if (styleName.size() == 1) continue;
            conflicts.add(styleName);
        }
        return conflicts;
    }

    public void onCyNetworkEvent(CyNetworkEvent event) {
        this.refreshUI();
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            VizMapUI.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private ApplyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
        }
    }

    private class AttrSelector
    implements ActionListener {
        private JComponent myTab;

        private AttrSelector(JComponent myTab) {
            this.myTab = myTab;
        }

        public void actionPerformed(ActionEvent e) {
            VizMapUI.this.tabPaneContainer.removeAll();
            VizMapUI.this.tabPaneContainer.add(this.myTab);
            VizMapUI.this.pack();
            VizMapUI.this.repaint();
        }
    }

    public class StyleSelector
    extends JDialog
    implements ChangeListener {
        protected CalculatorCatalog catalog;
        protected DefaultComboBoxModel styleComboModel;
        protected JComboBox styleComboBox;
        protected JComboBox styleComboBoxDupe;
        protected GridBagGroup styleGBG;
        protected VisualStyle currentStyle;
        protected VizMapUI styleDefUI;
        protected StyleSelector myself;
        protected boolean styleDefNeedsUpdate;
        protected boolean rebuilding;

        protected StyleSelector(VizMapUI styleDef, JFrame mainFrame) {
            super((Frame)mainFrame, "Visual Styles");
            this.styleComboModel = new DefaultComboBoxModel();
            this.styleComboBox = new JComboBox(this.styleComboModel);
            this.styleComboBoxDupe = new JComboBox(this.styleComboModel);
            this.styleDefNeedsUpdate = true;
            this.rebuilding = false;
            this.currentStyle = VizMapUI.this.VMM.getVisualStyle();
            this.styleDefUI = styleDef;
            this.catalog = VizMapUI.this.VMM.getCalculatorCatalog();
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.styleGBG = new GridBagGroup("Visual Styles");
            this.myself = this;
            StyleSelectionListener listen = new StyleSelectionListener();
            this.styleComboBox.addItemListener(listen);
            String comboBoxHelp = "Change the current visual style";
            this.styleComboBox.setToolTipText(comboBoxHelp);
            this.styleComboBoxDupe.setToolTipText(comboBoxHelp);
            MiscGB.pad(this.styleGBG.constraints, 2, 2);
            MiscGB.inset(this.styleGBG.constraints, 3);
            this.resetStyles();
            JButton newStyle = new JButton("New");
            newStyle.addActionListener(new NewStyleListener());
            MiscGB.insert(this.styleGBG, newStyle, 0, 1, 1, 1, 1, 0, 2);
            newStyle.setToolTipText("Create a new style");
            JButton dupeStyle = new JButton("Duplicate");
            dupeStyle.addActionListener(new DupeStyleListener());
            MiscGB.insert(this.styleGBG, dupeStyle, 1, 1, 1, 1, 1, 0, 2);
            dupeStyle.setToolTipText("Duplicate the current style");
            JButton renStyle = new JButton("Rename");
            renStyle.addActionListener(new RenStyleListener());
            MiscGB.insert(this.styleGBG, renStyle, 2, 1, 1, 1, 1, 0, 2);
            renStyle.setToolTipText("Rename the current style");
            JButton rmStyle = new JButton("Delete");
            rmStyle.addActionListener(new RmStyleListener());
            MiscGB.insert(this.styleGBG, rmStyle, 3, 1, 1, 1, 1, 0, 2);
            rmStyle.setToolTipText("Delete the current style");
            JButton defStyle = new JButton("Define");
            defStyle.addActionListener(new DefStyleListener());
            MiscGB.insert(this.styleGBG, defStyle, 4, 0, 1, 1, 1, 0, 2);
            defStyle.setToolTipText("Change the current style's settings");
            JButton closeBut = new JButton("Close");
            closeBut.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    this.dispose();
                }
            });
            MiscGB.insert(this.styleGBG, closeBut, 4, 1, 1, 1, 1, 0, 2);
            closeBut.setToolTipText("Close this dialog");
            MiscGB.insert(this.styleGBG, this.styleComboBox, 0, 0, 4, 1, 1, 0, 2);
            this.setContentPane(this.styleGBG.panel);
            this.styleGBG.panel.setToolTipText("Visual styles are a collection of attribute mappings.");
            this.pack();
        }

        public String getStyleName(VisualStyle s) {
            String newName;
            String ret;
            int alt;
            String suggestedName = null;
            if (s != null) {
                suggestedName = this.catalog.checkVisualStyleName(s.getName());
            }
            do {
                if ((ret = (String)JOptionPane.showInputDialog(this.myself, "Name for new visual style", "Visual Style Name Input", 3, null, null, suggestedName)) == null) {
                    return null;
                }
                newName = this.catalog.checkVisualStyleName(ret);
                if (!newName.equals(ret)) continue;
                return ret;
            } while ((alt = JOptionPane.showConfirmDialog(this.myself, "Visual style with name " + ret + " already exists,\nrename to " + newName + " okay?", "Duplicate visual style name", 0, 2, null)) != 0);
            return newName;
        }

        public JComboBox getToolbarComboBox() {
            return this.styleComboBoxDupe;
        }

        protected void refreshStyleComboBox() {
            this.rebuilding = true;
            this.styleComboModel.removeAllElements();
            Iterator styleIter = VizMapUI.this.styles.iterator();
            while (styleIter.hasNext()) {
                this.styleComboModel.addElement(styleIter.next());
            }
            this.styleComboModel.setSelectedItem(this.currentStyle);
            this.rebuilding = false;
        }

        public void resetStyles() {
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.refreshStyleComboBox();
        }

        public void stateChanged(ChangeEvent ce) {
            if (this.currentStyle != VizMapUI.this.VMM.getVisualStyle()) {
                this.currentStyle = VizMapUI.this.VMM.getVisualStyle();
                if (this.styleComboModel.getIndexOf(this.currentStyle) == -1) {
                    this.styleComboModel.addElement(this.currentStyle);
                }
                this.styleComboModel.setSelectedItem(this.currentStyle);
                if (this.styleDefUI.isShowing()) {
                    VizMapUI.this.visualStyleChanged();
                } else {
                    this.styleDefNeedsUpdate = true;
                }
            }
        }

        protected class StyleSelectionListener
        implements ItemListener {
            protected StyleSelectionListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                VisualStyle newStyle;
                if (StyleSelector.this.rebuilding) {
                    return;
                }
                if (e.getStateChange() == 1 && (newStyle = (VisualStyle)((JComboBox)e.getSource()).getSelectedItem()) != StyleSelector.this.currentStyle && newStyle != null) {
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(newStyle);
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
                }
            }
        }

        protected class DupeStyleListener
        extends AbstractAction {
            protected DupeStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                VisualStyle clone = null;
                try {
                    clone = (VisualStyle)StyleSelector.this.currentStyle.clone();
                }
                catch (CloneNotSupportedException exc) {
                    System.err.println("Clone not supported exception!");
                }
                String newName = StyleSelector.this.getStyleName(clone);
                if (newName == null) {
                    return;
                }
                clone.setName(newName);
                StyleSelector.this.catalog.addVisualStyle(clone);
                StyleSelector.this.currentStyle = clone;
                StyleSelector.this.resetStyles();
                ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
            }
        }

        protected class RmStyleListener
        extends AbstractAction {
            protected RmStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (((StyleSelector)StyleSelector.this).VizMapUI.this.styles.size() == 1) {
                    JOptionPane.showMessageDialog(StyleSelector.this.myself, "There must be at least one visual style", "Cannot remove style", 0);
                    return;
                }
                String styleName = StyleSelector.this.currentStyle.getName();
                String checkString = "Are you sure you want to permanently delete the visual style named '" + styleName + "'?";
                int ich = JOptionPane.showConfirmDialog(StyleSelector.this.myself, checkString, "Confirm Delete Style", 0);
                if (ich == 0) {
                    StyleSelector.this.catalog.removeVisualStyle(StyleSelector.this.currentStyle.getName());
                    StyleSelector.this.currentStyle = StyleSelector.this.catalog.getVisualStyle("default");
                    if (StyleSelector.this.currentStyle == null) {
                        StyleSelector.this.currentStyle = (VisualStyle)((StyleSelector)StyleSelector.this).VizMapUI.this.styles.iterator().next();
                    }
                    StyleSelector.this.resetStyles();
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
                }
            }
        }

        protected class RenStyleListener
        extends AbstractAction {
            protected RenStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String name = StyleSelector.this.getStyleName(StyleSelector.this.currentStyle);
                if (name == null) {
                    return;
                }
                StyleSelector.this.currentStyle.setName(name);
                StyleSelector.this.resetStyles();
            }
        }

        protected class NewStyleListener
        extends AbstractAction {
            protected NewStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String name = StyleSelector.this.getStyleName(null);
                if (name == null) {
                    return;
                }
                StyleSelector.this.currentStyle = new VisualStyle(name);
                StyleSelector.this.catalog.addVisualStyle(StyleSelector.this.currentStyle);
                StyleSelector.this.resetStyles();
                ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.getNetworkView().redrawGraph(false, true);
            }
        }

        protected class DefStyleListener
        extends AbstractAction {
            protected DefStyleListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (StyleSelector.this.styleDefNeedsUpdate) {
                    StyleSelector.this.styleDefUI.visualStyleChanged();
                    StyleSelector.this.styleDefNeedsUpdate = false;
                }
                StyleSelector.this.styleDefUI.show();
            }
        }
    }
}

