/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.AbstractCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeFontFaceCalculator;
import cytoscape.visual.calculators.GenericEdgeFontSizeCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericEdgeToolTipCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeFontFaceCalculator;
import cytoscape.visual.calculators.GenericNodeFontSizeCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.GenericNodeSizeCalculator;
import cytoscape.visual.calculators.GenericNodeToolTipCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.ui.ValueDisplayer;
import cytoscape.visual.ui.VizMapTab;
import cytoscape.visual.ui.VizMapUI;
import cytoscape.visual.ui.VizUIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VizMapAttrTab
extends VizMapTab {
    private CalculatorCatalog catalog;
    private VisualMappingManager VMM;
    private byte type;
    private Calculator currentCalculator;
    private VizMapUI mainUIDialog;
    private ValueDisplayer defaultValueDisplayer;
    private JComboBox calcComboBox;
    private GridBagGroup mapPanelGBG;
    private JPanel calcContainer;
    private JPanel calcPanel;
    protected CalculatorUIListener calcListener = new CalculatorUIListener();
    static /* synthetic */ Class class$java$lang$Object;

    public VizMapAttrTab(VizMapUI mainUI, JTabbedPane tabContainer, int tabIndex, VisualMappingManager VMM, byte type) {
        super(new BorderLayout(), false);
        this.setName(VizMapAttrTab.getTypeName(type));
        this.VMM = VMM;
        this.mainUIDialog = mainUI;
        this.catalog = VMM.getCalculatorCatalog();
        this.type = type;
        this.catalog.addChangeListener(new CatalogListener(), this.type);
        tabContainer.addChangeListener(new TabContainerListener(tabIndex));
    }

    public void visualStyleChanged() {
        Object defaultObj = VizUIUtilities.getDefault(this.VMM.getVisualStyle(), this.type);
        this.setCurrentCalculator(VizUIUtilities.getCurrentCalculator(this.VMM.getVisualStyle(), this.type));
        if (this.defaultValueDisplayer == null) {
            this.drawDefault(defaultObj);
            this.drawCalc();
            this.refreshUI();
        } else {
            this.defaultValueDisplayer.setObject(defaultObj);
            this.refreshUI();
        }
    }

    public void refreshUI() {
        if (this.calcPanel != null) {
            this.calcContainer.remove(this.calcPanel);
        }
        if (this.currentCalculator != null) {
            this.calcPanel = this.currentCalculator.getUI(this.mainUIDialog, this.VMM.getNetwork());
            this.calcContainer.add(this.calcPanel);
        } else {
            this.calcPanel = null;
        }
        this.validate();
        this.repaint();
    }

    protected void setCurrentCalculator(Calculator newCalculator) {
        if (this.currentCalculator != null) {
            this.currentCalculator.removeChangeListener(this.calcListener);
        }
        this.currentCalculator = newCalculator;
        if (newCalculator != null) {
            newCalculator.addChangeListener(this.calcListener);
        }
    }

    protected void drawDefault(Object defaultObj) {
        JPanel outerDefPanel = new JPanel(false);
        outerDefPanel.setLayout(new BoxLayout(outerDefPanel, 0));
        JPanel defPanel = new JPanel(false);
        defPanel.setLayout(new BoxLayout(defPanel, 1));
        Box content = new Box(0);
        this.defaultValueDisplayer = ValueDisplayer.getDisplayFor(this.mainUIDialog, this.getName(), defaultObj);
        this.defaultValueDisplayer.addItemListener(new DefaultItemChangedListener());
        JButton defaultButton = new JButton("Change Default");
        defaultButton.addActionListener(this.defaultValueDisplayer.getInputListener());
        content.add(Box.createHorizontalGlue());
        content.add(defaultButton);
        content.add(Box.createHorizontalStrut(3));
        content.add(this.defaultValueDisplayer);
        content.add(Box.createHorizontalGlue());
        defPanel.add(Box.createVerticalStrut(3));
        defPanel.add(content);
        defPanel.add(Box.createVerticalStrut(3));
        Border defBorder = BorderFactory.createLineBorder(Color.BLACK);
        defPanel.setBorder(BorderFactory.createTitledBorder(defBorder, "Default", 2, 2));
        defPanel.validate();
        ImageIcon imageIcon = this.getImageIcon();
        if (imageIcon == null) {
            this.add((Component)defPanel, "North");
        } else {
            JButton tempB = new JButton();
            tempB.setIcon(imageIcon);
            outerDefPanel.add(tempB);
            outerDefPanel.add(defPanel);
            this.add((Component)outerDefPanel, "North");
        }
    }

    protected ImageIcon getImageIcon() {
        ImageIcon icon = null;
        if (this.type == 0) {
            String imageFile = "images/nodeColorWheel.jpg";
            icon = new ImageIcon(this.getClass().getResource(imageFile), "Node Color");
        } else if (this.type == 1) {
            String imageFile = "images/nodeBorderColorWheel.jpg";
            icon = new ImageIcon(this.getClass().getResource(imageFile), "Node Border Color");
        }
        return icon;
    }

    protected void rebuildCalcComboBox() {
        if (this.calcComboBox != null) {
            this.mapPanelGBG.panel.remove(this.calcComboBox);
        }
        Collection calculators = this.getCalculators(this.type);
        Vector<Object> comboCalcs = new Vector<Object>(calculators);
        if (this.currentCalculator != null && !calculators.contains(this.currentCalculator)) {
            comboCalcs.add(this.currentCalculator);
        }
        comboCalcs.add(0, new String("None"));
        this.calcComboBox = new JComboBox(comboCalcs);
        if (this.currentCalculator == null) {
            this.calcComboBox.setSelectedIndex(0);
        } else {
            this.calcComboBox.setSelectedItem(this.currentCalculator);
        }
        MiscGB.insert(this.mapPanelGBG, this.calcComboBox, 0, 0, 4, 1, 1, 0, 2);
        this.calcComboBox.addItemListener(new CalcComboSelectionListener());
    }

    void switchCalculator(Calculator calc) {
        if (calc != null && calc.equals(this.currentCalculator)) {
            return;
        }
        this.setCurrentCalculator(calc);
        VizUIUtilities.setCurrentCalculator(this.VMM.getVisualStyle(), this.type, calc);
        this.refreshUI();
    }

    protected void drawCalc() {
        this.mapPanelGBG = new GridBagGroup("Mapping");
        MiscGB.pad(this.mapPanelGBG.constraints, 2, 2);
        MiscGB.inset(this.mapPanelGBG.constraints, 3);
        this.calcContainer = new JPanel(false);
        this.rebuildCalcComboBox();
        JButton newCalc = new JButton("New");
        newCalc.addActionListener(new NewCalcListener());
        newCalc.setToolTipText("Create a new calculator");
        MiscGB.insert(this.mapPanelGBG, newCalc, 0, 1, 1, 1, 1, 0, 2);
        JButton dupeCalc = new JButton("Duplicate");
        dupeCalc.addActionListener(new DupeCalcListener());
        dupeCalc.setToolTipText("Create a copy of this calculator");
        MiscGB.insert(this.mapPanelGBG, dupeCalc, 1, 1, 1, 1, 1, 0, 2);
        JButton renCalc = new JButton("Rename");
        renCalc.addActionListener(new RenCalcListener());
        renCalc.setToolTipText("Rename this calculator");
        MiscGB.insert(this.mapPanelGBG, renCalc, 2, 1, 1, 1, 1, 0, 2);
        JButton rmCalc = new JButton("Delete");
        rmCalc.addActionListener(new RmCalcListener());
        rmCalc.setToolTipText("Permanently delete this calculator");
        MiscGB.insert(this.mapPanelGBG, rmCalc, 3, 1, 1, 1, 1, 0, 2);
        MiscGB.insert(this.mapPanelGBG, this.calcContainer, 0, 2, 4, 1, 5, 5, 1);
        this.add((Component)this.mapPanelGBG.panel, "Center");
    }

    private Calculator duplicateCalculator(Calculator c) {
        Calculator clone = null;
        try {
            clone = (Calculator)c.clone();
        }
        catch (CloneNotSupportedException exc) {
            System.err.println("Fatal error - Calculator didn't support Cloneable");
            exc.printStackTrace();
            return null;
        }
        String newName = this.getCalculatorName(clone);
        if (newName == null) {
            return null;
        }
        clone.setName(newName);
        return clone;
    }

    private String getCalculatorName(Calculator c) {
        String newName;
        String ret;
        int alt;
        String suggestedName = null;
        if (c != null) {
            suggestedName = this.catalog.checkCalculatorName(((Object)c).toString(), this.type);
        }
        do {
            if ((ret = (String)JOptionPane.showInputDialog(this.mainUIDialog, "New name for calculator", "Calculator Name Input", 3, null, null, suggestedName)) == null) {
                return null;
            }
            newName = this.catalog.checkCalculatorName(ret, this.type);
            if (!newName.equals(ret)) continue;
            return ret;
        } while ((alt = JOptionPane.showConfirmDialog(this.mainUIDialog, "Calculator with name " + ret + " already exists,\nrename to " + newName + " okay?", "Duplicate calculator name", 0, 2, null)) != 0);
        return newName;
    }

    VizMapTab checkCalcSelected(Calculator c) {
        if (this.currentCalculator == c) {
            return this;
        }
        return null;
    }

    void setComboBox(Calculator c) {
        if (c == null) {
            this.calcComboBox.setSelectedIndex(0);
        } else {
            this.calcComboBox.setSelectedItem(c);
        }
    }

    private Collection getCalculators(byte type) {
        switch (type) {
            case 0: {
                return this.catalog.getNodeColorCalculators();
            }
            case 1: {
                return this.catalog.getNodeColorCalculators();
            }
            case 2: {
                return this.catalog.getNodeLineTypeCalculators();
            }
            case 3: {
                return this.catalog.getNodeShapeCalculators();
            }
            case 4: 
            case 126: 
            case 127: {
                return this.catalog.getNodeSizeCalculators();
            }
            case 5: {
                return this.catalog.getNodeLabelCalculators();
            }
            case 13: {
                return this.catalog.getNodeToolTipCalculators();
            }
            case 7: {
                return this.catalog.getEdgeColorCalculators();
            }
            case 8: {
                return this.catalog.getEdgeLineTypeCalculators();
            }
            case 9: {
                return this.catalog.getEdgeArrowCalculators();
            }
            case 10: {
                return this.catalog.getEdgeArrowCalculators();
            }
            case 11: {
                return this.catalog.getEdgeLabelCalculators();
            }
            case 14: {
                return this.catalog.getEdgeToolTipCalculators();
            }
            case 124: {
                return this.catalog.getEdgeFontFaceCalculators();
            }
            case 125: {
                return this.catalog.getEdgeFontSizeCalculators();
            }
            case 122: {
                return this.catalog.getNodeFontFaceCalculators();
            }
            case 123: {
                return this.catalog.getNodeFontSizeCalculators();
            }
        }
        System.err.println("WARNING: Couldn't find match for type " + type);
        return null;
    }

    protected static String getTypeName(byte type) {
        switch (type) {
            case 0: {
                return "Node Color";
            }
            case 1: {
                return "Node Border Color";
            }
            case 2: {
                return "Node Border Type";
            }
            case 3: {
                return "Node Shape";
            }
            case 127: {
                return "Node Width";
            }
            case 126: {
                return "Node Height";
            }
            case 4: {
                return "Node Size";
            }
            case 5: {
                return "Node Label";
            }
            case 13: {
                return "Node Tooltip";
            }
            case 7: {
                return "Edge Color";
            }
            case 8: {
                return "Edge Line Type";
            }
            case 9: {
                return "Edge Source Arrow";
            }
            case 10: {
                return "Edge Target Arrow";
            }
            case 11: {
                return "Edge Label";
            }
            case 14: {
                return "Edge Tooltip";
            }
            case 124: {
                return "Edge Font Face";
            }
            case 125: {
                return "Edge Font Size";
            }
            case 122: {
                return "Node Font Face";
            }
            case 6: {
                return "Node Font Size";
            }
        }
        return null;
    }

    protected class CalculatorUIListener
    implements ChangeListener {
        protected CalculatorUIListener() {
        }

        public void stateChanged(ChangeEvent e) {
            VizMapAttrTab.this.refreshUI();
            VizMapAttrTab.this.VMM.getNetworkView().redrawGraph(false, true);
        }
    }

    private class RmCalcListener
    extends AbstractAction {
        private RmCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (VizMapAttrTab.this.currentCalculator == null) {
                return;
            }
            Vector conflicts = VizMapAttrTab.this.mainUIDialog.checkCalculatorUsage(VizMapAttrTab.this.currentCalculator);
            if (conflicts.size() != 0 && (conflicts.size() != 1 || ((Vector)conflicts.get(0)).size() != 2)) {
                StringBuffer errMsg = new StringBuffer("Calculator ");
                errMsg.append(((Object)VizMapAttrTab.this.currentCalculator).toString());
                errMsg.append(" currently in use by:<br><ul>");
                for (int i = 0; i < conflicts.size(); ++i) {
                    Vector subSelect = (Vector)conflicts.get(i);
                    errMsg.append("<li>");
                    errMsg.append(subSelect.get(0));
                    errMsg.append("<ul>");
                    for (int j = 1; j < subSelect.size(); ++j) {
                        errMsg.append("<li>");
                        errMsg.append(subSelect.get(j));
                    }
                    errMsg.append("</ul>");
                }
                errMsg.append("</ul><br>Do you still want to delete this calculator?");
                JEditorPane errPane = new JEditorPane("text/html", errMsg.toString());
                errPane.setEditable(false);
                errPane.setBackground(null);
                int conf = JOptionPane.showConfirmDialog(VizMapAttrTab.this.mainUIDialog, errPane, "Calculator In Use", 0, 2);
                if (conf == 1) {
                    return;
                }
            } else {
                String s = "Are you sure you want to permanently delete this calculator?";
                int conf = JOptionPane.showConfirmDialog(VizMapAttrTab.this.mainUIDialog, s, "Confirm Remove Calculator", 0);
                if (conf == 1) {
                    return;
                }
            }
            Calculator temp = VizMapAttrTab.this.currentCalculator;
            VizMapAttrTab.this.switchCalculator(null);
            VizMapAttrTab.this.catalog.removeCalculator(temp);
        }
    }

    private class RenCalcListener
    extends AbstractAction {
        private RenCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String calcName = VizMapAttrTab.this.getCalculatorName(VizMapAttrTab.this.currentCalculator);
            if (calcName == null) {
                return;
            }
            VizMapAttrTab.this.catalog.renameCalculator(VizMapAttrTab.this.currentCalculator, calcName);
        }
    }

    private class DupeCalcListener
    extends AbstractAction {
        private DupeCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Calculator clone = VizMapAttrTab.this.duplicateCalculator(VizMapAttrTab.this.currentCalculator);
            if (clone == null) {
                return;
            }
            VizMapAttrTab.this.switchCalculator(clone);
            VizMapAttrTab.this.catalog.addCalculator(clone);
        }
    }

    private class NewCalcListener
    extends AbstractAction {
        private NewCalcListener() {
        }

        public void actionPerformed(ActionEvent e) {
            byte mapType;
            Constructor mapperCon;
            Set mapperNames = VizMapAttrTab.this.catalog.getMappingNames();
            Object[] mapperArray = mapperNames.toArray();
            String selectedMapper = (String)JOptionPane.showInputDialog(VizMapAttrTab.this.mainUIDialog, "Choose a mapper", "New Calculator", 3, null, mapperArray, mapperArray[0]);
            if (selectedMapper == null) {
                return;
            }
            String calcName = VizMapAttrTab.this.getCalculatorName(null);
            if (calcName == null) {
                return;
            }
            Class mapperClass = VizMapAttrTab.this.catalog.getMapping(selectedMapper);
            Class[] conTypes = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = VizMapAttrTab.class$("java.lang.Object")) : class$java$lang$Object, Byte.TYPE};
            try {
                mapperCon = mapperClass.getConstructor(conTypes);
            }
            catch (NoSuchMethodException exc) {
                System.err.println("Invalid mapper " + mapperClass.getName());
                JOptionPane.showMessageDialog(VizMapAttrTab.this.mainUIDialog, "Mapper " + mapperClass.getName() + " does not have an acceptable constructor. See documentation for ObjectMapper.", "Invalid Mapper", 0);
                return;
            }
            switch (VizMapAttrTab.this.type) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 124: 
                case 125: {
                    mapType = 0;
                    break;
                }
                default: {
                    mapType = 1;
                }
            }
            Object defaultObj = VizUIUtilities.getDefault(VizMapAttrTab.this.VMM.getVisualStyle(), VizMapAttrTab.this.type);
            Object[] invokeArgs = new Object[]{defaultObj, new Byte(mapType)};
            ObjectMapping mapper = null;
            try {
                mapper = (ObjectMapping)mapperCon.newInstance(invokeArgs);
            }
            catch (Exception exc) {
                System.err.println("Error creating mapping");
                JOptionPane.showMessageDialog(VizMapAttrTab.this.mainUIDialog, "Error creating mapping " + mapperClass.getName(), "Error", 0);
            }
            AbstractCalculator calc = null;
            if (VizMapAttrTab.this.type == 0 || VizMapAttrTab.this.type == 1) {
                calc = new GenericNodeColorCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 2) {
                calc = new GenericNodeLineTypeCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 3) {
                calc = new GenericNodeShapeCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 126 || VizMapAttrTab.this.type == 127 || VizMapAttrTab.this.type == 4) {
                calc = new GenericNodeSizeCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 5) {
                calc = new GenericNodeLabelCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 13) {
                calc = new GenericNodeToolTipCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 7) {
                calc = new GenericEdgeColorCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 8) {
                calc = new GenericEdgeLineTypeCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 9 || VizMapAttrTab.this.type == 10) {
                calc = new GenericEdgeArrowCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 11) {
                calc = new GenericEdgeLabelCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 14) {
                calc = new GenericEdgeToolTipCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 124) {
                calc = new GenericEdgeFontFaceCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 125) {
                calc = new GenericEdgeFontSizeCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 122) {
                calc = new GenericNodeFontFaceCalculator(calcName, mapper);
            } else if (VizMapAttrTab.this.type == 123) {
                calc = new GenericNodeFontSizeCalculator(calcName, mapper);
            }
            VizMapAttrTab.this.switchCalculator(calc);
            VizMapAttrTab.this.catalog.addCalculator(calc);
        }
    }

    private class CalcComboSelectionListener
    implements ItemListener {
        private CalcComboSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (VizMapAttrTab.this.calcComboBox.getSelectedIndex() == 0) {
                    VizMapAttrTab.this.switchCalculator(null);
                } else {
                    Object selected = VizMapAttrTab.this.calcComboBox.getSelectedItem();
                    VizMapAttrTab.this.switchCalculator((Calculator)selected);
                }
            }
        }
    }

    private class DefaultItemChangedListener
    implements ItemListener {
        private DefaultItemChangedListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() == VizMapAttrTab.this.defaultValueDisplayer && e.getStateChange() == 1) {
                Object newDefault = VizMapAttrTab.this.defaultValueDisplayer.getValue();
                VizUIUtilities.setDefault(VizMapAttrTab.this.VMM.getVisualStyle(), VizMapAttrTab.this.type, newDefault);
            }
        }
    }

    protected class TabContainerListener
    implements ChangeListener {
        protected int tabIndex;

        public TabContainerListener(int tabIndex) {
            this.tabIndex = tabIndex;
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane source = (JTabbedPane)e.getSource();
            if (source.getModel().getSelectedIndex() == this.tabIndex) {
                VizMapAttrTab.this.refreshUI();
            }
        }
    }

    private class CatalogListener
    implements ChangeListener {
        private CatalogListener() {
        }

        public void stateChanged(ChangeEvent e) {
            VizMapAttrTab.this.rebuildCalcComboBox();
            VizMapAttrTab.this.validate();
            VizMapAttrTab.this.repaint();
        }
    }
}

