/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.Arrow;
import cytoscape.visual.LineType;
import cytoscape.visual.ui.FontChooser;
import cytoscape.visual.ui.MiscDialog;
import cytoscape.visual.ui.PopupIconChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalButtonUI;

public class ValueDisplayer
extends JButton {
    public static DecimalFormat formatter = new DecimalFormat("0.0####");
    public static final byte COLOR = 0;
    public static final byte LINETYPE = 1;
    public static final byte ARROW = 2;
    public static final byte STRING = 3;
    public static final byte DOUBLE = 4;
    public static final byte NODESHAPE = 5;
    public static final byte INT = 6;
    public static final byte FONT = 7;
    protected byte dispType;
    private Object inputObj = null;
    private String title;
    private JDialog parent;
    private ActionListener inputListener;
    private boolean enabled;

    public Object getSelectedItem() {
        return this.getValue();
    }

    public Object getValue() {
        return this.inputObj;
    }

    public ActionListener getInputListener() {
        return this.inputListener;
    }

    public byte getType() {
        return this.dispType;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        super.setEnabled(b);
    }

    private ValueDisplayer(JDialog parent, String labelText, String title, byte dispType) {
        super(labelText);
        this.setBorderPainted(false);
        this.parent = parent;
        this.dispType = dispType;
        this.title = title;
    }

    private ValueDisplayer(JDialog parent, String title, byte dispType) {
        this(parent, null, title, dispType);
    }

    public static ValueDisplayer getDisplayForColor(JDialog parent, String title, Color c) {
        String dispString = "   ";
        ValueDisplayer v = new ValueDisplayer(parent, dispString, title, 0);
        v.setUI(new MetalButtonUI());
        if (c != null) {
            v.setOpaque(true);
            v.setBackground(c);
            v.inputObj = c;
        } else {
            v.setOpaque(false);
            v.setBackground(null);
            v.inputObj = null;
        }
        v.setInputColorListener();
        return v;
    }

    private void setInputColorListener() {
        this.inputListener = new ColorListener(this);
        this.addActionListener(this.inputListener);
    }

    protected void fireItemSelected() {
        this.fireItemStateChanged(new ItemEvent(this, 701, this.inputObj, 1));
    }

    public void setObject(Object o) throws ClassCastException {
        this.inputObj = o;
        if (o instanceof Icon) {
            this.setIcon((Icon)o);
        } else if (o instanceof Color) {
            this.setBackground((Color)o);
        } else if (o instanceof Font) {
            Font f = (Font)o;
            this.setFont(f);
            this.setText(f.getFontName());
        } else {
            this.setText(o.toString());
        }
    }

    private static ValueDisplayer getDisplayForFont(JDialog parent, String title, Font startFont) {
        ValueDisplayer v = new ValueDisplayer(parent, title, 7);
        v.setSelectedFont(startFont);
        v.setInputFontListener();
        return v;
    }

    private void setSelectedFont(Font f) {
        this.inputObj = f;
        String dispFontName = f.getFontName();
        this.setFont(f.deriveFont(12.0f));
        this.setText(dispFontName);
    }

    private void setInputFontListener() {
        this.inputListener = new FontListener(this);
        this.addActionListener(this.inputListener);
    }

    private static ValueDisplayer getDisplayForIcons(JDialog parent, String title, Object startObj, byte type) {
        ValueDisplayer v = new ValueDisplayer(parent, title, type);
        v.setInputIconListener(title, title, startObj, parent, type);
        return v;
    }

    private void setInputIconListener(String title, String objectName, Object startObject, JDialog parentDialog, byte type) {
        ImageIcon[] icons = null;
        HashMap iToS = null;
        HashMap sToI = null;
        MiscDialog md = new MiscDialog();
        switch (type) {
            case 2: {
                icons = md.getArrowIcons();
                iToS = MiscDialog.getArrowToStringHashMap(25);
                sToI = MiscDialog.getStringToArrowHashMap(25);
                break;
            }
            case 5: {
                icons = MiscDialog.getShapeIcons();
                iToS = MiscDialog.getShapeByteToStringHashMap();
                sToI = MiscDialog.getStringToShapeByteHashMap();
                break;
            }
            case 1: {
                icons = MiscDialog.getLineTypeIcons();
                iToS = MiscDialog.getLineTypeToStringHashMap();
                sToI = MiscDialog.getStringToLineTypeHashMap();
            }
        }
        ImageIcon currentIcon = null;
        if (startObject != null) {
            int iconIndex;
            this.setContentAreaFilled(false);
            String ltName = (String)iToS.get(startObject);
            for (iconIndex = 0; iconIndex < icons.length && !icons[iconIndex].getDescription().equals(ltName); ++iconIndex) {
            }
            if (iconIndex == icons.length) {
                System.err.println("Icon for object " + startObject + " not found!");
                iconIndex = 0;
            }
            currentIcon = icons[iconIndex];
            this.setIcon(currentIcon);
            this.inputObj = sToI.get(currentIcon.getDescription());
        }
        this.inputListener = new IconListener(title, objectName, icons, sToI, currentIcon, parentDialog, this);
        this.addActionListener(this.inputListener);
    }

    private void addStringListener(String prompt, byte type) {
        this.inputListener = new StringListener(prompt, type);
        this.addActionListener(this.inputListener);
    }

    private static ValueDisplayer getDisplayForString(JDialog parent, String title, String init) {
        ValueDisplayer v = new ValueDisplayer(parent, init, title, 3);
        v.addStringListener("Input a string:", (byte)3);
        return v;
    }

    private static ValueDisplayer getDisplayForDouble(JDialog parent, String title, double init) {
        ValueDisplayer v = new ValueDisplayer(parent, formatter.format(init), title, 4);
        v.addStringListener("Input a double:", (byte)4);
        return v;
    }

    private static ValueDisplayer getDisplayForInt(JDialog parent, String title, int init) {
        ValueDisplayer v = new ValueDisplayer(parent, Integer.toString(init), title, 6);
        v.addStringListener("Input an integer:", (byte)6);
        return v;
    }

    private void showErrorDialog(String errorMsg) {
        JOptionPane.showMessageDialog(this.parent, errorMsg, "Bad Input", 0);
    }

    public static ValueDisplayer getBlankDisplayFor(JDialog parent, String title, byte type) {
        switch (type) {
            case 0: {
                return ValueDisplayer.getDisplayForColor(parent, title, null);
            }
            case 1: {
                return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)1);
            }
            case 5: {
                return ValueDisplayer.getDisplayForIcons(parent, title, new Byte(8), (byte)5);
            }
            case 2: {
                return ValueDisplayer.getDisplayForIcons(parent, title, Arrow.NONE, (byte)2);
            }
            case 3: {
                return ValueDisplayer.getDisplayForString(parent, title, null);
            }
            case 4: {
                return ValueDisplayer.getDisplayForDouble(parent, title, 0.0);
            }
            case 6: {
                return ValueDisplayer.getDisplayForInt(parent, title, 0);
            }
            case 7: {
                return ValueDisplayer.getDisplayForFont(parent, title, new Font(null, 0, 1));
            }
        }
        throw new ClassCastException("ValueDisplayer didn't understand type flag " + type);
    }

    public static ValueDisplayer getBlankDisplayFor(JDialog parent, String title, Object sampleObj) {
        if (sampleObj instanceof Color) {
            return ValueDisplayer.getDisplayForColor(parent, title, null);
        }
        if (sampleObj instanceof LineType) {
            return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)1);
        }
        if (sampleObj instanceof Byte) {
            return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)5);
        }
        if (sampleObj instanceof Arrow) {
            return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)2);
        }
        if (sampleObj instanceof String) {
            return ValueDisplayer.getDisplayForString(parent, title, null);
        }
        if (sampleObj instanceof Number) {
            if (sampleObj instanceof Float || sampleObj instanceof Double) {
                return ValueDisplayer.getDisplayForDouble(parent, title, 0.0);
            }
            return ValueDisplayer.getDisplayForInt(parent, title, 0);
        }
        if (sampleObj instanceof Font) {
            return ValueDisplayer.getDisplayForFont(parent, title, new Font(null, 0, 1));
        }
        throw new ClassCastException("ValueDisplayer doesn't know how to display type " + sampleObj.getClass().getName());
    }

    public static ValueDisplayer getDisplayFor(JDialog parent, String title, Object o) throws ClassCastException {
        if (o instanceof Color) {
            return ValueDisplayer.getDisplayForColor(parent, title, (Color)o);
        }
        if (o instanceof LineType) {
            return ValueDisplayer.getDisplayForIcons(parent, title, o, (byte)1);
        }
        if (o instanceof Byte) {
            return ValueDisplayer.getDisplayForIcons(parent, title, o, (byte)5);
        }
        if (o instanceof Arrow) {
            return ValueDisplayer.getDisplayForIcons(parent, title, o, (byte)2);
        }
        if (o instanceof String) {
            return ValueDisplayer.getDisplayForString(parent, title, (String)o);
        }
        if (o instanceof Number) {
            if (o instanceof Float || o instanceof Double) {
                return ValueDisplayer.getDisplayForDouble(parent, title, ((Number)o).doubleValue());
            }
            return ValueDisplayer.getDisplayForInt(parent, title, ((Number)o).intValue());
        }
        if (o instanceof Font) {
            return ValueDisplayer.getDisplayForFont(parent, title, (Font)o);
        }
        throw new ClassCastException("ValueDisplayer doesn't know how to display type " + o.getClass().getName());
    }

    private class StringListener
    extends AbstractAction {
        private byte type;
        private String prompt;

        StringListener(String prompt, byte type) {
            super("ValueDisplayer StringListener");
            this.prompt = prompt;
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                block8: while (true) {
                    String ret;
                    if ((ret = (String)JOptionPane.showInputDialog(ValueDisplayer.this.parent, this.prompt, ValueDisplayer.this.title, 3, null, null, ValueDisplayer.this.inputObj)) == null) {
                        return;
                    }
                    switch (this.type) {
                        case 4: {
                            try {
                                ValueDisplayer.this.inputObj = new Double(Double.parseDouble(ret));
                                break block8;
                            }
                            catch (NumberFormatException exc) {
                                ValueDisplayer.this.showErrorDialog("That is not a valid double");
                                continue block8;
                            }
                        }
                        case 6: {
                            try {
                                ValueDisplayer.this.inputObj = new Integer(Integer.parseInt(ret));
                                break block8;
                            }
                            catch (NumberFormatException exc) {
                                ValueDisplayer.this.showErrorDialog("That is not a valid integer");
                                continue block8;
                            }
                        }
                        default: {
                            ValueDisplayer.this.inputObj = ret;
                            break block8;
                        }
                    }
                    break;
                }
                ValueDisplayer.this.setText(ValueDisplayer.this.inputObj.toString());
                ValueDisplayer.this.fireItemSelected();
            }
        }
    }

    private class IconListener
    extends AbstractAction {
        private PopupIconChooser chooser;
        private ValueDisplayer parent;
        private HashMap sToI;

        IconListener(String title, String objectName, ImageIcon[] icons, HashMap sToI, ImageIcon startIconObject, JDialog parentDialog, ValueDisplayer parent) {
            super("ValueDisplayer IconListener");
            this.chooser = new PopupIconChooser(title, objectName, icons, startIconObject, parentDialog);
            this.parent = parent;
            this.sToI = sToI;
        }

        public void actionPerformed(ActionEvent e) {
            ImageIcon icon;
            if (this.enabled && (icon = this.chooser.showDialog()) != null) {
                this.parent.setContentAreaFilled(false);
                this.parent.setIcon(icon);
                this.parent.inputObj = this.sToI.get(icon.getDescription());
                this.parent.fireItemSelected();
            }
        }
    }

    private class FontListener
    extends AbstractAction {
        ValueDisplayer parent;
        JDialog popup;

        FontListener(ValueDisplayer parent) {
            super("ValueDisplayer FontListener");
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                FontChooser chooser = new FontChooser(((Font)ValueDisplayer.this.inputObj).deriveFont(1.0f));
                this.popup = new JDialog(this.parent.parent, this.parent.title, true);
                JComboBox face = chooser.getFaceComboBox();
                face.setSelectedItem(this.parent.inputObj);
                JPanel butPanel = new JPanel(false);
                JButton okBut = new JButton("OK");
                okBut.addActionListener(new OKListener(chooser));
                JButton cancelBut = new JButton("Cancel");
                cancelBut.addActionListener(new CancelListener());
                butPanel.add(okBut);
                butPanel.add(cancelBut);
                Container content = this.popup.getContentPane();
                content.setLayout(new BorderLayout());
                content.add((Component)chooser, "Center");
                content.add((Component)butPanel, "South");
                this.popup.pack();
                this.popup.show();
            }
        }

        private class CancelListener
        extends AbstractAction {
            private CancelListener() {
            }

            public void actionPerformed(ActionEvent e) {
                FontListener.this.popup.dispose();
            }
        }

        private class OKListener
        extends AbstractAction {
            FontChooser chooser;

            private OKListener(FontChooser chooser) {
                this.chooser = chooser;
            }

            public void actionPerformed(ActionEvent e) {
                ValueDisplayer.this.setSelectedFont(this.chooser.getSelectedFont().deriveFont(12.0f));
                ValueDisplayer.this.fireItemSelected();
                FontListener.this.popup.dispose();
            }
        }
    }

    private class ColorListener
    extends AbstractAction {
        ValueDisplayer parent;

        ColorListener(ValueDisplayer parent) {
            super("ValueDisplayer ColorListener");
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            Color tempColor;
            if (this.enabled && (tempColor = JColorChooser.showDialog(this.parent.parent, this.parent.title, (Color)this.parent.inputObj)) != null) {
                this.parent.inputObj = tempColor;
                this.parent.setBackground(tempColor);
                this.parent.fireItemSelected();
            }
        }
    }
}

